/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import java.io.Serializable;
import java.util.function.Function;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.locationtech.jts.geom.LineString;

public interface EdgeSegment
extends Serializable,
GraphEntity {
    public static final Class<EdgeSegment> EDGE_SEGMENT_ID_CLASS = EdgeSegment.class;
    public static final Function<EdgeSegment, DirectedVertex> getUpstreamVertex = e -> e.getUpstreamVertex();
    public static final Function<EdgeSegment, DirectedVertex> getDownstreamVertex = e -> e.getDownstreamVertex();

    public static Function<EdgeSegment, DirectedVertex> getVertexForEdgeSegmentLambda(boolean upstreamVertex) {
        return upstreamVertex ? getUpstreamVertex : getDownstreamVertex;
    }

    public static boolean hasSegment(EdgeSegment edgeSegment, Iterable<? extends EdgeSegment> edgeSegments) {
        if (edgeSegments == null) {
            return false;
        }
        for (EdgeSegment edgeSegment2 : edgeSegments) {
            if (!edgeSegment2.equals(edgeSegment)) continue;
            return true;
        }
        return false;
    }

    default public DirectedVertex getUpstreamVertex() {
        return this.isDirectionAb() ? this.getParent().getVertexA() : this.getParent().getVertexB();
    }

    default public DirectedVertex getDownstreamVertex() {
        return this.isDirectionAb() ? this.getParent().getVertexB() : this.getParent().getVertexA();
    }

    public DirectedEdge getParent();

    default public boolean hasParent() {
        return this.getParent() != null;
    }

    public void removeParentEdge();

    public boolean isDirectionAb();

    public boolean validate();

    @Override
    public EdgeSegment shallowClone();

    @Override
    public EdgeSegment deepClone();

    public void setParent(DirectedEdge var1);

    default public Class<? extends EdgeSegment> getIdClass() {
        return EDGE_SEGMENT_ID_CLASS;
    }

    default public boolean hasParentName() {
        if (this.getParent() != null) {
            return this.getParent().hasName();
        }
        return false;
    }

    default public String getParentName() {
        if (this.getParent() != null) {
            return this.getParent().getName();
        }
        return null;
    }

    default public EdgeSegment getOppositeDirectionSegment() {
        return this == this.getParent().getEdgeSegmentAb() ? this.getParent().getEdgeSegmentBa() : this.getParent().getEdgeSegmentAb();
    }

    default public boolean isParentGeometryInSegmentDirection(boolean allowSingleVertexWithoutGeometry) {
        LineString geometry = this.getParent().getGeometry();
        if (geometry == null) {
            return false;
        }
        return this.getParent().isGeometryInAbDirection(allowSingleVertexWithoutGeometry) == this.isDirectionAb();
    }

    default public boolean isAdjacent(EdgeSegment other, boolean allowUTurn) {
        if (other == null) {
            return false;
        }
        if (other.equals(this.getOppositeDirectionSegment())) {
            return allowUTurn;
        }
        return this.getUpstreamVertex().hasEntrySegment(other) || this.getDownstreamVertex().hasExitSegment(other);
    }

    default public double getLengthKm() {
        return this.getParent().getLengthKm();
    }

    default public boolean hasGeometry() {
        return this.getParent().hasGeometry();
    }
}

