/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import java.util.Collection;
import java.util.function.Function;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.IterableUtils;

public interface DirectedVertex
extends Vertex {
    public static final Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEntryEdgeSegments = v -> v.getEntryEdgeSegments();
    public static final Function<DirectedVertex, Iterable<? extends EdgeSegment>> getExitEdgeSegments = v -> v.getExitEdgeSegments();

    public static Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsForVertexLambda(boolean entrySegments) {
        return entrySegments ? getEntryEdgeSegments : getExitEdgeSegments;
    }

    public Collection<? extends DirectedEdge> getEdges();

    public Iterable<? extends EdgeSegment> getEntryEdgeSegments();

    public Iterable<? extends EdgeSegment> getExitEdgeSegments();

    default public EdgeSegment getEdgeSegment(DirectedVertex otherVertex) {
        for (EdgeSegment edgeSegment : this.getExitEdgeSegments()) {
            if (!edgeSegment.getDownstreamVertex().equals(otherVertex)) continue;
            return edgeSegment;
        }
        for (EdgeSegment edgeSegment : this.getEntryEdgeSegments()) {
            if (!edgeSegment.getUpstreamVertex().equals(otherVertex)) continue;
            return edgeSegment;
        }
        return null;
    }

    default public boolean hasEntrySegment(EdgeSegment segment) {
        return EdgeSegment.hasSegment(segment, this.getEntryEdgeSegments());
    }

    default public boolean hasExitSegment(EdgeSegment segment) {
        return EdgeSegment.hasSegment(segment, this.getExitEdgeSegments());
    }

    default public boolean hasExitEdgeSegments() {
        return this.getExitEdgeSegments().iterator().hasNext();
    }

    default public boolean hasEntryEdgeSegments() {
        return this.getEntryEdgeSegments().iterator().hasNext();
    }

    default public int getNumberOfEntryEdgeSegments() {
        return (int)IterableUtils.sizeOfUsingLoop(this.getEntryEdgeSegments());
    }

    default public int getNumberOfExitEdgeSegments() {
        return (int)IterableUtils.sizeOfUsingLoop(this.getExitEdgeSegments());
    }
}

