/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdAble;

public interface DirectedSubGraph<V extends DirectedVertex, E extends EdgeSegment>
extends IdAble {
    public void addEdgeSegment(E var1);

    public void removeEdgeSegment(E var1);

    public boolean containsEdgeSegment(E var1);

    public long getNumberOfVertices();

    default public int getNumberOfEdgeSegments(V vertex, boolean exitSegments) {
        Iterable<? extends EdgeSegment> segments = exitSegments ? vertex.getExitEdgeSegments() : vertex.getEntryEdgeSegments();
        int numSubGraphVertexSegments = 0;
        for (EdgeSegment edgeSegment : segments) {
            if (!this.containsEdgeSegment(edgeSegment)) continue;
            ++numSubGraphVertexSegments;
        }
        return numSubGraphVertexSegments;
    }

    default public boolean isEmpty() {
        return this.getNumberOfVertices() <= 0L;
    }

    @Override
    public DirectedSubGraph<V, E> shallowClone();

    @Override
    public DirectedSubGraph<V, E> deepClone();
}

