/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import java.util.function.Function;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.EdgeSegment;

public class DirectedEdgeUtils {
    public static <E extends DirectedEdge, ES extends EdgeSegment> void updateDirectedEdgeEdgeSegments(Iterable<E> edges, Function<ES, ES> edgeSegmentToEdgeSegmentMapping, boolean removeMissingMappings) {
        boolean forceUpdateWhenReplacing = true;
        for (DirectedEdge directedEdge : edges) {
            EdgeSegment newBaSegment;
            EdgeSegment newAbSegment;
            if (directedEdge.getEdgeSegmentAb() != null && ((newAbSegment = (EdgeSegment)edgeSegmentToEdgeSegmentMapping.apply(directedEdge.getEdgeSegmentAb())) != null || removeMissingMappings)) {
                directedEdge.registerEdgeSegment(newAbSegment, true, true);
            }
            if (directedEdge.getEdgeSegmentBa() == null || (newBaSegment = (EdgeSegment)edgeSegmentToEdgeSegmentMapping.apply(directedEdge.getEdgeSegmentBa())) == null && !removeMissingMappings) continue;
            directedEdge.registerEdgeSegment(newBaSegment, false, true);
        }
    }
}

