/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;

public interface DirectedEdge
extends Edge {
    @Override
    public DirectedVertex getVertexA();

    @Override
    public DirectedVertex getVertexB();

    default public EdgeSegment registerEdgeSegment(EdgeSegment edgeSegment, boolean directionAB) {
        return this.registerEdgeSegment(edgeSegment, directionAB, false);
    }

    public EdgeSegment registerEdgeSegment(EdgeSegment var1, boolean var2, boolean var3);

    default public void removeEdgeSegments() {
        this.removeEdgeSegmentAb();
        this.removeEdgeSegmentBa();
    }

    public EdgeSegment removeEdgeSegmentAb();

    public EdgeSegment removeEdgeSegmentBa();

    public EdgeSegment getEdgeSegmentAb();

    public EdgeSegment getEdgeSegmentBa();

    public void replace(EdgeSegment var1, EdgeSegment var2);

    @Override
    public DirectedEdge shallowClone();

    @Override
    public DirectedEdge deepClone();

    default public EdgeSegment getEdgeSegment(boolean directionAb) {
        return directionAb ? this.getEdgeSegmentAb() : this.getEdgeSegmentBa();
    }

    default public boolean hasEdgeSegmentBa() {
        return this.getEdgeSegmentBa() != null;
    }

    default public boolean hasEdgeSegmentAb() {
        return this.getEdgeSegmentAb() != null;
    }

    default public boolean hasEdgeSegment() {
        return this.hasEdgeSegmentAb() || this.hasEdgeSegmentBa();
    }

    default public Collection<? extends EdgeSegment> getEdgeSegments() {
        ArrayList<EdgeSegment> edgeSegments = null;
        if (this.hasEdgeSegmentAb() || this.hasEdgeSegmentBa()) {
            edgeSegments = new ArrayList<EdgeSegment>(2);
            if (this.hasEdgeSegmentAb()) {
                edgeSegments.add(this.getEdgeSegmentAb());
            }
            if (this.hasEdgeSegmentBa()) {
                edgeSegments.add(this.getEdgeSegmentBa());
            }
        }
        return edgeSegments;
    }

    default public <T extends EdgeSegment> void forEachSegment(Consumer<T> edgeSegmentConsumer) {
        if (this.hasEdgeSegmentAb()) {
            edgeSegmentConsumer.accept(this.getEdgeSegmentAb());
        }
        if (this.hasEdgeSegmentBa()) {
            edgeSegmentConsumer.accept(this.getEdgeSegmentBa());
        }
    }

    default public EdgeSegment removeEdgeSegment(EdgeSegment edgeSegment) {
        if (!edgeSegment.getParent().equals(this)) {
            return null;
        }
        return edgeSegment.isDirectionAb() ? this.removeEdgeSegmentAb() : this.removeEdgeSegmentBa();
    }
}

