/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import java.util.Collection;
import org.goplanit.utils.graph.EdgeUtils;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.graph.directed.ConjugateEdgeSegment;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.Pair;

public interface ConjugateDirectedEdge
extends DirectedEdge {
    @Override
    public ConjugateDirectedVertex getVertexA();

    @Override
    public ConjugateDirectedVertex getVertexB();

    @Override
    public ConjugateEdgeSegment registerEdgeSegment(EdgeSegment var1, boolean var2, boolean var3);

    @Override
    public ConjugateEdgeSegment removeEdgeSegmentAb();

    @Override
    public ConjugateEdgeSegment removeEdgeSegmentBa();

    @Override
    public ConjugateEdgeSegment getEdgeSegmentAb();

    @Override
    public ConjugateEdgeSegment getEdgeSegmentBa();

    @Override
    public ConjugateDirectedEdge shallowClone();

    @Override
    public ConjugateDirectedEdge deepClone();

    @Override
    default public ConjugateEdgeSegment getEdgeSegment(boolean directionAb) {
        return directionAb ? this.getEdgeSegmentAb() : this.getEdgeSegmentBa();
    }

    default public Collection<? extends ConjugateEdgeSegment> getEdgeSegments() {
        return DirectedEdge.super.getEdgeSegments();
    }

    public Pair<? extends DirectedEdge, ? extends DirectedEdge> getOriginalAdjacentEdges();

    default public Pair<? extends EdgeSegment, ? extends EdgeSegment> getOriginalAdjacentEdgeSegments(boolean directionAb) {
        DirectedEdge startEdge = directionAb ? this.getVertexA().getOriginalEdge() : this.getVertexB().getOriginalEdge();
        DirectedEdge endEdge = directionAb ? this.getVertexB().getOriginalEdge() : this.getVertexA().getOriginalEdge();
        Vertex sharedVertex = EdgeUtils.getSharedVertex(startEdge, endEdge);
        EdgeSegment startEdgeSegment = null;
        EdgeSegment endEdgeSegment = null;
        if (startEdge != null) {
            EdgeSegment edgeSegment = startEdgeSegment = startEdge.isVertexA(sharedVertex) ? startEdge.getEdgeSegmentBa() : startEdge.getEdgeSegmentAb();
        }
        if (endEdge != null) {
            endEdgeSegment = endEdge.isVertexA(sharedVertex) ? startEdge.getEdgeSegmentAb() : startEdge.getEdgeSegmentBa();
        }
        return Pair.of(startEdgeSegment, endEdgeSegment);
    }
}

