/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.util.ArrayList;
import java.util.function.Function;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;

public class VertexUtils {
    public static <V extends Vertex, E extends Edge> void updateVertexEdges(Iterable<V> vertices, Function<E, E> edgeToEdgeMapping, boolean removeMissingMappings) {
        for (Vertex vertex : vertices) {
            ArrayList<Edge> toBeAdded = new ArrayList<Edge>(vertex.getEdges().size());
            ArrayList<Edge> toBeRemoved = new ArrayList<Edge>(vertex.getEdges().size());
            for (Edge edge : vertex.getEdges()) {
                Edge newEdge = (Edge)edgeToEdgeMapping.apply(edge);
                if (newEdge != null) {
                    toBeAdded.add(newEdge);
                }
                if (!removeMissingMappings && newEdge == null) continue;
                toBeRemoved.add(edge);
            }
            vertex.addEdges(toBeAdded);
            vertex.removeEdges(toBeRemoved);
        }
    }
}

