/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.wrapper.LongMapWrapperImpl;

public abstract class GraphEntitiesImpl<E extends GraphEntity>
extends LongMapWrapperImpl<E>
implements GraphEntities<E> {
    protected GraphEntitiesImpl(Function<E, Long> valueToKey) {
        super(new TreeMap(), valueToKey);
    }

    protected GraphEntitiesImpl(GraphEntitiesImpl<E> other, boolean deepCopy, BiConsumer<E, E> biConsumer) {
        super(other);
        if (deepCopy) {
            this.clear();
            other.forEach(v -> {
                GraphEntity copy = v.deepClone();
                this.register(copy);
                if (deepCopy && biConsumer != null) {
                    biConsumer.accept(v, copy);
                }
            });
        }
    }

    @Override
    public abstract GraphEntitiesImpl<E> shallowClone();

    @Override
    public abstract GraphEntitiesImpl<E> deepClone();

    @Override
    public abstract GraphEntitiesImpl<E> deepCloneWithMapping(BiConsumer<E, E> var1);

    @Override
    public E getByXmlId(String xmlId) {
        return (E)GraphEntities.getByXmlId(this, xmlId);
    }
}

