/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.graph.GraphEntityFactory;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.wrapper.LongMapWrapper;

public interface GraphEntities<E extends GraphEntity>
extends LongMapWrapper<E>,
Cloneable {
    public static <EE extends GraphEntity> EE getByXmlId(GraphEntities<EE> container, String xmlId) {
        return (EE)container.firstMatch(entity -> xmlId.equals(entity.getXmlId()));
    }

    public GraphEntityFactory<E> getFactory();

    public GraphEntities<E> shallowClone();

    public GraphEntities<E> deepClone();

    public GraphEntities<E> deepCloneWithMapping(BiConsumer<E, E> var1);

    public E getByXmlId(String var1);

    default public Collection<E> getByExternalId(String externalId) {
        ArrayList<GraphEntity> matches = new ArrayList<GraphEntity>(1);
        for (GraphEntity entity : this) {
            if (!entity.hasExternalId() || !entity.getExternalId().equals(externalId)) continue;
            matches.add(entity);
        }
        return matches;
    }

    default public <T extends IdAble> void forEachMatchingIdIn(Iterable<T> values, Consumer<T> consumer) {
        values.forEach(v -> {
            if (this.containsKey(v.getId())) {
                consumer.accept(v);
            }
        });
    }
}

