/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.util.function.Function;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;

public class EdgeUtils {
    public static Vertex getSharedVertex(Edge edge1, Edge edge2) {
        if (edge1 == null || edge2 == null) {
            return null;
        }
        if (edge1.getVertexA() == edge2.getVertexA() || edge1.getVertexA() == edge2.getVertexB()) {
            return edge1.getVertexA();
        }
        if (edge1.getVertexB() == edge2.getVertexA() || edge1.getVertexB() == edge2.getVertexB()) {
            return edge1.getVertexB();
        }
        return null;
    }

    public static <E extends Edge, V extends Vertex> void updateEdgeVertices(Iterable<E> edges, Function<V, V> vertexToVertexMapping, boolean replaceMissingMappings) {
        edges.forEach(edge -> {
            Vertex newVertexB;
            Vertex newVertexA = (Vertex)vertexToVertexMapping.apply(edge.getVertexA());
            if (newVertexA != null || replaceMissingMappings) {
                edge.replace(edge.getVertexA(), newVertexA);
            }
            if ((newVertexB = (Vertex)vertexToVertexMapping.apply(edge.getVertexB())) != null || replaceMissingMappings) {
                edge.replace(edge.getVertexB(), newVertexB);
            }
        });
    }
}

