/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.io.Serializable;
import org.geotools.geometry.jts.JTS;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.misc.Pair;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public interface Edge
extends Serializable,
GraphEntity {
    public static final Class<Edge> EDGE_ID_CLASS = Edge.class;

    default public boolean isVertexA(Vertex vertex) {
        return this.getVertexA() == vertex;
    }

    public LineString getGeometry();

    public void setGeometry(LineString var1);

    default public boolean populateBasicGeometry(boolean overwrite) {
        if (this.hasGeometry() && !overwrite) {
            return false;
        }
        if (this.getVertexA() == null || this.getVertexB() == null) {
            return false;
        }
        Point posA = this.getVertexA().getPosition();
        Point posB = this.getVertexB().getPosition();
        if (posA == null || posB == null) {
            return false;
        }
        this.setGeometry(PlanitJtsUtils.createLineString(posA.getCoordinate(), posB.getCoordinate()));
        return true;
    }

    public boolean removeVertex(Vertex var1);

    public Vertex getVertexA();

    public Vertex getVertexB();

    public void setName(String var1);

    public String getName();

    public void setLengthKm(double var1);

    public double getLengthKm();

    public void addInputProperty(String var1, Object var2);

    public Object getInputProperty(String var1);

    public boolean replace(Vertex var1, Vertex var2);

    @Override
    public Edge shallowClone();

    @Override
    public Edge deepClone();

    public boolean validate();

    default public Class<? extends Edge> getIdClass() {
        return EDGE_ID_CLASS;
    }

    default public boolean hasName() {
        return this.getName() != null && !this.getName().isBlank();
    }

    default public boolean hasVertex(Vertex vertex) {
        return this.getVertexA().equals(vertex) || this.getVertexB().equals(vertex);
    }

    default public boolean hasVertexA() {
        return this.getVertexA() != null;
    }

    default public boolean hasVertexB() {
        return this.getVertexB() != null;
    }

    default public boolean hasVertices() {
        return this.hasVertexA() && this.hasVertexB();
    }

    default public boolean hasGeometry() {
        return this.getGeometry() != null;
    }

    default public boolean isGeometryInAbDirection() {
        return this.isGeometryInAbDirection(false);
    }

    default public boolean isGeometryInAbDirection(boolean allowSingleVertexWithoutGeometry) {
        boolean isVertexBStartPoint;
        boolean isVertexBEndPoint;
        boolean vertexAHasGeometry = this.getVertexA().hasPosition();
        boolean vertexBHasGeometry = this.getVertexB().hasPosition();
        if (!vertexAHasGeometry && !vertexBHasGeometry) {
            throw new PlanItRunTimeException("Unable to identify direction as both vertices of edge %s have no geometry", this.getIdsAsString());
        }
        if (!(allowSingleVertexWithoutGeometry || vertexAHasGeometry && vertexBHasGeometry)) {
            throw new PlanItRunTimeException("One of the vertices has no geometry for edge %s, this is not allowed", this.getIdsAsString());
        }
        boolean isVertexAStartPoint = vertexAHasGeometry ? this.getGeometry().getStartPoint().getCoordinate().equals2D(this.getVertexA().getPosition().getCoordinate(), 1.0E-6) : false;
        boolean bl = isVertexBEndPoint = vertexBHasGeometry ? this.getGeometry().getEndPoint().getCoordinate().equals2D(this.getVertexB().getPosition().getCoordinate(), 1.0E-6) : false;
        if (isVertexAStartPoint && isVertexBEndPoint) {
            return true;
        }
        if (isVertexAStartPoint && !vertexBHasGeometry) {
            return true;
        }
        if (isVertexBEndPoint && !vertexAHasGeometry) {
            return true;
        }
        boolean isVertexAEndPoint = vertexBHasGeometry ? this.getGeometry().getStartPoint().getCoordinate().equals2D(this.getVertexB().getPosition().getCoordinate(), 1.0E-6) : false;
        boolean bl2 = isVertexBStartPoint = vertexAHasGeometry ? this.getGeometry().getEndPoint().getCoordinate().equals2D(this.getVertexA().getPosition().getCoordinate(), 1.0E-6) : false;
        if (isVertexBStartPoint && isVertexAEndPoint) {
            return false;
        }
        throw new PlanItRunTimeException("Unable to identify direction as vertex locations do not match internal geometry of edge within reason it appears");
    }

    default public void transformGeometry(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        this.setGeometry((LineString)JTS.transform((Geometry)this.getGeometry(), (MathTransform)transformer));
    }

    default public Geometry updateGeometryInjectCoordinateAtProjectedLocation(LinearLocation projectedLinearLocation) {
        LineString oldGeometry = this.getGeometry();
        Pair<LineString, LineString> splitLineString = PlanitJtsUtils.splitLineString(this.getGeometry(), projectedLinearLocation);
        LineString linkGeometryWithExplicitProjectedCoordinate = PlanitJtsUtils.mergeLineStrings(splitLineString.first(), splitLineString.second());
        this.setGeometry(linkGeometryWithExplicitProjectedCoordinate);
        return oldGeometry;
    }

    default public Envelope createEnvelope() {
        if (this.hasGeometry()) {
            return this.getGeometry().getEnvelopeInternal();
        }
        return null;
    }
}

