/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Vertex;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitJtsCrsUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitJtsCrsUtils.class.getCanonicalName());
    protected final CoordinateReferenceSystem crs;
    protected final GeodeticCalculator geoCalculator;
    protected static final GeometryFactory jtsGeometryFactory;
    public static final DefaultGeographicCRS DEFAULT_GEOGRAPHIC_CRS;
    public static final CoordinateReferenceSystem CARTESIANCRS;

    public PlanitJtsCrsUtils() {
        this((CoordinateReferenceSystem)DEFAULT_GEOGRAPHIC_CRS);
    }

    public PlanitJtsCrsUtils(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
        this.geoCalculator = !coordinateReferenceSystem.equals(CARTESIANCRS) ? new GeodeticCalculator(this.getCoordinateReferenceSystem()) : null;
    }

    public double getClosestExistingCoordinateDistanceInMeters(Coordinate coord, Geometry geometry) {
        if (geometry != null) {
            return this.getDistanceInMetres(this.getClosestExistingCoordinateToPoint(coord, geometry), coord);
        }
        return Double.POSITIVE_INFINITY;
    }

    public Coordinate getClosestExistingCoordinateToPoint(Coordinate coord, Geometry geometry) {
        double minDistanceMetersToCoordinate = Double.POSITIVE_INFINITY;
        Coordinate closestCoordinate = null;
        if (geometry != null) {
            Coordinate[] coordinates = geometry.getCoordinates();
            for (int index = 0; index < coordinates.length; ++index) {
                Coordinate coordinate = coordinates[index];
                double distanceMeters = this.getDistanceInMetres(coord, coordinate);
                if (!(minDistanceMetersToCoordinate > distanceMeters)) continue;
                minDistanceMetersToCoordinate = distanceMeters;
                closestCoordinate = coordinate;
            }
        }
        return closestCoordinate;
    }

    public <T extends LineString> Coordinate getClosestExistingLineStringCoordinateToGeometry(Geometry referenceGeometry, T lineString) {
        return this.getClosestExistingLineStringCoordinateToGeometry(referenceGeometry, lineString, 0, lineString.getNumPoints() - 1);
    }

    public <T extends LineString> Coordinate getClosestExistingLineStringCoordinateToGeometry(Geometry referenceGeometry, T lineString, int startIndex, int endIndex) {
        double minDistanceMetersToCoordinate = Double.POSITIVE_INFINITY;
        Coordinate closestCoordinate = null;
        for (int index = startIndex; index <= endIndex; ++index) {
            Coordinate coordinate = lineString.getCoordinateN(index);
            Coordinate closestProjectedReferenceCoordinate = this.getClosestProjectedCoordinateOnGeometry(coordinate, referenceGeometry);
            double distanceMeters = this.getDistanceInMetres(closestProjectedReferenceCoordinate, coordinate);
            if (!(minDistanceMetersToCoordinate > distanceMeters)) continue;
            minDistanceMetersToCoordinate = distanceMeters;
            closestCoordinate = coordinate;
        }
        return closestCoordinate;
    }

    private Coordinate getClosestExistingPolygonCoordinateToGeometry(Geometry referenceGeometry, Polygon polygon) {
        LinearRing exteriorGeometry = polygon.getExteriorRing();
        return this.getClosestExistingLineStringCoordinateToGeometry(referenceGeometry, exteriorGeometry);
    }

    public LinearLocation getClosestProjectedLinearLocationOnGeometry(Coordinate reference, Geometry geometry) {
        if (geometry instanceof Point) {
            throw new PlanItRunTimeException("Cannot create linear Location from a single point");
        }
        if (geometry instanceof LineString) {
            return this.getClosestProjectedLinearLocationOnLineString(reference, (LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.getClosestProjectedLinearLocationOnPolygon(reference, (Polygon)geometry);
        }
        throw new PlanItRunTimeException("Method getClosestLinearLocationOnGeometry not supported for provided geometry type %s", geometry.getClass().getName());
    }

    public LinearLocation getClosestProjectedLinearLocationOnLineString(Coordinate referenceCoordinate, LineString lineString) {
        LocationIndexedLine locIndexedLine = new LocationIndexedLine((Geometry)lineString);
        return locIndexedLine.project(referenceCoordinate);
    }

    public LinearLocation getClosestProjectedLinearLocationOnPolygon(Coordinate referenceCoordinate, Polygon polygon) {
        PlanItRunTimeException.throwIfNull(referenceCoordinate, "Provided coordinate is null when computing closest location to given coordinate");
        PlanItRunTimeException.throwIfNull(polygon, "Provided polygon is null when computing closest location to given coordinate");
        PlanItRunTimeException.throwIfNull(polygon.getNumPoints() < 2, "Provided polygon has too few coordinates");
        double minDistanceMeters = Double.POSITIVE_INFINITY;
        LinearLocation closestLinearLocation = null;
        Coordinate[] polygonCoordinates = polygon.getExteriorRing().getCoordinates();
        Coordinate prevCoordinate = polygonCoordinates[0];
        for (int index = 1; index < polygonCoordinates.length; ++index) {
            Coordinate currCoordinate = polygonCoordinates[index];
            Coordinate[] coordinateArray = new Coordinate[]{prevCoordinate, currCoordinate};
            LineString lineString = jtsGeometryFactory.createLineString(coordinateArray);
            LinearLocation linearLocation = this.getClosestProjectedLinearLocationOnLineString(referenceCoordinate, lineString);
            double distanceMeters = this.getDistanceInMetres(linearLocation.getCoordinate((Geometry)lineString), referenceCoordinate);
            if (!(distanceMeters < minDistanceMeters)) continue;
            minDistanceMeters = distanceMeters;
            closestLinearLocation = linearLocation;
        }
        return closestLinearLocation;
    }

    public LinearLocation getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(Geometry referenceGeometry, LineString linearGeometry) {
        double minDistanceMetersToCoordinate = Double.POSITIVE_INFINITY;
        LinearLocation closestLocation = null;
        Coordinate[] referenceGeometryCoordinates = referenceGeometry.getCoordinates();
        for (int index = 0; index < referenceGeometry.getNumPoints(); ++index) {
            Coordinate referenceCoordinate = referenceGeometryCoordinates[index];
            LinearLocation location = this.getClosestProjectedLinearLocationOnLineString(referenceCoordinate, linearGeometry);
            double distanceMeters = this.getDistanceInMetres(location.getCoordinate((Geometry)linearGeometry), referenceCoordinate);
            if (!(minDistanceMetersToCoordinate > distanceMeters)) continue;
            minDistanceMetersToCoordinate = distanceMeters;
            closestLocation = location;
        }
        return closestLocation;
    }

    public Coordinate getClosestProjectedCoordinateOnGeometry(Coordinate reference, Geometry geometry) {
        if (geometry instanceof Point) {
            return geometry.getCoordinate();
        }
        if (geometry instanceof LineString) {
            return this.getClosestProjectedCoordinateOnLineString(reference, (LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.getClosestPojectedCoordinateOnPolygon(reference, (Polygon)geometry);
        }
        throw new PlanItRunTimeException("Method getClosestProjectedCoordinateTo not supported for provided geometry type %s", geometry.getClass().getName());
    }

    public Coordinate getClosestProjectedCoordinateOnLineString(Coordinate reference, LineString lineString) {
        return this.getClosestProjectedLinearLocationOnGeometry(reference, (Geometry)lineString).getCoordinate((Geometry)lineString);
    }

    public Coordinate getClosestPojectedCoordinateOnPolygon(Coordinate reference, Polygon polygon) {
        LinearLocation linearLocation = this.getClosestProjectedLinearLocationOnPolygon(reference, polygon);
        int lineSegmentIndex = linearLocation.getSegmentIndex();
        return linearLocation.getCoordinate((Geometry)PlanitJtsUtils.createLineString(polygon.getCoordinates()[lineSegmentIndex], polygon.getCoordinates()[lineSegmentIndex + 1]));
    }

    public double getClosestProjectedDistanceInMetersToLineString(Coordinate reference, LineString geometry) {
        return this.getDistanceInMetres(reference, this.getClosestProjectedCoordinateOnLineString(reference, geometry));
    }

    public double getClosestDistanceInMetersMultiLineString(Coordinate reference, MultiLineString geometry) {
        double minDistanceInMetersForLineSegment = Double.POSITIVE_INFINITY;
        for (int index = 0; index < geometry.getNumGeometries(); ++index) {
            LineString currLineString = (LineString)geometry.getGeometryN(index);
            minDistanceInMetersForLineSegment = Math.min(minDistanceInMetersForLineSegment, this.getClosestProjectedDistanceInMetersToLineString(reference, currLineString));
        }
        return minDistanceInMetersForLineSegment;
    }

    public double getClosestDistanceInMetersToPolygon(Coordinate reference, Polygon geometry) {
        double minDistanceInMetersForLineSegment = Double.POSITIVE_INFINITY;
        Coordinate[] coords = geometry.getCoordinates();
        if (coords != null) {
            Coordinate prevCoord = coords[0];
            for (int index = 1; index < coords.length; ++index) {
                Coordinate currCoord = coords[index];
                LineString lineSegment = PlanitJtsUtils.createLineString(prevCoord, currCoord);
                minDistanceInMetersForLineSegment = Math.min(minDistanceInMetersForLineSegment, this.getClosestDistanceInMeters(reference, (Geometry)lineSegment));
                prevCoord = currCoord;
            }
        }
        return minDistanceInMetersForLineSegment;
    }

    public double getClosestDistanceInMeters(Coordinate reference, Geometry geometry) {
        if (geometry instanceof Point) {
            return this.getClosestExistingCoordinateDistanceInMeters(reference, geometry);
        }
        if (geometry instanceof LineString) {
            return this.getClosestProjectedDistanceInMetersToLineString(reference, (LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.getClosestDistanceInMetersMultiLineString(reference, (MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.getClosestDistanceInMetersToPolygon(reference, (Polygon)geometry);
        }
        throw new PlanItRunTimeException("Unsupported geometry provided for finding closest distance to point");
    }

    public double getDistanceInMetres(Point startPosition, Point endPosition) {
        return this.getDistanceInMetres(startPosition.getCoordinate(), endPosition.getCoordinate());
    }

    public double getDistanceInMetres(Coordinate startCoordinate, Coordinate endCoordinate) {
        if (startCoordinate == null) {
            throw new PlanItRunTimeException("Start coordinate is null when computing distance in meters between two Positions in JtsUtils");
        }
        if (endCoordinate == null) {
            throw new PlanItRunTimeException("End coordinate is null when computing distance in meters between two Positions in JtsUtils");
        }
        try {
            if (this.crs.equals(CARTESIANCRS)) {
                double deltaCoordinate0 = startCoordinate.x - endCoordinate.x;
                double deltaCoordinate1 = startCoordinate.y - endCoordinate.y;
                return Math.sqrt(Math.pow(deltaCoordinate0, 2.0) + Math.pow(deltaCoordinate1, 2.0));
            }
            return JTS.orthodromicDistance((Coordinate)startCoordinate, (Coordinate)endCoordinate, (CoordinateReferenceSystem)this.crs);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Error when computing distance in meters between two Positions in JtsUtils", e);
        }
    }

    public boolean isDistanceWithinMetres(Coordinate startCoordinate, Coordinate endCoordinate, double maxDistanceMeters) {
        return this.getDistanceInMetres(startCoordinate, endCoordinate) < maxDistanceMeters;
    }

    public boolean isDistanceWithinMetres(Point startPosition, Point endPosition, double maxDistanceMeters) {
        return this.getDistanceInMetres(startPosition, endPosition) < maxDistanceMeters;
    }

    public double getDistanceInKilometres(Point startPosition, Point endPosition) {
        return this.getDistanceInMetres(startPosition, endPosition) / 1000.0;
    }

    public double getDistanceInKilometres(Vertex vertex1, Vertex vertex2) {
        return this.getDistanceInKilometres(vertex1.getPosition(), vertex2.getPosition());
    }

    public Envelope createBoundingBox(double centrePointX, double centrePointY, double lengthMeters) {
        if (this.geoCalculator == null) {
            return new Envelope(centrePointX - lengthMeters, centrePointX + lengthMeters, centrePointY - lengthMeters, centrePointY + lengthMeters);
        }
        this.geoCalculator.setStartingGeographicPoint(centrePointX, centrePointY);
        this.geoCalculator.setDirection(0.0, lengthMeters);
        Point2D north = this.geoCalculator.getDestinationGeographicPoint();
        this.geoCalculator.setDirection(90.0, lengthMeters);
        Point2D east = this.geoCalculator.getDestinationGeographicPoint();
        this.geoCalculator.setDirection(180.0, lengthMeters);
        Point2D south = this.geoCalculator.getDestinationGeographicPoint();
        this.geoCalculator.setDirection(-90.0, lengthMeters);
        Point2D west = this.geoCalculator.getDestinationGeographicPoint();
        double y1 = north.getY();
        double y2 = south.getY();
        double x1 = west.getX();
        double x2 = east.getX();
        return new Envelope(x1, x2, y2, y1);
    }

    public Envelope createBoundingBox(Envelope boundingBox, double lengthMeters) {
        return this.createBoundingBox(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMaxX(), boundingBox.getMaxY(), lengthMeters);
    }

    public Envelope createBoundingBox(double minX, double minY, double maxX, double maxY, double lengthMeters) {
        Envelope localExtremeBoundingBox1 = this.createBoundingBox(minX, minY, lengthMeters);
        Envelope localExtremeBoundingBox2 = this.createBoundingBox(maxX, maxY, lengthMeters);
        localExtremeBoundingBox1.expandToInclude(localExtremeBoundingBox2.getMaxX(), localExtremeBoundingBox2.getMaxY());
        localExtremeBoundingBox1.expandToInclude(localExtremeBoundingBox2.getMinX(), localExtremeBoundingBox2.getMinY());
        return localExtremeBoundingBox1;
    }

    public double getDistanceInKilometres(LineString geometry) {
        Coordinate[] coordinates = geometry.getCoordinates();
        int numberOfCoords = coordinates.length;
        if (numberOfCoords > 1) {
            double computedLengthInMetres = 0.0;
            Coordinate previousCoordinate = coordinates[0];
            for (int index = 1; index < numberOfCoords; ++index) {
                Coordinate currentCoordinate = coordinates[index];
                computedLengthInMetres += this.getDistanceInMetres(previousCoordinate, currentCoordinate);
                previousCoordinate = currentCoordinate;
            }
            return computedLengthInMetres / 1000.0;
        }
        throw new PlanItRunTimeException("Unable to compute distance for less than two points");
    }

    public LineSegment createExtendedLineSegment(LineSegment source, double extensionInMeters, boolean extendStart, boolean extendEnd) {
        DirectPosition newStartPosition = null;
        if (extendStart) {
            newStartPosition = this.createPositionInDirection(source.p0, this.getAzimuthInDegrees(source.p1, source.p0, false), extensionInMeters);
        }
        DirectPosition newEndPosition = null;
        if (extendEnd) {
            newEndPosition = this.createPositionInDirection(source.p1, this.getAzimuthInDegrees(source.p0, source.p1, false), extensionInMeters);
        }
        Coordinate startCoordinate = newStartPosition != null ? PlanitJtsUtils.createCoordinate(newStartPosition) : source.p0;
        Coordinate endCoordinate = newEndPosition != null ? PlanitJtsUtils.createCoordinate(newEndPosition) : source.p1;
        return PlanitJtsUtils.createLineSegment(startCoordinate, endCoordinate);
    }

    private DirectPosition createPositionInDirection(Coordinate start, double azimuthInDegrees, double distanceInMeters) {
        try {
            this.geoCalculator.setStartingGeographicPoint(start.x, start.y);
            this.geoCalculator.setDirection(azimuthInDegrees, distanceInMeters);
            return this.geoCalculator.getDestinationPosition();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Unable to create a position in the desired direction", e);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double getAzimuthInDegrees(Coordinate coordinate1, Coordinate coordinate2, boolean zeroTo360) {
        this.geoCalculator.setStartingGeographicPoint(coordinate1.getX(), coordinate1.getY());
        this.geoCalculator.setDestinationGeographicPoint(coordinate2.getX(), coordinate2.getY());
        return this.geoCalculator.getAzimuth();
    }

    public Double getAzimuthInDegrees(Position position1, Position position2, boolean zeroTo360) {
        try {
            this.geoCalculator.setStartingPosition(position1);
            this.geoCalculator.setDestinationPosition(position2);
            double azimuth = this.geoCalculator.getAzimuth();
            return zeroTo360 && azimuth < 0.0 ? 360.0 + azimuth : azimuth;
        }
        catch (Exception e) {
            throw new PlanItRunTimeException(e);
        }
    }

    public DirectPosition toDirectPosition(Coordinate coordinate) {
        try {
            return JTS.toDirectPosition((Coordinate)coordinate, (CoordinateReferenceSystem)this.getCoordinateReferenceSystem());
        }
        catch (Exception e) {
            throw new PlanItRunTimeException(e);
        }
    }

    public DirectPosition toDirectPosition(Point point) {
        return this.toDirectPosition(point.getCoordinate());
    }

    public boolean isGeometryLeftOf(Geometry geometry, Coordinate coordA, Coordinate coordB) {
        if (geometry == null) {
            throw new PlanItRunTimeException("geometry null, unable to determine on which side of line AB (%s, %s) is resides", coordA.toString(), coordB.toString());
        }
        Coordinate referenceCoordinate = null;
        referenceCoordinate = geometry instanceof Point ? geometry.getCoordinate() : this.getClosestProjectedCoordinateOnGeometry(coordB, geometry);
        return PlanitJtsUtils.isCoordinateLeftOf(referenceCoordinate, coordA, coordB);
    }

    public boolean isGeometryNearBoundingBox(Geometry geometry, Envelope boundingBox, double maxDistanceMeters) {
        Polygon boundingBoxGeometry = PlanitJtsUtils.create2DPolygon(boundingBox);
        double distanceMeters = Double.POSITIVE_INFINITY;
        if (geometry instanceof Point) {
            distanceMeters = this.getClosestDistanceInMetersToPolygon(((Point)Point.class.cast(geometry)).getCoordinate(), boundingBoxGeometry);
        } else if (geometry instanceof LineString) {
            Coordinate closestCoordinate = this.getClosestExistingLineStringCoordinateToGeometry((Geometry)boundingBoxGeometry, (LineString)LineString.class.cast(geometry));
            distanceMeters = this.getClosestDistanceInMetersToPolygon(closestCoordinate, boundingBoxGeometry);
        } else if (geometry instanceof Polygon) {
            Coordinate closestCoordinate = this.getClosestExistingPolygonCoordinateToGeometry((Geometry)boundingBoxGeometry, (Polygon)Polygon.class.cast(geometry));
            distanceMeters = this.getClosestDistanceInMeters(closestCoordinate, (Geometry)boundingBoxGeometry);
        } else {
            throw new PlanItRunTimeException("Unsupported geometry type provided when checking if it is near bounding box");
        }
        return distanceMeters + 1.0E-6 <= maxDistanceMeters;
    }

    static {
        PlanitCrsUtils.silenceHsqlLogging();
        jtsGeometryFactory = JTSFactoryFinder.getGeometryFactory();
        DEFAULT_GEOGRAPHIC_CRS = DefaultGeographicCRS.WGS84;
        CARTESIANCRS = CartesianAuthorityFactory.GENERIC_2D;
    }
}

