/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;

public class PlanitGraphGeoUtils {
    static final Logger LOGGER = Logger.getLogger(PlanitGraphGeoUtils.class.getCanonicalName());

    protected static <T> Pair<T, Double> findMinimumValuePair(Map<? extends T, Double> valueMap) {
        Map.Entry minEntry = valueMap.entrySet().stream().min(Comparator.comparing(Map.Entry::getValue)).get();
        return Pair.of(minEntry.getKey(), (Double)minEntry.getValue());
    }

    protected static <T> void removePlanitEntitiesBeyondValue(Map<? extends T, Double> entitiesToFilter, Double maxValue) {
        Iterator<Map.Entry<T, Double>> iterator = entitiesToFilter.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, Double> entry = iterator.next();
            if (!(entry.getValue() - 1.0E-6 > maxValue)) continue;
            iterator.remove();
        }
    }

    protected static <T> Double findPlanitEntityDistance(Coordinate reference, T planitEntity, PlanitJtsCrsUtils geoUtils) {
        if (planitEntity instanceof Zone) {
            Coordinate closestCoordinate = geoUtils.getClosestProjectedCoordinateOnGeometry(reference, ((Zone)planitEntity).getGeometry());
            return geoUtils.getDistanceInMetres(reference, closestCoordinate);
        }
        if (planitEntity instanceof Edge) {
            return geoUtils.getClosestProjectedDistanceInMetersToLineString(reference, ((Edge)planitEntity).getGeometry());
        }
        LOGGER.warning(String.format("Unsupported planit entity to compute closest distance to %s", planitEntity.getClass().getCanonicalName()));
        return null;
    }

    protected static <T> Map<T, Double> findPlanitEntitiesDistance(Coordinate reference, Collection<? extends T> planitEntities, PlanitJtsCrsUtils geoUtils) {
        TreeMap<T, Double> distanceMap = new TreeMap<T, Double>();
        for (T entity : planitEntities) {
            distanceMap.put(entity, PlanitGraphGeoUtils.findPlanitEntityDistance(reference, entity, geoUtils));
        }
        return distanceMap;
    }

    protected static <T> Map<T, Double> findPlanitEntitiesDistance(LineString lineString, Collection<? extends T> planitEntities, PlanitJtsCrsUtils geoUtils) {
        Map<T, Double> distanceMap = null;
        int numCoordinates = lineString.getCoordinates().length;
        for (int index = 0; index < numCoordinates; ++index) {
            Coordinate coordinate = lineString.getCoordinateN(index);
            Map<T, Double> coordinateDistanceMap = PlanitGraphGeoUtils.findPlanitEntitiesDistance(coordinate, planitEntities, geoUtils);
            if (distanceMap == null) {
                distanceMap = coordinateDistanceMap;
                continue;
            }
            for (Map.Entry<T, Double> entry : coordinateDistanceMap.entrySet()) {
                if (distanceMap.containsKey(entry.getKey()) && !(distanceMap.get(entry.getKey()) > entry.getValue())) continue;
                distanceMap.put(entry.getKey(), entry.getValue());
            }
        }
        return distanceMap;
    }

    protected static <T> Set<? extends T> findPlanitEntitiesWithinDistance(LineString lineString, Collection<? extends T> planitEntities, Double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(lineString, planitEntities, geoUtils);
        PlanitGraphGeoUtils.removePlanitEntitiesBeyondValue(result, maxDistanceMeters);
        return result.keySet();
    }

    protected static <T> Set<? extends T> findPlanitEntitiesWithinDistance(Coordinate reference, Collection<? extends T> planitEntities, Double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(reference, planitEntities, geoUtils);
        PlanitGraphGeoUtils.removePlanitEntitiesBeyondValue(result, maxDistanceMeters);
        return result.keySet();
    }

    protected static <T> Pair<T, Double> findPlanitEntityClosest(Coordinate reference, Collection<? extends T> planitEntities, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<? extends T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(reference, planitEntities, geoUtils);
        return PlanitGraphGeoUtils.findMinimumValuePair(result);
    }

    protected static <T> Pair<T, Double> findPlanitEntityClosest(LineString lineString, Collection<? extends T> planitEntities, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<? extends T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(lineString, planitEntities, geoUtils);
        return PlanitGraphGeoUtils.findMinimumValuePair(result);
    }

    public static Edge findEdgeClosest(Geometry geometry, Collection<? extends Edge> edges, PlanitJtsCrsUtils geoUtils) {
        Pair<? extends Edge, Set<? extends Edge>> result = PlanitGraphGeoUtils.findEdgesClosest(geometry, edges, 0.0, geoUtils);
        return result != null ? result.first() : null;
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosest(Geometry geometry, Collection<? extends Edge> edges, double marginToClosestMeters, PlanitJtsCrsUtils geoUtils) {
        if (geometry == null || edges == null || geoUtils == null) {
            return null;
        }
        if (edges.size() == 1) {
            return Pair.of(edges.iterator().next(), null);
        }
        if (geometry instanceof Point) {
            return PlanitGraphGeoUtils.findEdgesClosestToPoint((Point)geometry, edges, marginToClosestMeters, geoUtils);
        }
        if (geometry instanceof LineString) {
            return PlanitGraphGeoUtils.findEdgesClosestToLineString((LineString)geometry, edges, marginToClosestMeters, geoUtils);
        }
        return null;
    }

    public static Edge findEdgeClosestToLineString(LineString lineString, Collection<? extends Edge> edges, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<? extends Edge, Set<? extends Edge>> result = PlanitGraphGeoUtils.findEdgesClosestToLineString(lineString, edges, 0.0, geoUtils);
        return result != null ? result.first() : null;
    }

    public static Edge findEdgeClosestToPoint(Point point, Collection<? extends Edge> edges, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<? extends Edge, Set<? extends Edge>> result = PlanitGraphGeoUtils.findEdgesClosestToPoint(point, edges, 0.0, geoUtils);
        return result != null ? result.first() : null;
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosestToLineString(LineString lineString, Collection<? extends Edge> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) {
        return PlanitGraphGeoUtils.findEdgesClosestToGeometry((Geometry)lineString, edges, bufferDistanceMeters, geoUtils);
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosestToPoint(Point point, Collection<? extends Edge> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) {
        return PlanitGraphGeoUtils.findEdgesClosestToGeometry((Geometry)point, edges, bufferDistanceMeters, geoUtils);
    }

    public static <T extends Edge> Map<T, Double> findEdgesWithinClosestDistanceDeltaToGeometry(Geometry geometry, Collection<T> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) {
        Map<T, Double> result = null;
        if (geometry instanceof Point) {
            result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(((Point)geometry).getCoordinate(), edges, geoUtils);
        } else if (geometry instanceof LineString) {
            result = PlanitGraphGeoUtils.findPlanitEntitiesDistance((LineString)geometry, edges, geoUtils);
        } else if (geometry instanceof Polygon) {
            result = PlanitGraphGeoUtils.findPlanitEntitiesDistance((LineString)((Polygon)geometry).getExteriorRing(), edges, geoUtils);
        } else {
            throw new PlanItRunTimeException("Unsupported geometry encountered when finding edges closest to geometry");
        }
        Pair<T, Double> minResult = PlanitGraphGeoUtils.findMinimumValuePair(result);
        PlanitGraphGeoUtils.removePlanitEntitiesBeyondValue(result, minResult.second() + bufferDistanceMeters);
        return result;
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosestToGeometry(Geometry geometry, Collection<? extends Edge> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) {
        Map<? extends Edge, Double> result = PlanitGraphGeoUtils.findEdgesWithinClosestDistanceDeltaToGeometry(geometry, edges, bufferDistanceMeters, geoUtils);
        Pair<? extends Edge, Double> minEntry = PlanitGraphGeoUtils.findMinimumValuePair(result);
        result.remove(minEntry.first());
        return Pair.of(minEntry.first(), new TreeSet<Edge>(result.keySet()));
    }

    public static <T extends EdgeSegment> LineSegment extractClosestLineSegmentTo(Geometry referenceGeometry, T edgeSegment, PlanitJtsCrsUtils geoUtils) {
        LineString linkSegmentGeometry = edgeSegment.getParent().getGeometry();
        if (linkSegmentGeometry == null) {
            throw new PlanItRunTimeException("Geometry not available on edge segment %d (external id %s), unable to determine closest line segment to reference geometry, this shouldn't happen", edgeSegment.getId(), edgeSegment.getExternalId());
        }
        LinearLocation linearLocation = geoUtils.getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(referenceGeometry, linkSegmentGeometry);
        boolean reverseLinearLocationGeometry = edgeSegment.isDirectionAb() != edgeSegment.getParent().isGeometryInAbDirection();
        LineSegment lineSegment = linearLocation.getSegment((Geometry)edgeSegment.getParent().getGeometry());
        if (reverseLinearLocationGeometry) {
            lineSegment.reverse();
        }
        return lineSegment;
    }

    public static boolean isVertexNearBoundingBox(Vertex node, Envelope boundingBox, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return geoUtils.isGeometryNearBoundingBox((Geometry)node.getPosition(), boundingBox, maxDistanceMeters);
    }
}

