/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;

public class PlanitEntityGeoUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitEntityGeoUtils.class.getCanonicalName());

    public static double getDistanceToZone(Coordinate coord, Zone zone, PlanitJtsCrsUtils geoUtils) {
        if (zone.hasGeometry()) {
            return geoUtils.getClosestDistanceInMeters(coord, zone.getGeometry());
        }
        if (zone.getCentroid().hasPosition()) {
            return geoUtils.getDistanceInMetres(coord, zone.getCentroid().getPosition().getCoordinate());
        }
        LOGGER.warning(String.format("Zone has no geographic information to determine closeness to coordinate %s", coord));
        return Double.POSITIVE_INFINITY;
    }

    public static double getDistanceToEdge(Coordinate coord, Edge edge, PlanitJtsCrsUtils geoUtils) {
        if (edge.hasGeometry()) {
            return geoUtils.getClosestDistanceInMeters(coord, (Geometry)edge.getGeometry());
        }
        LOGGER.warning(String.format("Edge has no geographic information to determine closeness to reference location %s", coord));
        return Double.POSITIVE_INFINITY;
    }

    public static <T> Pair<T, Double> findPlanitEntityClosest(Coordinate coord, Collection<? extends T> planitEntities, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        return PlanitEntityGeoUtils.findPlanitEntityClosest(coord, planitEntities, Double.POSITIVE_INFINITY, suppressLogging, geoUtils);
    }

    public static <T> Pair<T, Double> findPlanitEntityClosest(Coordinate coord, Collection<? extends T> planitEntities, double maxDistanceMeters, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        double minDistanceMeters;
        double distanceMeters = minDistanceMeters = Double.POSITIVE_INFINITY;
        Object closestEntity = null;
        for (T entity : planitEntities) {
            if (entity instanceof Zone) {
                distanceMeters = PlanitEntityGeoUtils.getDistanceToZone(coord, (Zone)entity, geoUtils);
            } else if (entity instanceof Edge) {
                distanceMeters = PlanitEntityGeoUtils.getDistanceToEdge(coord, (Edge)entity, geoUtils);
            } else if (entity instanceof Vertex) {
                distanceMeters = geoUtils.getDistanceInMetres(coord, ((Vertex)entity).getPosition().getCoordinate());
            } else if (!suppressLogging) {
                LOGGER.warning(String.format("Unsupported PLANit entity to compute closest distance to %s", entity.getClass().getCanonicalName()));
            }
            if (!(distanceMeters < minDistanceMeters) || !((minDistanceMeters = distanceMeters) < maxDistanceMeters)) continue;
            closestEntity = entity;
        }
        if (closestEntity != null) {
            return Pair.of(closestEntity, minDistanceMeters);
        }
        return null;
    }

    public static LineSegment extractClosestLineSegmentToGeometryFromLinkSegment(Geometry referenceGeometry, LinkSegment linkSegment, PlanitJtsCrsUtils geoUtils) {
        LineString linkSegmentGeometry = linkSegment.getParent().getGeometry();
        LinearLocation closestLinearLoc = PlanitEntityGeoUtils.extractClosestProjectedLinearLocationToGeometryFromEdge(referenceGeometry, linkSegment.getParentLink(), geoUtils);
        LineSegment lineSegment = closestLinearLoc.getSegment((Geometry)linkSegmentGeometry);
        if (linkSegment.isDirectionAb() != linkSegment.getParent().isGeometryInAbDirection()) {
            lineSegment.reverse();
        }
        return lineSegment;
    }

    public static LinearLocation extractClosestProjectedLinearLocationToGeometryFromEdge(Geometry referenceGeometry, Edge accessEdge, PlanitJtsCrsUtils geoUtils) {
        if (referenceGeometry == null) {
            throw new PlanItRunTimeException("Geometry not allowed to be null");
        }
        LinearLocation projectedLinearLocationOnLink = null;
        projectedLinearLocationOnLink = referenceGeometry instanceof Point ? geoUtils.getClosestProjectedLinearLocationOnGeometry(referenceGeometry.getCoordinate(), (Geometry)accessEdge.getGeometry()) : geoUtils.getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(referenceGeometry, accessEdge.getGeometry());
        return projectedLinearLocationOnLink;
    }
}

