/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitCrsUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitCrsUtils.class.getCanonicalName());

    protected static void silenceHsqlLogging() {
        Logger.getLogger("org.hsqldb").setLevel(Level.SEVERE);
        System.setProperty("hsqldb.reconfig_logging", "false");
        Logger.getLogger("org.geotools.referencing.factory").setLevel(Level.SEVERE);
    }

    public static CoordinateReferenceSystem createCoordinateReferenceSystem(String code) {
        PlanitCrsUtils.silenceHsqlLogging();
        CoordinateReferenceSystem crs = null;
        if (code != null) {
            try {
                crs = CRS.decode((String)code);
                if (crs == null) {
                    LOGGER.warning(String.format("Unable to decode CRS %s to coordinate reference system", code));
                }
            }
            catch (Exception e1) {
                try {
                    crs = CRS.decode((String)code, (boolean)true);
                }
                catch (Exception e2) {
                    LOGGER.warning(String.format("unable to find coordinate reference system for %s", code));
                }
            }
        }
        return crs;
    }
}

