/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import org.goplanit.utils.geo.PlanitJtsIntersectEdgeVisitor;
import org.goplanit.utils.geo.PlanitJtsIntersectZoneVisitor;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.Zones;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.Quadtree;

public class GeoContainerUtils {
    private static final Logger LOGGER = Logger.getLogger(GeoContainerUtils.class.getCanonicalName());

    public static <T extends Zone> Quadtree toGeoIndexed(Zones<T> zones) {
        Quadtree spatialZones = new Quadtree();
        for (Zone zone : zones) {
            if (zone.getEnvelope() == null) {
                LOGGER.warning(String.format("Unable to spatially index %s %s, unknown spatial features, ignored", zone.getClass().getName(), zone.getXmlId()));
                continue;
            }
            spatialZones.insert(zone.getEnvelope(), (Object)zone);
        }
        return spatialZones;
    }

    public static <T extends Edge> Quadtree toGeoIndexed(Collection<? extends GraphEntities<T>> edgesCollection) {
        Quadtree spatiallyIndexedEdges = new Quadtree();
        for (GraphEntities<Edge> graphEntities : edgesCollection) {
            graphEntities.forEach(edge -> spatiallyIndexedEdges.insert(edge.getGeometry().getEnvelope().getEnvelopeInternal(), edge));
        }
        return spatiallyIndexedEdges;
    }

    public static <T extends GraphEntities<? extends Edge>> Quadtree toGeoIndexed(T edges) {
        Quadtree spatiallyIndexedEdges = new Quadtree();
        edges.forEach(edge -> {
            if (edge.hasGeometry()) {
                spatiallyIndexedEdges.insert(edge.getGeometry().getEnvelope().getEnvelopeInternal(), edge);
            }
        });
        return spatiallyIndexedEdges;
    }

    public static <T extends Zone> Collection<T> queryZoneQuadtree(Quadtree spatialContainer, Envelope boundingBox) {
        HashSet correctZones = new HashSet();
        PlanitJtsIntersectZoneVisitor spatialZoneFilterVisitor = new PlanitJtsIntersectZoneVisitor(PlanitJtsUtils.create2DPolygon(boundingBox), correctZones);
        spatialContainer.query(boundingBox, spatialZoneFilterVisitor);
        return spatialZoneFilterVisitor.getResult();
    }

    public static <T extends Edge> Collection<T> queryEdgeQuadtree(Quadtree spatiallyIndexedEdgeTree, Envelope searchBoundingBox) {
        PlanitJtsIntersectEdgeVisitor edgevisitor = new PlanitJtsIntersectEdgeVisitor(PlanitJtsUtils.create2DPolygon(searchBoundingBox), new HashSet());
        spatiallyIndexedEdgeTree.query(searchBoundingBox, edgevisitor);
        return edgevisitor.getResult();
    }
}

