/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.event;

import java.util.HashSet;
import java.util.Set;
import org.goplanit.utils.misc.StringUtils;

public class EventType {
    private final String name;
    private static final Set<EventType> eventTypes = new HashSet<EventType>();

    private static final void registerEventType(EventType newType) {
        boolean newEntry = eventTypes.add(newType);
        if (!newEntry) {
            throw new RuntimeException(String.format("EventType %s already exists, not allowed", newType.toString()));
        }
    }

    public EventType(String eventTypeName) {
        if (StringUtils.isNullOrBlank(eventTypeName)) {
            throw new IllegalArgumentException("eventTypeName null or blank");
        }
        this.name = eventTypeName;
        EventType.registerEventType(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventType)) {
            return false;
        }
        return this.hashCode() == ((EventType)object).hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

