/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.event;

import java.util.logging.Logger;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.id.IdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public abstract class EventImpl
extends IdAbleImpl
implements Event {
    private static final Logger LOGGER = Logger.getLogger(EventImpl.class.getCanonicalName());
    private final EventType type;
    private final Object[] content;
    private final Object sourceId;

    protected Object[] getContent() {
        return this.content;
    }

    public EventImpl(EventType type, Object source, Object[] content) {
        super(IdGenerator.generateId(IdGroupingToken.collectGlobalToken(), Event.class));
        this.type = type;
        this.sourceId = source;
        this.content = content;
    }

    public EventImpl(EventType type, Object source, Object content) {
        super(IdGenerator.generateId(IdGroupingToken.collectGlobalToken(), Event.class));
        this.type = type;
        this.sourceId = source;
        this.content = new Object[]{content};
    }

    @Override
    public final Object getSource() {
        return this.sourceId;
    }

    @Override
    public final EventType getType() {
        return this.type;
    }

    @Override
    public EventImpl shallowClone() {
        LOGGER.warning("IGNORED, Events are not cloneable");
        return null;
    }

    @Override
    public EventImpl deepClone() {
        return this.shallowClone();
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.getType() + "-id:" + this.getId();
    }
}

