/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.arrays;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class ArrayUtils {
    private static final Logger LOGGER = Logger.getLogger(ArrayUtils.class.getCanonicalName());

    public static void addTo(double[] destination, double[] addToDestination, int numberOfElements) {
        if (addToDestination.length < Math.min(numberOfElements, destination.length)) {
            LOGGER.warning("addToDestination array has less elements than number of elements/destination array to add to, addTo failed");
            return;
        }
        for (int index = 0; index < numberOfElements; ++index) {
            int n = index;
            destination[n] = destination[n] + addToDestination[index];
        }
    }

    public static void addTo(double[] destination, double[] addToDestination) {
        if (addToDestination.length < destination.length) {
            LOGGER.warning("addToDestination array has less elements than destination array to add to, addTo failed");
            return;
        }
        int length = destination.length;
        for (int index = 0; index < length; ++index) {
            int n = index;
            destination[n] = destination[n] + addToDestination[index];
        }
    }

    public static void divideBy(double[] destination, double diviser, double divideByZeroResult) {
        if (diviser > 0.0) {
            int index = 0;
            while (index < destination.length) {
                int n = index++;
                destination[n] = destination[n] / diviser;
            }
        } else {
            for (int index = 0; index < destination.length; ++index) {
                destination[index] = divideByZeroResult;
            }
        }
    }

    public static void divideBy(double[] destination, double[] diviserArray, double divideByZeroResult) {
        if (diviserArray.length < destination.length) {
            LOGGER.warning("Diviser array has less elements than destination array to divide, divideBy failed");
            return;
        }
        for (int index = 0; index < destination.length; ++index) {
            double divisor = diviserArray[index];
            destination[index] = divisor > 0.0 ? destination[index] / diviserArray[index] : divideByZeroResult;
        }
    }

    public static void multiplyBy(double[] destination, double multiplicator) {
        int index = 0;
        while (index < destination.length) {
            int n = index++;
            destination[n] = destination[n] * multiplicator;
        }
    }

    public static void divideBySum(double[] destination, int divideByZeroResult) {
        ArrayUtils.divideBy(destination, ArrayUtils.sumOf(destination), (double)divideByZeroResult);
    }

    public static double sumOf(double[] array) {
        double sum = 0.0;
        for (int index = 0; index < array.length; ++index) {
            sum += array[index];
        }
        return sum;
    }

    public static double dotProduct(double[] d1, double[] d2, int numberOfElements) {
        double sum = 0.0;
        for (int index = 0; index < numberOfElements; ++index) {
            sum += d1[index] * d2[index];
        }
        return sum;
    }

    public static Object[] addtoStart(Object elementToPrepend, Object[] theArray) {
        Object[] newArray = theArray == null ? new Object[1] : Arrays.copyOf(theArray, theArray.length + 1);
        newArray[0] = elementToPrepend;
        System.arraycopy(theArray, 0, newArray, 1, theArray.length);
        return newArray;
    }

    public static double getMaximum(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        for (double entry : array) {
            max = Math.max(max, entry);
        }
        return max;
    }

    public static void loopAll(double[][] array, BiConsumer<Integer, Integer> consumer) {
        int length1 = array.length;
        for (int id1 = 0; id1 < length1; ++id1) {
            int length2 = array[id1].length;
            for (int id2 = 0; id2 < length2; ++id2) {
                consumer.accept(id1, id2);
            }
        }
    }

    public static void loopAll(double[] array, Consumer<Integer> consumer) {
        int length = array.length;
        for (int id = 0; id < length; ++id) {
            consumer.accept(id);
        }
    }

    public static <T> void loopAll(T[] array, Consumer<T> consumer) {
        int length = array.length;
        for (int index = 0; index < length; ++index) {
            consumer.accept(array[index]);
        }
    }
}

