/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import java.util.logging.Logger;
import org.goplanit.zoning.Zoning;

public class PlanitZoningUtils {
    public static final Logger LOGGER = Logger.getLogger(PlanitZoningUtils.class.getCanonicalName());

    public static void removeDanglingZones(Zoning zoning) {
        int originalNumberOfTransferZones = zoning.getTransferZones().size();
        zoning.getZoningModifier().removeDanglingZones();
        LOGGER.info(String.format("Removed dangling transfer zones, remaining number of zones %d (original: %d)", zoning.getTransferZones().size(), originalNumberOfTransferZones));
    }

    public static void removeDanglingTransferZoneGroups(Zoning zoning) {
        int originalNumberOfTransferZoneGroups = zoning.getTransferZoneGroups().size();
        zoning.getZoningModifier().removeDanglingTransferZoneGroups();
        LOGGER.info(String.format("Removed dangling transfer zone groups, remaining number of groups %d (original: %d)", zoning.getTransferZoneGroups().size(), originalNumberOfTransferZoneGroups));
    }
}

