/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PlanitTransferZoneUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitTransferZoneUtils.class.getCanonicalName());
    private static final String TRANSFERZONE_SERVICED_OSM_MODES_INPUT_PROPERTY_KEY = "osmmodes";
    private static final String TRANSFERZONE_STATION_INPUT_PROPERTY_KEY = "station";

    private static Zone findZoneClosest(OsmEntity osmEntity, Collection<? extends Zone> zones, Map<Long, OsmNode> osmNodes, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        EntityType type = Osm4JUtils.getEntityType(osmEntity);
        switch (type) {
            case Node: {
                return OsmNodeUtils.findZoneClosest((OsmNode)osmEntity, zones, suppressLogging, geoUtils);
            }
            case Way: {
                return OsmWayUtils.findZoneClosest((OsmWay)osmEntity, zones, osmNodes, suppressLogging, geoUtils);
            }
        }
        if (!suppressLogging) {
            LOGGER.warning(String.format("unsupported osm entity type when finding closest zone to %d", osmEntity.getId()));
        }
        return null;
    }

    private static void setTransferZoneStationName(TransferZone transferZone, String stationName) {
        transferZone.addInputProperty(TRANSFERZONE_STATION_INPUT_PROPERTY_KEY, (Object)stationName);
    }

    private static boolean hasTransferZoneStationName(TransferZone transferZone) {
        return PlanitTransferZoneUtils.getTransferZoneStationName(transferZone) != null;
    }

    public static TransferZone findTransferZoneClosestByTransferGroup(OsmEntity osmEntity, Collection<? extends TransferZoneGroup> transferZoneGroups, Map<Long, OsmNode> osmNodes, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        HashSet<TransferZone> closestPerGroup = new HashSet<TransferZone>();
        for (TransferZoneGroup transferZoneGroup : transferZoneGroups) {
            TransferZone closestOfGroup = (TransferZone)PlanitTransferZoneUtils.findZoneClosest(osmEntity, transferZoneGroup.getTransferZones(), osmNodes, suppressLogging, geoUtils);
            closestPerGroup.add(closestOfGroup);
        }
        return (TransferZone)PlanitTransferZoneUtils.findZoneClosest(osmEntity, closestPerGroup, osmNodes, suppressLogging, geoUtils);
    }

    public static boolean isTransferZoneAtLocation(TransferZone transferZone, Point location) throws PlanItException {
        PlanItException.throwIfNull((Object)transferZone, (String)"Transfer zone is null, unable to verify location");
        if (transferZone.hasCentroid() && transferZone.getCentroid().hasPosition()) {
            return location.equals((Geometry)transferZone.getCentroid().getPosition());
        }
        if (transferZone.hasGeometry()) {
            if (transferZone.getGeometry() instanceof Point) {
                return location.equals(transferZone.getGeometry());
            }
        } else {
            throw new PlanItException("Transferzone representing platform/pole %s has no valid geometry attached, unable to verify location", new Object[]{transferZone.getExternalId()});
        }
        return false;
    }

    public static void updateTransferZoneStationName(TransferZone transferZone, Map<String, String> tags) {
        String stationName = tags.get("name");
        if (!transferZone.hasName() && stationName != null) {
            transferZone.setName(stationName);
        }
        if (!PlanitTransferZoneUtils.hasTransferZoneStationName(transferZone)) {
            PlanitTransferZoneUtils.setTransferZoneStationName(transferZone, stationName);
        }
    }

    public static void registerOsmModesOnTransferZone(TransferZone transferZone, SortedSet<String> eligibleOsmModes) {
        if (transferZone != null && eligibleOsmModes != null) {
            transferZone.addInputProperty(TRANSFERZONE_SERVICED_OSM_MODES_INPUT_PROPERTY_KEY, eligibleOsmModes);
        }
    }

    public static SortedSet<String> getRegisteredOsmModesForTransferZone(TransferZone transferZone) {
        SortedSet eligibleOsmModes = (SortedSet)transferZone.getInputProperty(TRANSFERZONE_SERVICED_OSM_MODES_INPUT_PROPERTY_KEY);
        if (eligibleOsmModes != null) {
            return Collections.unmodifiableSortedSet(eligibleOsmModes);
        }
        return null;
    }

    public static String getTransferZoneStationName(TransferZone transferZone) {
        return (String)transferZone.getInputProperty(TRANSFERZONE_STATION_INPUT_PROPERTY_KEY);
    }

    public static EntityType transferZoneGeometryToOsmEntityType(Geometry transferZoneGeometry) {
        if (transferZoneGeometry instanceof Point) {
            return EntityType.Node;
        }
        if (transferZoneGeometry instanceof Polygon || transferZoneGeometry instanceof LineString) {
            return EntityType.Way;
        }
        throw new PlanItRunTimeException("Unknown geometry type encountered for transferZoneGeometry %s", new Object[]{transferZoneGeometry});
    }

    public static TransferZoneType extractTransferZoneTypeFromPtv1Tags(OsmNode osmNode, Map<String, String> tags) {
        if (OsmPtv1Tags.isBusStop(tags)) {
            return TransferZoneType.POLE;
        }
        if (OsmPtv1Tags.isTramStop(tags)) {
            return TransferZoneType.PLATFORM;
        }
        if (OsmPtv1Tags.isHalt(tags)) {
            return TransferZoneType.SMALL_STATION;
        }
        if (OsmPtv1Tags.isRailwayStation(tags, true)) {
            return TransferZoneType.STATION;
        }
        if (OsmPtv1Tags.isFerryTerminal(tags)) {
            return TransferZoneType.PLATFORM;
        }
        LOGGER.severe(String.format("Unable to map node %d to Ptv1 transfer zone type", osmNode.getId()));
        return TransferZoneType.UNKNOWN;
    }
}

