/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.layer.macroscopic.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class PlanitNetworkLayerUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkLayerUtils.class.getCanonicalName());

    public static List<? extends NetworkLayer> getNetworkLayersWithActiveOsmNode(long osmNodeId, LayeredNetwork<?, ?> network, OsmNetworkToZoningReaderData networkToZoningData) {
        OsmNode osmNode = networkToZoningData.getNetworkOsmNodes().get(osmNodeId);
        ArrayList<NetworkLayer> foundLayers = new ArrayList<NetworkLayer>(1);
        if (osmNode != null) {
            for (NetworkLayer networkLayer : network.getTransportLayers()) {
                if (!networkToZoningData.getNetworkLayerData(networkLayer).isOsmNodePresentInLayer(osmNode)) continue;
                foundLayers.add(networkLayer);
            }
        }
        return foundLayers;
    }

    public static boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId, LayeredNetwork<?, ?> network, OsmNetworkToZoningReaderData networkToZoningData) {
        return !PlanitNetworkLayerUtils.getNetworkLayersWithActiveOsmNode(osmNodeId, network, networkToZoningData).isEmpty();
    }

    public static boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId, LayeredNetwork<?, ?> network, OsmNetworkReaderData networkData) {
        OsmNode osmNode = networkData.getOsmNodeData().getRegisteredOsmNode(osmNodeId);
        if (osmNode != null) {
            for (NetworkLayer networkLayer : network.getTransportLayers()) {
                OsmNetworkLayerParser layerHandler = networkData.getLayerParser((MacroscopicNetworkLayerImpl)networkLayer);
                if (!layerHandler.getLayerData().isOsmNodePresentInLayer(osmNode)) continue;
                return true;
            }
        }
        return false;
    }

    public static MacroscopicLinkSegment createPopulateAndRegisterLinkSegment(MacroscopicLink link, boolean directionAb, MacroscopicLinkSegmentType linkSegmentType, Double speedLimit, Integer numLanes, MacroscopicNetworkLayer networkLayer) {
        MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)link.getEdgeSegment(directionAb);
        if (linkSegment == null) {
            linkSegment = networkLayer.getLinkSegments().getFactory().registerNew(link, directionAb, true);
            linkSegment.setXmlId(Long.toString(linkSegment.getId()));
            linkSegment.setExternalId(link.getExternalId());
            linkSegment.setPhysicalSpeedLimitKmH(speedLimit.doubleValue());
            linkSegment.setNumberOfLanes(numLanes.intValue());
        } else {
            LOGGER.warning(String.format("Already exists link segment (id:%d) between OSM nodes (%s, %s) of OSM way (%d), ignored entity", linkSegment.getId(), link.getVertexA().getExternalId(), link.getVertexB().getExternalId(), link.getExternalId()));
        }
        linkSegment.setLinkSegmentType(linkSegmentType);
        return linkSegment;
    }

    public static MacroscopicLink createPopulateAndRegisterLink(Node nodeA, Node nodeB, LineString geometry, MacroscopicNetworkLayer layer, String externalId, String name, PlanitJtsCrsUtils geoUtils) {
        double linkLength = 0.0;
        linkLength = geoUtils.getDistanceInKilometres(geometry);
        MacroscopicLink link = layer.getLinks().getFactory().registerNew(nodeA, nodeB, linkLength, true);
        link.setGeometry(geometry);
        link.setXmlId(Long.toString(link.getId()));
        link.setExternalId(externalId);
        link.setName(name);
        return link;
    }

    public static Node createAndPopulateNode(OsmNode osmNode, MacroscopicNetworkLayer networkLayer) {
        if (osmNode == null || networkLayer == null) {
            LOGGER.severe("No OSM node or network layer provided when creating new PLANit node, ignore");
            return null;
        }
        Point geometry = OsmNodeUtils.createPoint(osmNode);
        Node node = networkLayer.getNodes().getFactory().registerNew(geometry, true);
        node.setExternalId(String.valueOf(osmNode.getId()));
        return node;
    }

    public static Node createPopulateAndRegisterNode(OsmNode osmNode, MacroscopicNetworkLayer networkLayer, OsmNetworkReaderLayerData layerData) {
        Node node = PlanitNetworkLayerUtils.createAndPopulateNode(osmNode, networkLayer);
        if (node != null) {
            layerData.registerPlanitNodeByOsmNode(osmNode, node);
            layerData.getProfiler().logNodeStatus(networkLayer.getNumberOfNodes());
        }
        return node;
    }

    public static Node createPopulateAndRegisterNode(Point osmNodeLocation, MacroscopicNetworkLayer networkLayer, OsmNetworkReaderLayerData layerData) {
        Node node = networkLayer.getNodes().getFactory().registerNew(osmNodeLocation, true);
        if (node != null) {
            layerData.registerPlanitNodeByLocation(osmNodeLocation, node);
            layerData.getProfiler().logNodeStatus(networkLayer.getNumberOfNodes());
        }
        return node;
    }
}

