/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.ItemVisitor;

public class PlanitJtsIntersectOsmNodeVisitor
implements ItemVisitor {
    private static final Logger LOGGER = Logger.getLogger(PlanitJtsIntersectOsmNodeVisitor.class.getCanonicalName());
    private Collection<OsmNode> filteredResultToPopulate;
    private Polygon geometryFilter;

    public PlanitJtsIntersectOsmNodeVisitor(Polygon geometryFilter, Collection<OsmNode> filteredResultToPopulate) {
        this.geometryFilter = geometryFilter;
        this.filteredResultToPopulate = filteredResultToPopulate;
    }

    public void visitItem(Object osmNode) {
        try {
            if (this.geometryFilter.intersects((Geometry)PlanitJtsUtils.createPoint((Coordinate)OsmNodeUtils.createCoordinate((OsmNode)osmNode)))) {
                this.filteredResultToPopulate.add((OsmNode)osmNode);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public Collection<OsmNode> getResult() {
        return this.filteredResultToPopulate;
    }
}

