/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.utils.misc.StringUtils;

public class OsmTagUtils {
    private static final Logger LOGGER = Logger.getLogger(OsmTagUtils.class.getCanonicalName());
    public static final String VALUETAG_SPECIALCHAR_STRIP_REGEX = "[^\\w\\s]";

    public static boolean matchesAnyValueTag(String valueTag, String ... valueTags) {
        for (int index = 0; index < valueTags.length; ++index) {
            if (!valueTag.equals(valueTags[index])) continue;
            return true;
        }
        return false;
    }

    public static boolean keyMatchesAnyValueTag(Map<String, String> tags, String keyTag, String ... valueTags) {
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, new String[]{keyTag}, valueTags);
    }

    public static boolean anyKeyMatchesAnyValueTag(Map<String, String> tags, String[] keyTags, String ... valueTags) {
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, VALUETAG_SPECIALCHAR_STRIP_REGEX, keyTags, valueTags);
    }

    public static boolean anyKeyMatchesAnyValueTag(Map<String, String> tags, String regEx, String[] keyTags, String ... valueTags) {
        if (OsmTagUtils.containsAnyKey(tags, keyTags)) {
            for (int index = 0; index < keyTags.length; ++index) {
                String currentKey = keyTags[index];
                if (!tags.containsKey(currentKey) || !OsmTagUtils.matchesAnyValueTag(tags.get(currentKey).replaceAll(regEx, ""), valueTags)) continue;
                return true;
            }
        }
        return false;
    }

    public static String createCompositeOsmKey(String currentKey, String ... subTagConditions) {
        String compositeKey;
        String string = compositeKey = currentKey != null && !currentKey.isBlank() ? currentKey : "";
        if (subTagConditions != null) {
            for (int index = 0; index < subTagConditions.length; ++index) {
                String subTag = subTagConditions[index];
                compositeKey = subTag != null && !subTag.isBlank() ? compositeKey.concat(":").concat(subTag) : compositeKey;
            }
        }
        return compositeKey;
    }

    public static boolean containsAnyKey(Map<String, String> tags, String ... potentialKeys) {
        for (int index = 0; index < potentialKeys.length; ++index) {
            String potentialKey = potentialKeys[index];
            if (!tags.containsKey(potentialKey)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getValuesForSupportedRefKeys(Map<String, String> tags) {
        ArrayList<String> refs = new ArrayList<String>(1);
        Consumer<String> addToRefsForTag = osmRefTag -> {
            if (tags.containsKey(osmRefTag)) {
                refs.addAll(Arrays.asList(StringUtils.splitByAnythingExceptAlphaNumeric((String)((String)tags.get(osmRefTag)))));
            }
        };
        addToRefsForTag.accept("ref");
        addToRefsForTag.accept("loc_ref");
        addToRefsForTag.accept("local_ref");
        return refs;
    }

    public static Integer getValueAsInt(Map<String, String> tags, String tagKey) {
        try {
            return Integer.parseInt(tags.get(tagKey));
        }
        catch (NumberFormatException nfe) {
            LOGGER.warning(String.format("Value for tag %s is not integer, tagging error", tagKey));
            return null;
        }
    }

    public static String toConcatEqualsString(String key, String value) {
        return OsmTagUtils.toConcatWithSep(key, value, "=");
    }

    public static String toConcatWithSep(String key, String value, String sep) {
        return String.format("%s%s%s", key, sep, value);
    }
}

