/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class OsmNodeUtils {
    private static final Logger LOGGER = Logger.getLogger(OsmNodeUtils.class.getCanonicalName());

    public static Coordinate createCoordinate(OsmNode osmNode) {
        return new Coordinate(OsmNodeUtils.getX(osmNode), OsmNodeUtils.getY(osmNode));
    }

    public static Point createPoint(OsmNode osmNode) {
        return PlanitJtsUtils.createPoint((Coordinate)OsmNodeUtils.createCoordinate(osmNode));
    }

    public static Point createPoint(long osmNodeId, Map<Long, OsmNode> osmNodes) throws PlanItException {
        OsmNode osmNode = osmNodes.get(osmNodeId);
        if (osmNode != null) {
            return OsmNodeUtils.createPoint(osmNode);
        }
        return null;
    }

    public static double getX(OsmNode osmNode) {
        if (osmNode == null) {
            int n = 4;
        }
        return osmNode.getLongitude();
    }

    public static double getY(OsmNode osmNode) {
        return osmNode.getLatitude();
    }

    public static Zone findZoneWithClosestCoordinateToNode(OsmNode osmNode, Collection<? extends Zone> zones, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return OsmNodeUtils.findZoneWithClosestCoordinateToNode(osmNode, zones, Double.POSITIVE_INFINITY, geoUtils);
    }

    public static Zone findZoneWithClosestCoordinateToNode(OsmNode osmNode, Collection<? extends Zone> zones, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Zone closestZone = null;
        double minDistanceMeters = Double.POSITIVE_INFINITY;
        Point point = PlanitJtsUtils.createPoint((Number)OsmNodeUtils.getX(osmNode), (Number)OsmNodeUtils.getY(osmNode));
        for (Zone zone : zones) {
            double distanceMeters = Double.POSITIVE_INFINITY;
            if (zone.hasGeometry()) {
                Geometry zoneGeometry = zone.getGeometry();
                distanceMeters = geoUtils.getClosestExistingCoordinateDistanceInMeters(point.getCoordinate(), zoneGeometry);
            } else if (zone.getCentroid().hasPosition()) {
                distanceMeters = geoUtils.getDistanceInMetres(point.getCoordinate(), zone.getCentroid().getPosition().getCoordinate());
            } else {
                LOGGER.warning(String.format("zone has no geographic information to determine closesness to osm node %d", osmNode.getId()));
            }
            if (!(distanceMeters < minDistanceMeters) || !((minDistanceMeters = distanceMeters) < maxDistanceMeters)) continue;
            closestZone = zone;
        }
        return closestZone;
    }

    public static Zone findZoneClosest(OsmNode osmNode, Collection<? extends Zone> zones, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        return OsmNodeUtils.findZoneClosest(osmNode, zones, Double.POSITIVE_INFINITY, suppressLogging, geoUtils);
    }

    public static Zone findZoneClosest(OsmNode osmNode, Collection<? extends Zone> zones, double maxDistanceMeters, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        Pair result = PlanitEntityGeoUtils.findPlanitEntityClosest((Coordinate)OsmNodeUtils.createCoordinate(osmNode), zones, (double)maxDistanceMeters, (boolean)suppressLogging, (PlanitJtsCrsUtils)geoUtils);
        if (result != null) {
            return (Zone)result.first();
        }
        return null;
    }

    public static Coordinate findClosestProjectedCoordinateTo(OsmNode osmNode, LineString geometry, PlanitJtsCrsUtils geoUtils) {
        return geoUtils.getClosestProjectedCoordinateOnLineString(OsmNodeUtils.createCoordinate(osmNode), geometry);
    }

    public static Edge findEdgeClosest(OsmNode osmNode, Collection<? extends Edge> edges, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        return OsmNodeUtils.findEdgeClosest(osmNode, edges, Double.POSITIVE_INFINITY, suppressLogging, geoUtils);
    }

    public static Edge findEdgeClosest(OsmNode osmNode, Collection<? extends Edge> edges, double maxDistanceMeters, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        Pair result = PlanitEntityGeoUtils.findPlanitEntityClosest((Coordinate)OsmNodeUtils.createCoordinate(osmNode), edges, (double)maxDistanceMeters, (boolean)suppressLogging, (PlanitJtsCrsUtils)geoUtils);
        if (result != null) {
            return (Edge)result.first();
        }
        return null;
    }

    public static OsmNode findOsmNodeWithCoordinate2D(Coordinate coordinate, Collection<OsmNode> osmNodes) {
        for (OsmNode osmNode : osmNodes) {
            if (!OsmNodeUtils.nodeLocationEquals2D(osmNode, coordinate)) continue;
            return osmNode;
        }
        return null;
    }

    public static boolean nodeLocationEquals2D(OsmNode osmNode, Coordinate coordinate) {
        return OsmNodeUtils.createCoordinate(osmNode).equals2D(coordinate);
    }
}

