/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmRoadModeCategoryTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.osm.tags.OsmTags;
import org.goplanit.osm.tags.OsmWaterModeTags;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmModeUtils {
    private static final Logger LOGGER = Logger.getLogger(OsmModeUtils.class.getCanonicalName());

    protected static Set<String> getPrefixedOrPostfixedOsmRoadModesWithValueTag(boolean isprefix, String alteration, Map<String, String> tags, String ... modeAccessValueTags) {
        HashSet<String> foundModes = new HashSet<String>();
        Collection<String> roadModeCategories = OsmRoadModeCategoryTags.getRoadModeCategories();
        for (String roadModeCategory : roadModeCategories) {
            String compositeKey = isprefix ? OsmTagUtils.createCompositeOsmKey(alteration, roadModeCategory) : OsmTagUtils.createCompositeOsmKey(roadModeCategory, alteration);
            if (!tags.containsKey(compositeKey)) continue;
            String valueTag = tags.get(compositeKey).replaceAll("[^\\w\\s]", "");
            for (int index = 0; index < modeAccessValueTags.length; ++index) {
                if (!modeAccessValueTags[index].equals(valueTag)) continue;
                foundModes.addAll(OsmRoadModeCategoryTags.getRoadModesByCategory(roadModeCategory));
            }
        }
        Collection<String> roadModes = OsmRoadModeTags.getSupportedRoadModeTags();
        for (String roadMode : roadModes) {
            String compositeKey = isprefix ? OsmTagUtils.createCompositeOsmKey(alteration, roadMode) : OsmTagUtils.createCompositeOsmKey(roadMode, alteration);
            if (!tags.containsKey(compositeKey)) continue;
            String valueTag = tags.get(compositeKey).replaceAll("[^\\w\\s]", "");
            for (int index = 0; index < modeAccessValueTags.length; ++index) {
                if (!modeAccessValueTags[index].equals(valueTag)) continue;
                foundModes.add(roadMode);
            }
        }
        return foundModes;
    }

    protected static Set<String> getOsmModesWithValueTag(Map<String, String> tags, Collection<String> supportedOsmModes, String ... modeAccessValueTags) {
        HashSet<String> foundModes = new HashSet<String>();
        for (String osmMode : supportedOsmModes) {
            if (!tags.containsKey(osmMode)) continue;
            String valueTag = tags.get(osmMode).replaceAll("[^\\w\\s]", "");
            for (int index = 0; index < modeAccessValueTags.length; ++index) {
                if (!modeAccessValueTags[index].equals(valueTag)) continue;
                foundModes.add(osmMode);
            }
        }
        return foundModes;
    }

    protected static Set<String> collectEligibleOsmModesOnPtOsmEntity(Map<String, String> tags, Set<String> selectableOsmModes, String defaultOsmMode) {
        Set<String> explicitlyIncludedOsmModes = OsmModeUtils.getOsmModesWithValueTag(tags, selectableOsmModes, "yes");
        if (explicitlyIncludedOsmModes != null && !explicitlyIncludedOsmModes.isEmpty()) {
            Set<String> explicitlyExcludedOsmModes = OsmModeUtils.getOsmModesWithValueTag(tags, selectableOsmModes, "no");
            if (explicitlyExcludedOsmModes != null && !explicitlyExcludedOsmModes.isEmpty()) {
                explicitlyIncludedOsmModes.removeAll(explicitlyExcludedOsmModes);
            }
        } else if (defaultOsmMode != null) {
            explicitlyIncludedOsmModes = new HashSet<String>();
            explicitlyIncludedOsmModes.add(defaultOsmMode);
        }
        return explicitlyIncludedOsmModes;
    }

    public static Set<String> getOsmRoadModesWithValueTag(Map<String, String> tags, String ... modeAccessValueTags) {
        return OsmModeUtils.getPostfixedOsmRoadModesWithValueTag(null, tags, modeAccessValueTags);
    }

    public static Set<String> getOsmRailModesWithValueTag(Map<String, String> tags, String ... modeAccessValueTags) {
        return OsmModeUtils.getOsmModesWithValueTag(tags, OsmRailModeTags.getSupportedRailModeTags(), modeAccessValueTags);
    }

    public static Set<String> getPostfixedOsmRoadModesWithValueTag(String postFix, Map<String, String> tags, String ... modeAccessValueTags) {
        return OsmModeUtils.getPrefixedOrPostfixedOsmRoadModesWithValueTag(false, postFix, tags, modeAccessValueTags);
    }

    public static Collection<String> getPrefixedOsmRoadModesWithValueTag(String prefix, Map<String, String> tags, String ... modeAccessValueTags) {
        return OsmModeUtils.getPrefixedOrPostfixedOsmRoadModesWithValueTag(true, prefix, tags, modeAccessValueTags);
    }

    public static Set<String> collectEligibleOsmWaterModesOnPtOsmEntity(Map<String, String> tags, String defaultOsmMode) {
        return OsmModeUtils.collectEligibleOsmModesOnPtOsmEntity(tags, OsmWaterModeTags.getSupportedWaterModeTags(), defaultOsmMode);
    }

    public static Set<String> collectEligibleOsmRailModesOnPtOsmEntity(Map<String, String> tags, String defaultOsmMode) {
        return OsmModeUtils.collectEligibleOsmModesOnPtOsmEntity(tags, OsmRailModeTags.getSupportedRailModeTags(), defaultOsmMode);
    }

    public static Set<String> collectEligibleOsmRoadModesOnPtOsmEntity(long osmEntityId, Map<String, String> tags, String defaultOsmMode) {
        Set<String> explicitlyIncludedOsmModes = OsmModeUtils.getOsmRoadModesWithValueTag(tags, "yes");
        if (explicitlyIncludedOsmModes != null && !explicitlyIncludedOsmModes.isEmpty()) {
            Set<String> explicitlyExcludedOsmModes = OsmModeUtils.getOsmRoadModesWithValueTag(tags, "no");
            if (explicitlyExcludedOsmModes != null && !explicitlyExcludedOsmModes.isEmpty()) {
                explicitlyIncludedOsmModes.removeAll(explicitlyExcludedOsmModes);
            }
        } else if (defaultOsmMode != null) {
            explicitlyIncludedOsmModes = new HashSet<String>();
            explicitlyIncludedOsmModes.add(defaultOsmMode);
        }
        return explicitlyIncludedOsmModes;
    }

    public static Collection<String> collectEligibleOsmModesOnPtOsmEntity(long osmEntityId, Map<String, String> tags) {
        Set<String> eligibleOsmWaterModes;
        Set<String> eligibleOsmRoadModes;
        Set<String> eligibleOsmModes = null;
        Set<String> eligibleOsmRailModes = OsmModeUtils.collectEligibleOsmRailModesOnPtOsmEntity(tags, null);
        if (eligibleOsmRailModes != null && !eligibleOsmRailModes.isEmpty()) {
            eligibleOsmModes = eligibleOsmRailModes;
        }
        if ((eligibleOsmRoadModes = OsmModeUtils.collectEligibleOsmRoadModesOnPtOsmEntity(osmEntityId, tags, null)) != null && !eligibleOsmRoadModes.isEmpty()) {
            if (eligibleOsmModes != null) {
                eligibleOsmModes.addAll(eligibleOsmRoadModes);
            } else {
                eligibleOsmModes = eligibleOsmRoadModes;
            }
        }
        if ((eligibleOsmWaterModes = OsmModeUtils.collectEligibleOsmWaterModesOnPtOsmEntity(tags, null)) != null && !eligibleOsmWaterModes.isEmpty()) {
            if (eligibleOsmModes != null) {
                eligibleOsmModes.addAll(eligibleOsmWaterModes);
            } else {
                eligibleOsmModes = eligibleOsmWaterModes;
            }
        }
        return eligibleOsmModes;
    }

    public static Collection<String> collectEligibleOsmModesOnPtOsmEntity(long osmPtEntityId, Map<String, String> tags, String defaultOsmMode) {
        Collection<String> eligibleOsmModes = OsmModeUtils.collectEligibleOsmModesOnPtOsmEntity(osmPtEntityId, tags);
        if ((eligibleOsmModes == null || eligibleOsmModes.isEmpty()) && defaultOsmMode != null) {
            eligibleOsmModes = Collections.singleton(defaultOsmMode);
        }
        return eligibleOsmModes;
    }

    public static TreeSet<String> collectEligibleOsmPublicTransportModesOnPtOsmEntity(long osmPtEntityId, Map<String, String> tags, String defaultOsmMode) {
        TreeSet<String> eligibleOsmPtModes = OsmModeUtils.extractPublicTransportModesFrom(OsmModeUtils.collectEligibleOsmModesOnPtOsmEntity(osmPtEntityId, tags));
        if ((eligibleOsmPtModes == null || eligibleOsmPtModes.isEmpty()) && defaultOsmMode != null) {
            eligibleOsmPtModes = eligibleOsmPtModes == null ? new TreeSet<String>() : eligibleOsmPtModes;
            eligibleOsmPtModes.add(defaultOsmMode);
        }
        return eligibleOsmPtModes;
    }

    public static String identifyPtv1DefaultMode(long osmId, Map<String, String> tags, boolean suppressWarning) {
        return OsmModeUtils.identifyPtv1DefaultMode(osmId, tags, null, suppressWarning);
    }

    public static String identifyPtv1DefaultMode(long osmId, Map<String, String> tags) {
        return OsmModeUtils.identifyPtv1DefaultMode(osmId, tags, null, false);
    }

    public static String identifyPtv1DefaultMode(long osmId, Map<String, String> tags, String backupDefaultMode, boolean suppressWarning) {
        String foundMode = null;
        if (OsmPtv1Tags.hasPtv1ValueTag(tags)) {
            if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
                if (OsmPtv1Tags.isBusStop(tags)) {
                    foundMode = "bus";
                } else if (OsmTagUtils.keyMatchesAnyValueTag(tags, "highway", "station", "platform", "platform_edge")) {
                    foundMode = "bus";
                } else if (!suppressWarning) {
                    LOGGER.warning(String.format("Unsupported Ptv1 value tag highway=%s used when identifying default mode on OSM entity %d, ignored", tags.get("highway"), osmId));
                }
            } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
                if (OsmPtv1Tags.isTramStop(tags)) {
                    foundMode = "tram";
                } else if (OsmPtv1Tags.isSubwayStation(tags, true)) {
                    foundMode = "subway";
                } else if (OsmTagUtils.keyMatchesAnyValueTag(tags, "railway", "station", "halt", "platform", "platform_edge", "stop")) {
                    foundMode = "train";
                } else if (!suppressWarning) {
                    LOGGER.warning(String.format("Unsupported Ptv1 value tag railway=%s used when identifying default mode on OSM entity %s, ignored", tags.get("railway"), osmId));
                }
            }
        } else if (OsmTags.isAmenity(tags) || tags.containsKey("ferry")) {
            if (OsmPtv1Tags.isFerryTerminal(tags)) {
                foundMode = "ferry";
            } else if (tags.containsKey("ferry") && OsmTagUtils.keyMatchesAnyValueTag(tags, "ferry", "yes")) {
                foundMode = "ferry";
            }
        } else if (!suppressWarning) {
            LOGGER.warning(String.format("Unable to extract expected OSM mode from OSM entity %d (Ptv1), potential incomplete tagging, tags(%s)", osmId, tags));
        }
        if (foundMode == null) {
            foundMode = backupDefaultMode;
        }
        return foundMode;
    }

    public static String identifyPtv1DefaultMode(long osmId, Map<String, String> tags, String backupDefaultMode) {
        return OsmModeUtils.identifyPtv1DefaultMode(osmId, tags, backupDefaultMode, false);
    }

    public static Collection<String> extractCompatibleOsmModes(Collection<String> osmModesToCheck, Collection<String> referenceOsmModes, boolean allowPseudoMatches) {
        HashSet<String> overlappingModes = new HashSet<String>();
        if (referenceOsmModes != null) {
            if (allowPseudoMatches) {
                if (OsmRoadModeTags.containsAnyMode(referenceOsmModes)) {
                    overlappingModes.addAll(OsmRoadModeTags.getModesFrom(osmModesToCheck));
                }
                if (OsmRailModeTags.containsAnyMode(referenceOsmModes)) {
                    overlappingModes.addAll(OsmRailModeTags.getModesFrom(osmModesToCheck));
                }
                if (OsmWaterModeTags.containsAnyMode(referenceOsmModes)) {
                    overlappingModes.addAll(OsmWaterModeTags.getModesFrom(osmModesToCheck));
                }
            } else {
                overlappingModes.addAll(osmModesToCheck);
                overlappingModes.retainAll(referenceOsmModes);
            }
        }
        return overlappingModes;
    }

    public static TreeSet<String> extractPublicTransportModesFrom(Collection<String> eligibleOsmModes) {
        if (eligibleOsmModes == null) {
            return null;
        }
        TreeSet<String> railPtModes = OsmRailModeTags.getPublicTransportModesFrom(eligibleOsmModes);
        TreeSet<String> roadPtModes = OsmRoadModeTags.getPublicTransportModesFrom(eligibleOsmModes);
        TreeSet<String> waterPtModes = OsmWaterModeTags.getPublicTransportModesFrom(eligibleOsmModes);
        railPtModes.addAll(roadPtModes);
        railPtModes.addAll(waterPtModes);
        return railPtModes;
    }

    public static boolean hasEligibleOsmMode(Pair<? extends SortedSet<String>, SortedSet<PredefinedModeType>> modeResult) {
        return modeResult != null && modeResult.first() != null && !((SortedSet)modeResult.first()).isEmpty();
    }

    public static boolean hasMappedPlanitMode(Pair<? extends SortedSet<String>, SortedSet<PredefinedModeType>> modeResult) {
        return modeResult != null && modeResult.second() != null && !((SortedSet)modeResult.second()).isEmpty();
    }
}

