/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.access.OsmReader;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.pbf.seq.PbfReader;
import de.topobyte.osm4j.xml.dynsax.OsmXmlReader;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.logging.Logger;
import org.goplanit.utils.misc.FileUtils;
import org.goplanit.utils.misc.UrlUtils;

public class Osm4JUtils {
    private static final Logger LOGGER = Logger.getLogger(Osm4JUtils.class.getCanonicalName());
    public static final String OSM_XML_EXTENSION = "osm";
    public static final String OSM_PBF_EXTENSION = "pbf";

    public static OsmReader createOsm4jReader(File inputFile) {
        boolean parseMetaData = false;
        try {
            String extension;
            switch (extension = FileUtils.getExtension((File)inputFile)) {
                case "osm": {
                    return new OsmXmlReader(inputFile, false);
                }
                case "pbf": {
                    return new PbfReader(inputFile, false);
                }
            }
            LOGGER.warning(String.format("Unsupported OSM file format for file: (%s), skip parsing", inputFile));
            return null;
        }
        catch (Exception e) {
            LOGGER.warning(String.format("open street map input file does not exist: (%s) skip parsing", inputFile));
            return null;
        }
    }

    public static OsmReader createOsm4jReader(URL inputSource) {
        try {
            if (UrlUtils.isLocal((URL)inputSource)) {
                return Osm4JUtils.createOsm4jReader(Paths.get(inputSource.toURI()).toFile());
            }
            return new OsmXmlReader(inputSource.openStream(), false);
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Open street map input source could not be accessed: (%s) skip parsing", inputSource.toString()));
            return null;
        }
    }

    public static Comparator<? super OsmEntity> createOsmEntityComparator() {
        return new Comparator<OsmEntity>(){

            @Override
            public int compare(OsmEntity e1, OsmEntity e2) {
                return Long.valueOf(e1.getId()).compareTo(e2.getId());
            }
        };
    }

    public static EntityType getEntityType(OsmEntity entity) {
        if (entity instanceof OsmNode) {
            return EntityType.Node;
        }
        if (entity instanceof OsmWay) {
            return EntityType.Way;
        }
        LOGGER.severe(String.format("Unknown OSM entity %d encountered when registering transfer zone, transfer zone not registered", entity.getId()));
        return null;
    }
}

