/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.test;

import java.util.logging.Logger;
import org.goplanit.converter.intermodal.IntermodalConverter;
import org.goplanit.converter.intermodal.IntermodalConverterFactory;
import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.converter.intermodal.IntermodalWriter;
import org.goplanit.converter.network.NetworkConverter;
import org.goplanit.converter.network.NetworkConverterFactory;
import org.goplanit.converter.network.NetworkReader;
import org.goplanit.converter.network.NetworkWriter;
import org.goplanit.io.converter.intermodal.PlanitIntermodalWriter;
import org.goplanit.io.converter.intermodal.PlanitIntermodalWriterFactory;
import org.goplanit.io.converter.intermodal.PlanitIntermodalWriterSettings;
import org.goplanit.io.converter.network.PlanitNetworkWriter;
import org.goplanit.io.converter.network.PlanitNetworkWriterFactory;
import org.goplanit.osm.converter.intermodal.OsmIntermodalReader;
import org.goplanit.osm.converter.intermodal.OsmIntermodalReaderFactory;
import org.goplanit.osm.converter.intermodal.OsmIntermodalReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkReader;
import org.goplanit.osm.converter.network.OsmNetworkReaderFactory;
import org.goplanit.utils.exceptions.PlanItException;

public class Osm2PlanitConversionTemplates {
    private static final Logger LOGGER = Logger.getLogger(Osm2PlanitConversionTemplates.class.getCanonicalName());

    public static void osm2PlanitCarSimple(String inputFile, String outputPath, String countryName, Long ... excludedOsmWays) throws PlanItException {
        OsmNetworkReader osmReader = OsmNetworkReaderFactory.create(inputFile, countryName);
        osmReader.getSettings().excludeOsmWaysFromParsing(excludedOsmWays);
        osmReader.getSettings().getHighwaySettings().deactivateAllOsmRoadModesExcept("motorcar");
        osmReader.getSettings().setRemoveDanglingSubnetworks(true);
        osmReader.getSettings().setDiscardDanglingNetworksBelow(20);
        osmReader.getSettings().deactivateAllOsmWayTypesExcept("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link");
        PlanitNetworkWriter planitWriter = PlanitNetworkWriterFactory.create((String)outputPath, (String)countryName);
        NetworkConverterFactory.create((NetworkReader)osmReader, (NetworkWriter)planitWriter).convert();
    }

    public static void osm2PlanitNetworkComprehensive(String inputFile, String outputPath, String countryName) throws PlanItException {
        OsmNetworkReader osmReader = OsmNetworkReaderFactory.create(inputFile, countryName);
        osmReader.getSettings().activateRailwayParser(true);
        osmReader.getSettings().getHighwaySettings().activateAllOsmHighwayTypes();
        PlanitNetworkWriter planitWriter = PlanitNetworkWriterFactory.create((String)outputPath, (String)countryName);
        NetworkConverter theConverter = NetworkConverterFactory.create((NetworkReader)osmReader, (NetworkWriter)planitWriter);
        theConverter.convert();
    }

    public static void osm2PlanitBasicIntermodalNoServices(String inputFile, String outputPath, String countryName) throws PlanItException {
        OsmIntermodalReader osmIntermodalReader = OsmIntermodalReaderFactory.create(inputFile, countryName);
        osmIntermodalReader.getSettings().getNetworkSettings().getHighwaySettings().deactivateOsmHighwayType("cycleway");
        osmIntermodalReader.getSettings().getNetworkSettings().getHighwaySettings().deactivateOsmHighwayType("footway");
        osmIntermodalReader.getSettings().getNetworkSettings().getHighwaySettings().deactivateOsmHighwayType("pedestrian");
        osmIntermodalReader.getSettings().getNetworkSettings().activateRailwayParser(true);
        PlanitIntermodalWriter planitIntermodalWriter = PlanitIntermodalWriterFactory.create();
        planitIntermodalWriter.getSettings().setCountry(countryName);
        planitIntermodalWriter.getSettings().setOutputDirectory(outputPath);
        IntermodalConverter theConverter = IntermodalConverterFactory.create((IntermodalReader)osmIntermodalReader, (IntermodalWriter)planitIntermodalWriter);
        theConverter.convert();
    }

    public static void osm2PlanitIntermodalNoServices(OsmIntermodalReaderSettings settings, PlanitIntermodalWriterSettings writerSettings) throws PlanItException {
        OsmIntermodalReader osmReader = OsmIntermodalReaderFactory.create(settings);
        PlanitIntermodalWriter planitWriter = PlanitIntermodalWriterFactory.create((PlanitIntermodalWriterSettings)writerSettings);
        IntermodalConverter theConverter = IntermodalConverterFactory.create((IntermodalReader)osmReader, (IntermodalWriter)planitWriter);
        theConverter.convert();
    }
}

