/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.defaults.OsmHighwayTypeConfiguration;

public class OsmWaterwayTags {
    private static final Logger LOGGER = Logger.getLogger(OsmWaterwayTags.class.getCanonicalName());
    static final Set<String> DEFAULT_ACTIVATED_WATERWAY_OSM_ROUTE_VALUE_TAGS = new HashSet<String>();
    static final Set<String> DEFAULT_ACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS = new HashSet<String>();
    static final Set<String> DEFAULT_DEACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS = new HashSet<String>();
    static final Set<String> WATERWAY_KEY_TAGS = Set.of("route", "ferry");
    public static final String ROUTE = "route";
    public static final String FERRY = "ferry";

    private static void populateWaterBasedOsmWayValueTags() {
        DEFAULT_ACTIVATED_WATERWAY_OSM_ROUTE_VALUE_TAGS.add(FERRY);
        DEFAULT_ACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS.addAll(OsmHighwayTypeConfiguration.DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES);
        DEFAULT_DEACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS.addAll(OsmHighwayTypeConfiguration.DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES);
    }

    public static boolean isWaterBasedWay(String waterwayKey, String waterWayTagValue) {
        return OsmWaterwayTags.isAnyWaterwayKeyTag(waterwayKey) && (DEFAULT_ACTIVATED_WATERWAY_OSM_ROUTE_VALUE_TAGS.contains(waterWayTagValue) || DEFAULT_ACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS.contains(waterWayTagValue));
    }

    public static boolean isWaterBasedWay(Map<String, String> tags) {
        return OsmWaterwayTags.hasAnyWaterwayKeyTag(tags) && (FERRY.equals(tags.get(ROUTE)) || OsmWaterwayTags.isWaterWayTaggedAsHighway(tags));
    }

    public static boolean hasAnyWaterwayKeyTag(Map<String, String> tags) {
        return tags.containsKey(ROUTE) || tags.containsKey(FERRY);
    }

    public static boolean isWaterWayTaggedAsHighway(Map<String, String> tags) {
        return tags.containsKey(FERRY) && DEFAULT_ACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS.contains(tags.get(FERRY));
    }

    public static boolean isWaterWayTaggedFerryRoute(Map<String, String> tags) {
        return tags.containsKey(ROUTE) && tags.get(ROUTE).equals(FERRY);
    }

    public static String getUsedKeyTag(Map<String, String> tags) {
        if (OsmWaterwayTags.isWaterWayTaggedFerryRoute(tags)) {
            return ROUTE;
        }
        if (OsmWaterwayTags.isWaterWayTaggedAsHighway(tags)) {
            return FERRY;
        }
        LOGGER.severe(String.format("Water way is neither tagged as route=ferry or ferry=<some_highway_tag> for tags: %s", tags));
        return null;
    }

    public static String getKeyForValueType(String waterwayType) {
        if (FERRY.equals(waterwayType)) {
            return ROUTE;
        }
        if (OsmWaterwayTags.getAllSupportedHighwayTypesAsWaterWayTypes().contains(waterwayType)) {
            return FERRY;
        }
        return null;
    }

    public static boolean hasKeyForValueType(String waterwayType) {
        return OsmWaterwayTags.getKeyForValueType(waterwayType) != null;
    }

    public static boolean isAnyWaterwayKeyTag(String osmKey) {
        return ROUTE.equals(osmKey) || FERRY.equals(osmKey);
    }

    public static Set<String> getAllSupportedHighwayTypesAsWaterWayTypes() {
        return Collections.unmodifiableSet(DEFAULT_ACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS);
    }

    public static Set<String> getAllUnsupportedHighwayTypesAsWaterWayTypes() {
        return Collections.unmodifiableSet(DEFAULT_DEACTIVATED_WATERWAY_OSM_FERRY_VALUE_TAGS);
    }

    public static Collection<String> getKeyTags() {
        return WATERWAY_KEY_TAGS;
    }

    static {
        OsmWaterwayTags.populateWaterBasedOsmWayValueTags();
    }
}

