/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class OsmWaterModeTags {
    private static final Set<String> MODE_TAGS = new HashSet<String>();
    public static final String FERRY = "ferry";

    private static void populateModeTags() {
        MODE_TAGS.add(FERRY);
    }

    public static boolean isWaterModeTag(String modeTag) {
        return MODE_TAGS.contains(modeTag);
    }

    public static Set<String> getSupportedWaterModeTags() {
        return Collections.unmodifiableSet(MODE_TAGS);
    }

    public static String[] getSupportedWaterModeTagsAsArray() {
        return MODE_TAGS.toArray(new String[MODE_TAGS.size()]);
    }

    public static boolean containsAnyMode(Collection<String> osmModes) {
        return !Collections.disjoint(MODE_TAGS, osmModes);
    }

    public static TreeSet<String> getModesFrom(Collection<String> eligibleOsmModes) {
        TreeSet<String> intersectionModes = new TreeSet<String>(eligibleOsmModes);
        intersectionModes.retainAll(MODE_TAGS);
        return intersectionModes;
    }

    public static TreeSet<String> getPublicTransportModesFrom(Collection<String> eligibleOsmModes) {
        return OsmWaterModeTags.getModesFrom(eligibleOsmModes);
    }

    static {
        OsmWaterModeTags.populateModeTags();
    }
}

