/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class OsmRailModeTags {
    private static final Set<String> MODE_TAGS = new HashSet<String>();
    public static final String FUNICULAR = "funicular";
    public static final String LIGHT_RAIL = "light_rail";
    public static final String MONO_RAIL = "monorail";
    public static final String NARROW_GAUGE = "narrow_gauge";
    public static final String SUBWAY = "subway";
    public static final String TRAIN = "train";
    public static final String TRAM = "tram";

    private static void populateModeTags() {
        MODE_TAGS.add(FUNICULAR);
        MODE_TAGS.add(LIGHT_RAIL);
        MODE_TAGS.add(MONO_RAIL);
        MODE_TAGS.add(NARROW_GAUGE);
        MODE_TAGS.add(SUBWAY);
        MODE_TAGS.add(TRAIN);
        MODE_TAGS.add(TRAM);
    }

    public static boolean isRailModeTag(String modeTag) {
        return MODE_TAGS.contains(modeTag);
    }

    public static Set<String> getSupportedRailModeTags() {
        return Collections.unmodifiableSet(MODE_TAGS);
    }

    public static String[] getSupportedRailModeTagsAsArray() {
        return MODE_TAGS.toArray(new String[MODE_TAGS.size()]);
    }

    public static String convertModeToRailway(String osmMode) {
        return TRAIN.equals(osmMode) ? "rail" : osmMode;
    }

    public static String convertRailwayToMode(String osmRailwayValue) {
        return "rail".equals(osmRailwayValue) ? TRAIN : osmRailwayValue;
    }

    public static boolean containsAnyMode(Collection<String> osmModes) {
        return !Collections.disjoint(MODE_TAGS, osmModes);
    }

    public static TreeSet<String> getModesFrom(Collection<String> eligibleOsmModes) {
        TreeSet<String> intersectionModes = new TreeSet<String>(eligibleOsmModes);
        intersectionModes.retainAll(MODE_TAGS);
        return intersectionModes;
    }

    public static TreeSet<String> getPublicTransportModesFrom(Collection<String> eligibleOsmModes) {
        return OsmRailModeTags.getModesFrom(eligibleOsmModes);
    }

    static {
        OsmRailModeTags.populateModeTags();
    }
}

