/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmTags;
import org.goplanit.osm.util.OsmTagUtils;

public class OsmPtv1Tags {
    private static final Set<String> AREA_BASED_PT_HIGHWAY_VALUE_TAGS = new HashSet<String>();
    private static final Set<String> PT_HIGHWAY_VALUE_TAGS = new HashSet<String>();
    private static final Set<String> AREA_BASED_PT_RAILWAY_VALUE_TAGS = new HashSet<String>();
    private static final Set<String> PT_RAILWAY_VALUE_TAGS = new HashSet<String>();
    public static final String PLATFORM = "platform";
    public static final String BUS_STOP = "bus_stop";
    public static final String HALT = "halt";
    public static final String STOP = "stop";
    public static final String TRAM_STOP = "tram_stop";
    public static final String SUBWAY_ENTRANCE = "subway_entrance";
    public static final String STATION = "station";
    public static final String PLATFORM_EDGE = "platform_edge";

    private static void populateOsmHighwayPublicTransportValueTags() {
        PT_HIGHWAY_VALUE_TAGS.add(BUS_STOP);
        PT_HIGHWAY_VALUE_TAGS.addAll(AREA_BASED_PT_HIGHWAY_VALUE_TAGS);
    }

    private static void populateOsmRailwayPublicTransportValueTags() {
        PT_RAILWAY_VALUE_TAGS.add(HALT);
        PT_RAILWAY_VALUE_TAGS.add(STOP);
        PT_RAILWAY_VALUE_TAGS.add(PLATFORM_EDGE);
        PT_RAILWAY_VALUE_TAGS.add(SUBWAY_ENTRANCE);
        PT_RAILWAY_VALUE_TAGS.addAll(AREA_BASED_PT_RAILWAY_VALUE_TAGS);
        PT_RAILWAY_VALUE_TAGS.add("construction");
    }

    private static void populateAreaBasedOsmHighwayPublicTransportValueTags() {
        AREA_BASED_PT_HIGHWAY_VALUE_TAGS.add(PLATFORM);
    }

    private static void populateAreaBasedOsmRailwayPublicTransportValueTags() {
        AREA_BASED_PT_RAILWAY_VALUE_TAGS.add(PLATFORM);
        AREA_BASED_PT_RAILWAY_VALUE_TAGS.add(STATION);
        AREA_BASED_PT_RAILWAY_VALUE_TAGS.add(TRAM_STOP);
    }

    public static final Set<String> getAreaBasedHighwayValueTags() {
        return AREA_BASED_PT_HIGHWAY_VALUE_TAGS;
    }

    public static final Set<String> getAreaBasedRailwayValueTags() {
        return AREA_BASED_PT_RAILWAY_VALUE_TAGS;
    }

    public static final Set<String> getRailwayValueTags() {
        return PT_RAILWAY_VALUE_TAGS;
    }

    public static final Set<String> getHighwayValueTags() {
        return PT_HIGHWAY_VALUE_TAGS;
    }

    public static boolean hasPtv1ValueTag(Map<String, String> tags) {
        if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            return PT_HIGHWAY_VALUE_TAGS.contains(tags.get("highway"));
        }
        if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
            return PT_RAILWAY_VALUE_TAGS.contains(tags.get("railway"));
        }
        return false;
    }

    public static boolean isTramStop(Map<String, String> tags) {
        return OsmRailwayTags.hasRailwayKeyTag(tags) && tags.get("railway").equals(TRAM_STOP);
    }

    public static boolean isBusStop(Map<String, String> tags) {
        return OsmHighwayTags.hasHighwayKeyTag(tags) && tags.get("highway").equals(BUS_STOP);
    }

    public static boolean isHalt(Map<String, String> tags) {
        return OsmRailwayTags.hasRailwayKeyTag(tags) && tags.get("railway").equals(HALT);
    }

    public static boolean isRailwayStation(Map<String, String> tags, boolean allowUnderConstruction) {
        return OsmRailwayTags.hasRailwayKeyTag(tags) && (tags.get("railway").equals(STATION) || allowUnderConstruction && OsmTags.isUnderConstruction(tags, "railway", STATION));
    }

    public static boolean isFerryTerminal(Map<String, String> tags) {
        return OsmTags.isAmenity(tags) && tags.get("amenity").equals("ferry_terminal");
    }

    public static boolean isSubwayStation(Map<String, String> tags, boolean allowUnderConstruction) {
        if (!OsmPtv1Tags.isRailwayStation(tags, allowUnderConstruction)) {
            return false;
        }
        return OsmTagUtils.keyMatchesAnyValueTag(tags, STATION, "subway");
    }

    static {
        OsmPtv1Tags.populateAreaBasedOsmHighwayPublicTransportValueTags();
        OsmPtv1Tags.populateOsmHighwayPublicTransportValueTags();
        OsmPtv1Tags.populateAreaBasedOsmRailwayPublicTransportValueTags();
        OsmPtv1Tags.populateOsmRailwayPublicTransportValueTags();
    }
}

