/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.tags.OsmPtv1Tags;

public class OsmHighwayTags {
    static final Map<String, Integer> ROADBASED_HIGHWAY_VALUE_TAGS = new HashMap<String, Integer>();
    static final Set<String> AREABASED_OSM_HIGHWAY_VALUE_TAGS = new HashSet<String>();
    static final Set<String> NON_ROADBASED_HIGHWAY_VALUE_TAGS = new HashSet<String>();
    public static final String HIGHWAY = "highway";
    public static final String MOTORWAY = "motorway";
    public static final String MOTORWAY_LINK = "motorway_link";
    public static final String TRUNK = "trunk";
    public static final String TRUNK_LINK = "trunk_link";
    public static final String PRIMARY = "primary";
    public static final String PRIMARY_LINK = "primary_link";
    public static final String SECONDARY = "secondary";
    public static final String SECONDARY_LINK = "secondary_link";
    public static final String TERTIARY = "tertiary";
    public static final String TERTIARY_LINK = "tertiary_link";
    public static final String UNCLASSIFIED = "unclassified";
    public static final String RESIDENTIAL = "residential";
    public static final String LIVING_STREET = "living_street";
    public static final String PEDESTRIAN = "pedestrian";
    public static final String TRACK = "track";
    public static final String ROAD = "road";
    public static final String SERVICE = "service";
    public static final String FOOTWAY = "footway";
    public static final String BRIDLEWAY = "bridleway";
    public static final String STEPS = "steps";
    public static final String CORRIDOR = "corridor";
    public static final String CYCLEWAY = "cycleway";
    public static final String PATH = "path";
    public static final String ELEVATOR = "elevator";
    public static final String PROPOSED = "proposed";
    public static final String CONSTRUCTION = "construction";
    public static final String TURNING_CIRCLE = "turning_circle";
    public static final String RACEWAY = "raceway";
    private static final String SERVICES = "services";
    private static final String REST_AREA = "rest_area";

    private static void populateRoadBasedOsmHighwayTags() {
        ROADBASED_HIGHWAY_VALUE_TAGS.put(MOTORWAY, 1);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(MOTORWAY_LINK, 2);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(TRUNK, 3);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(TRUNK_LINK, 4);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(PRIMARY, 5);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(PRIMARY_LINK, 6);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(SECONDARY, 7);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(SECONDARY_LINK, 8);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(TERTIARY, 9);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(TERTIARY_LINK, 10);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(SERVICE, 11);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(RESIDENTIAL, 12);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(LIVING_STREET, 13);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(TRACK, 14);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(ROAD, 15);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(TURNING_CIRCLE, 16);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(RACEWAY, 17);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(CYCLEWAY, 18);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(PEDESTRIAN, 19);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(FOOTWAY, 20);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(STEPS, 21);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(CORRIDOR, 22);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(ELEVATOR, 23);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(BRIDLEWAY, 24);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(PATH, 25);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(PROPOSED, 26);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(CONSTRUCTION, 27);
        ROADBASED_HIGHWAY_VALUE_TAGS.put(UNCLASSIFIED, 28);
    }

    private static void populateAreaBasedOsmHighwayValueTags() {
        AREABASED_OSM_HIGHWAY_VALUE_TAGS.add(SERVICES);
        AREABASED_OSM_HIGHWAY_VALUE_TAGS.add(REST_AREA);
        AREABASED_OSM_HIGHWAY_VALUE_TAGS.addAll(OsmPtv1Tags.getAreaBasedHighwayValueTags());
        AREABASED_OSM_HIGHWAY_VALUE_TAGS.addAll(OsmPtv1Tags.getAreaBasedRailwayValueTags());
    }

    private static void populateNonRoadBasedOsmHighwayTags() {
        NON_ROADBASED_HIGHWAY_VALUE_TAGS.addAll(AREABASED_OSM_HIGHWAY_VALUE_TAGS);
    }

    public static boolean isRoadBasedHighwayValueTag(String highwayTag) {
        return ROADBASED_HIGHWAY_VALUE_TAGS.containsKey(highwayTag);
    }

    public static boolean isAreaBasedHighway(String highwayTag) {
        return AREABASED_OSM_HIGHWAY_VALUE_TAGS.contains(highwayTag);
    }

    public static boolean isNonRoadBasedHighwayValueTag(String highwayTag) {
        return NON_ROADBASED_HIGHWAY_VALUE_TAGS.contains(highwayTag);
    }

    public static boolean isHighwayKeyTag(String highwayTag) {
        return HIGHWAY.equals(highwayTag);
    }

    public static boolean hasHighwayKeyTag(Map<String, String> tags) {
        return tags.containsKey(OsmHighwayTags.getHighwayKeyTag());
    }

    public static String getHighwayKeyTag() {
        return HIGHWAY;
    }

    public static int compareHighwayType(String highwayType, String otherHighwayType) {
        return ROADBASED_HIGHWAY_VALUE_TAGS.get(otherHighwayType) - ROADBASED_HIGHWAY_VALUE_TAGS.get(highwayType);
    }

    static {
        OsmHighwayTags.populateRoadBasedOsmHighwayTags();
        OsmHighwayTags.populateAreaBasedOsmHighwayValueTags();
        OsmHighwayTags.populateNonRoadBasedOsmHighwayTags();
    }
}

