/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.physical.network.macroscopic;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesFactory;
import org.goplanit.network.layer.macroscopic.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.network.OsmHighwaySettings;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.network.OsmRailwaySettings;
import org.goplanit.osm.converter.network.OsmWaterwaySettings;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class PlanitOsmNetwork
extends MacroscopicNetwork {
    private static final long serialVersionUID = -2227509715172627526L;
    private static final Logger LOGGER = Logger.getLogger(PlanitOsmNetwork.class.getCanonicalName());
    protected static final Set<String> supportedOsmRoadLinkSegmentTypes = new HashSet<String>();
    protected static final Set<String> supportedOsmRailLinkSegmentTypes;
    protected static final Set<String> supportedOsmWaterLinkSegmentTypes;
    protected final Map<String, Map<String, Map<NetworkLayer, MacroscopicLinkSegmentType>>> defaultPlanitOsmLinkSegmentTypes = new HashMap<String, Map<String, Map<NetworkLayer, MacroscopicLinkSegmentType>>>();

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmRoadWayLinkSegmentType(String highwayTypeValue, double maxSpeed, Collection<? extends Mode> modes) {
        String osmWayKey = OsmHighwayTags.getHighwayKeyTag();
        switch (highwayTypeValue) {
            case "motorway": {
                return this.createMotorway(osmWayKey, maxSpeed, modes);
            }
            case "motorway_link": {
                return this.createMotorwayLink(osmWayKey, maxSpeed, modes);
            }
            case "trunk": {
                return this.createTrunk(osmWayKey, maxSpeed, modes);
            }
            case "trunk_link": {
                return this.createTrunkLink(osmWayKey, maxSpeed, modes);
            }
            case "primary": {
                return this.createPrimary(osmWayKey, maxSpeed, modes);
            }
            case "primary_link": {
                return this.createPrimaryLink(osmWayKey, maxSpeed, modes);
            }
            case "secondary": {
                return this.createSecondary(osmWayKey, maxSpeed, modes);
            }
            case "secondary_link": {
                return this.createSecondaryLink(osmWayKey, maxSpeed, modes);
            }
            case "tertiary": {
                return this.createTertiary(osmWayKey, maxSpeed, modes);
            }
            case "tertiary_link": {
                return this.createTertiaryLink(osmWayKey, maxSpeed, modes);
            }
            case "unclassified": {
                return this.createUnclassified(osmWayKey, maxSpeed, modes);
            }
            case "residential": {
                return this.createResidential(osmWayKey, maxSpeed, modes);
            }
            case "living_street": {
                return this.createLivingStreet(osmWayKey, maxSpeed, modes);
            }
            case "service": {
                return this.createService(osmWayKey, maxSpeed, modes);
            }
            case "pedestrian": {
                return this.createPedestrian(osmWayKey, maxSpeed, modes);
            }
            case "path": {
                return this.createPath(osmWayKey, maxSpeed, modes);
            }
            case "steps": {
                return this.createSteps(maxSpeed, modes);
            }
            case "footway": {
                return this.createFootway(osmWayKey, maxSpeed, modes);
            }
            case "cycleway": {
                return this.createCycleway(osmWayKey, maxSpeed, modes);
            }
            case "track": {
                return this.createTrack(osmWayKey, maxSpeed, modes);
            }
            case "road": {
                return this.createRoad(osmWayKey, maxSpeed, modes);
            }
            case "bridleway": {
                return this.createBridleway(osmWayKey, maxSpeed, modes);
            }
        }
        throw new PlanItRunTimeException(String.format("OSM type is supported but factory method is missing, unexpected for type highway:%s", highwayTypeValue));
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmRailWayLinkSegmentType(String railwayTypeValue, double maxSpeed, Collection<? extends Mode> modes) {
        switch (railwayTypeValue) {
            case "funicular": {
                return this.createFunicular(maxSpeed, modes);
            }
            case "light_rail": {
                return this.createLightRail(maxSpeed, modes);
            }
            case "monorail": {
                return this.createMonoRail(maxSpeed, modes);
            }
            case "narrow_gauge": {
                return this.createNarrowGauge(maxSpeed, modes);
            }
            case "rail": {
                return this.createRail(maxSpeed, modes);
            }
            case "subway": {
                return this.createSubway(maxSpeed, modes);
            }
            case "tram": {
                return this.createTram(maxSpeed, modes);
            }
        }
        throw new PlanItRunTimeException(String.format("OSM type is supported but factory method is missing, unexpected for type railway:%s", railwayTypeValue));
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmWaterWayLinkSegmentType(String waterwayValue, double maxSpeed, Collection<? extends Mode> modes) {
        String osmWaterwayKey = OsmWaterwayTags.getKeyForValueType(waterwayValue);
        if ("route".equals(osmWaterwayKey)) {
            switch (waterwayValue) {
                case "ferry": {
                    return this.createFerry(maxSpeed, modes);
                }
            }
            throw new PlanItRunTimeException(String.format("OSM type is supported for water way but factory method is missing, unexpected for type %s=%s", osmWaterwayKey, waterwayValue));
        }
        if ("ferry".equals(osmWaterwayKey)) {
            switch (waterwayValue) {
                case "motorway": {
                    return this.createMotorway(osmWaterwayKey, maxSpeed, modes);
                }
                case "motorway_link": {
                    return this.createMotorwayLink(osmWaterwayKey, maxSpeed, modes);
                }
                case "trunk": {
                    return this.createTrunk(osmWaterwayKey, maxSpeed, modes);
                }
                case "trunk_link": {
                    return this.createTrunkLink(osmWaterwayKey, maxSpeed, modes);
                }
                case "primary": {
                    return this.createPrimary(osmWaterwayKey, maxSpeed, modes);
                }
                case "primary_link": {
                    return this.createPrimaryLink(osmWaterwayKey, maxSpeed, modes);
                }
                case "secondary": {
                    return this.createSecondary(osmWaterwayKey, maxSpeed, modes);
                }
                case "secondary_link": {
                    return this.createSecondaryLink(osmWaterwayKey, maxSpeed, modes);
                }
                case "tertiary": {
                    return this.createTertiary(osmWaterwayKey, maxSpeed, modes);
                }
                case "tertiary_link": {
                    return this.createTertiaryLink(osmWaterwayKey, maxSpeed, modes);
                }
                case "unclassified": {
                    return this.createUnclassified(osmWaterwayKey, maxSpeed, modes);
                }
                case "residential": {
                    return this.createResidential(osmWaterwayKey, maxSpeed, modes);
                }
                case "living_street": {
                    return this.createLivingStreet(osmWaterwayKey, maxSpeed, modes);
                }
                case "service": {
                    return this.createService(osmWaterwayKey, maxSpeed, modes);
                }
                case "pedestrian": {
                    return this.createPedestrian(osmWaterwayKey, maxSpeed, modes);
                }
                case "path": {
                    return this.createPath(osmWaterwayKey, maxSpeed, modes);
                }
                case "footway": {
                    return this.createFootway(osmWaterwayKey, maxSpeed, modes);
                }
                case "cycleway": {
                    return this.createCycleway(osmWaterwayKey, maxSpeed, modes);
                }
                case "track": {
                    return this.createTrack(osmWaterwayKey, maxSpeed, modes);
                }
                case "road": {
                    return this.createRoad(osmWaterwayKey, maxSpeed, modes);
                }
                case "bridleway": {
                    return this.createBridleway(osmWaterwayKey, maxSpeed, modes);
                }
            }
            throw new PlanItRunTimeException("OSM type is supported for waterway but factory method is missing, unexpected for type %s=%s", new Object[]{osmWaterwayKey, waterwayValue});
        }
        throw new PlanItRunTimeException("Unknown OSM way key (%s) for waterway, this should not happen", new Object[]{osmWaterwayKey});
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmLinkSegmentType(String externalId, double capacityPcuPerhour, double maxDensityPcuPerKm, double maxSpeed, Collection<? extends Mode> modes) {
        HashMap<NetworkLayer, MacroscopicLinkSegmentType> typesPerLayer = new HashMap<NetworkLayer, MacroscopicLinkSegmentType>();
        for (Mode mode : modes) {
            MacroscopicLinkSegmentType linkSegmentType = null;
            MacroscopicNetworkLayerImpl networkLayer = (MacroscopicNetworkLayerImpl)this.getLayerByMode(mode);
            if (!typesPerLayer.containsKey(networkLayer)) {
                linkSegmentType = networkLayer.linkSegmentTypes.getFactory().registerNew(externalId, capacityPcuPerhour, maxDensityPcuPerKm);
                linkSegmentType.setXmlId(Long.toString(linkSegmentType.getId()));
                linkSegmentType.setExternalId(externalId);
                linkSegmentType.setName(externalId);
                typesPerLayer.put((NetworkLayer)networkLayer, linkSegmentType);
            }
            linkSegmentType = (MacroscopicLinkSegmentType)typesPerLayer.get(networkLayer);
            double cappedMaxSpeed = Math.min(maxSpeed, mode.getMaximumSpeedKmH());
            AccessGroupProperties accessGroupProperties = AccessGroupPropertiesFactory.create((double)cappedMaxSpeed, (Mode[])new Mode[]{mode});
            AccessGroupProperties matchedExistingAccessGroupProperties = linkSegmentType.findEqualAccessPropertiesForAnyMode(accessGroupProperties);
            if (matchedExistingAccessGroupProperties != null) {
                linkSegmentType.registerModeOnAccessGroup(mode, matchedExistingAccessGroupProperties);
                continue;
            }
            linkSegmentType.setAccessGroupProperties(accessGroupProperties);
        }
        return typesPerLayer;
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createDefaultOsmLinkSegmentType(String nameKey, String nameValue, double capacityPcuPerhour, double maxSpeedKmh, Collection<? extends Mode> modes) {
        String name = nameKey != null ? OsmTagUtils.toConcatEqualsString(nameKey, nameValue) : nameValue;
        return this.createOsmLinkSegmentType(name, capacityPcuPerhour, 180.0, maxSpeedKmh, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createMotorway(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "motorway", 2000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createMotorwayLink(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "motorway_link", 1800.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createTrunk(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "trunk", 2000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createTrunkLink(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "trunk_link", 1700.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createPrimary(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "primary", 1600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createPrimaryLink(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "primary_link", 1400.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createSecondary(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "secondary", 1200.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createSecondaryLink(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "secondary_link", 1000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createTertiary(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "tertiary", 1000.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createTertiaryLink(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "tertiary_link", 800.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createUnclassified(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "unclassified", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createResidential(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "residential", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createLivingStreet(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "living_street", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createService(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "service", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createPedestrian(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "pedestrian", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createPath(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "path", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createSteps(double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmHighwayTags.getHighwayKeyTag(), "steps", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createFootway(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "footway", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createCycleway(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "cycleway", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createBridleway(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "bridleway", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createTrack(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "track", 600.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createRoad(String osmKey, double osmHighwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(osmKey, "road", 0.0, osmHighwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createFunicular(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "funicular", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createLightRail(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "light_rail", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createMonoRail(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "monorail", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createNarrowGauge(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "narrow_gauge", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createRail(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "rail", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createSubway(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "subway", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createTram(double osmRailwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmRailwayTags.getRailwayKeyTag(), "tram", 10000.0, osmRailwayTypeMaxSpeed, modes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createFerry(double osmwayTypeMaxSpeed, Collection<? extends Mode> modes) {
        return this.createDefaultOsmLinkSegmentType(OsmWaterwayTags.getKeyForValueType("ferry"), "ferry", 600.0, osmwayTypeMaxSpeed, modes);
    }

    protected Set<PredefinedModeType> collectMappedPlanitModeTypes(String osmWayLikeKey, String osmWayLikeValue, OsmNetworkReaderSettings settings) {
        Collection<String> allowedOsmModes = null;
        if (settings.isHighwayParserActive() && OsmHighwayTags.isHighwayKeyTag(osmWayLikeKey)) {
            allowedOsmModes = settings.getHighwaySettings().collectAllowedOsmHighwayModes(osmWayLikeValue);
        } else if (settings.isRailwayParserActive() && OsmRailwayTags.isRailwayKeyTag(osmWayLikeKey)) {
            allowedOsmModes = settings.getRailwaySettings().collectAllowedOsmRailwayModes(osmWayLikeValue);
        } else if (settings.isWaterwayParserActive() && OsmWaterwayTags.isWaterBasedWay(osmWayLikeKey, osmWayLikeValue)) {
            allowedOsmModes = settings.getWaterwaySettings().collectAllowedOsmWaterwayModes(osmWayLikeValue);
        }
        return settings.getActivatedPlanitModeTypes(allowedOsmModes);
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmCompatibleRoadLinkSegmentTypeByLayer(String osmWayValue, OsmNetworkReaderSettings settings) {
        Map<NetworkLayer, MacroscopicLinkSegmentType> linkSegmentTypes = null;
        OsmHighwaySettings highwaySettings = settings.getHighwaySettings();
        if (highwaySettings.isOsmHighwayTypeActivated(osmWayValue)) {
            boolean isOverwrite = highwaySettings.isDefaultCapacityOrMaxDensityOverwrittenByOsmHighwayType(osmWayValue);
            boolean isBackupDefault = false;
            String osmWayValueToUse = osmWayValue;
            if (!supportedOsmRoadLinkSegmentTypes.contains(osmWayValue)) {
                String string = osmWayValueToUse = highwaySettings.isApplyDefaultWhenOsmHighwayTypeDeactivated() ? highwaySettings.getDefaultOsmHighwayTypeWhenUnsupported() : null;
                if (osmWayValueToUse != null) {
                    isBackupDefault = true;
                    LOGGER.info(String.format("Highway type %s chosen to be included in network, but not available as supported type by reader, reverting to backup default %s", osmWayValue, osmWayValueToUse));
                } else {
                    LOGGER.info(String.format("Highway type %s chosen to be included in network, but not activated in reader nor is a default fallback activated, ignored", osmWayValue, osmWayValueToUse));
                }
            }
            if (osmWayValueToUse != null) {
                if (!this.defaultPlanitOsmLinkSegmentTypes.containsKey(osmWayValueToUse)) {
                    Set<PredefinedMode> activatedPlanitModes = this.getAvailableModesFromModeTypes(settings.getActivatedPlanitModeTypes(highwaySettings.collectAllowedOsmHighwayModes(osmWayValueToUse)));
                    if (!activatedPlanitModes.isEmpty()) {
                        double osmHighwayTypeMaxSpeed = highwaySettings.getDefaultSpeedLimitByOsmHighwayType(osmWayValueToUse);
                        if (isOverwrite) {
                            Pair<Double, Double> capacityDensityPair = highwaySettings.getOverwrittenCapacityMaxDensityByOsmHighwayType(osmWayValueToUse);
                            linkSegmentTypes = this.createOsmLinkSegmentType(osmWayValue, (Double)capacityDensityPair.first(), (Double)capacityDensityPair.second(), osmHighwayTypeMaxSpeed, activatedPlanitModes);
                        } else {
                            linkSegmentTypes = this.createOsmRoadWayLinkSegmentType(osmWayValueToUse, osmHighwayTypeMaxSpeed, activatedPlanitModes);
                        }
                        for (Map.Entry<NetworkLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypes.entrySet()) {
                            NetworkLayer layer = entry.getKey();
                            MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                            String csvModeString = String.join((CharSequence)",", linkSegmentType.getAllowedModes().stream().map(mode -> mode.getName()).collect(Collectors.joining(",")));
                            LOGGER.info(String.format("%s %s%s highway:%s - modes: %s speed: %.2f (km/h) capacity: %.2f (pcu/lane/h), max density: %.2f (pcu/km/lane)", NetworkLayer.createLayerLogPrefix((NetworkLayer)layer), isOverwrite ? "[OVERWRITE] " : "[DEFAULT]", isBackupDefault ? "[BACKUP]" : "", osmWayValueToUse, csvModeString, osmHighwayTypeMaxSpeed, linkSegmentType.getExplicitCapacityPerLaneOrDefault(), linkSegmentType.getExplicitMaximumDensityPerLaneOrDefault()));
                        }
                    } else {
                        linkSegmentTypes = this.defaultPlanitOsmLinkSegmentTypes.get(OsmHighwayTags.getHighwayKeyTag()).get(osmWayValueToUse);
                    }
                } else {
                    LOGGER.warning(String.format("highway:%s is supported but none of the default modes are mapped, type ignored", osmWayValueToUse));
                }
            } else {
                LOGGER.info(String.format("Highway type (%s) chosen to be included in network, but not available as supported type by reader, exclude from processing", osmWayValue));
            }
        }
        return linkSegmentTypes;
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmCompatibleRailLinkSegmentTypeByLayer(String osmWayValue, OsmNetworkReaderSettings settings) {
        Map<NetworkLayer, MacroscopicLinkSegmentType> linkSegmentTypes = null;
        if (!settings.isRailwayParserActive()) {
            LOGGER.warning(String.format("Railways are not activated, cannot create link segment types for railway=%s", osmWayValue));
            return linkSegmentTypes;
        }
        if (settings.isRailwayParserActive() && settings.getRailwaySettings().isOsmRailwayTypeActivated(osmWayValue)) {
            OsmRailwaySettings railwaySettings = settings.getRailwaySettings();
            boolean isOverwrite = railwaySettings.isDefaultCapacityOrMaxDensityOverwrittenByOsmRailwayType(osmWayValue);
            Set<PredefinedMode> activatedPlanitModes = this.getAvailableModesFromModeTypes(settings.getActivatedPlanitModeTypes(railwaySettings.collectAllowedOsmRailwayModes(osmWayValue)));
            if (!activatedPlanitModes.isEmpty()) {
                double railwayMaxSpeed = railwaySettings.getDefaultSpeedLimitByOsmRailwayType(osmWayValue);
                if (isOverwrite) {
                    Pair<Double, Double> capacityDensityPair = railwaySettings.getOverwrittenCapacityMaxDensityByOsmRailwayType(osmWayValue);
                    linkSegmentTypes = this.createOsmLinkSegmentType(osmWayValue, (Double)capacityDensityPair.first(), (Double)capacityDensityPair.second(), railwayMaxSpeed, activatedPlanitModes);
                } else {
                    linkSegmentTypes = this.createOsmRailWayLinkSegmentType(osmWayValue, railwayMaxSpeed, activatedPlanitModes);
                }
                for (Map.Entry<NetworkLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypes.entrySet()) {
                    NetworkLayer layer = entry.getKey();
                    MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                    String csvModeString = String.join((CharSequence)",", linkSegmentType.getAllowedModes().stream().map(mode -> mode.getName()).collect(Collectors.joining(",")));
                    LOGGER.info(String.format("%s %s railway:%s - modes: %s speed: %s (km/h)", NetworkLayer.createLayerLogPrefix((NetworkLayer)layer), isOverwrite ? "[OVERWRITE] " : "[DEFAULT]", osmWayValue, csvModeString, railwayMaxSpeed));
                }
            } else {
                LOGGER.warning(String.format("Railway:%s is supported but none of the default modes are mapped, type ignored", osmWayValue));
            }
        } else {
            LOGGER.info(String.format("Railwayway type (%s) chosen to be included in network, but not available as supported type by reader, exclude from processing %s", osmWayValue));
        }
        return linkSegmentTypes;
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> createOsmCompatibleWaterLinkSegmentTypeByLayer(String osmWayValue, OsmNetworkReaderSettings settings) {
        if (!settings.isWaterwayParserActive()) {
            LOGGER.warning(String.format("Waterways are not activated, cannot create link segment types", osmWayValue));
            return null;
        }
        String osmWayKey = OsmWaterwayTags.getKeyForValueType(osmWayValue);
        if (StringUtils.isNullOrBlank((String)osmWayKey)) {
            LOGGER.warning(String.format("OSM way value has no compatible waterway key, cannot create link segment types", osmWayValue));
            return null;
        }
        Map<NetworkLayer, MacroscopicLinkSegmentType> linkSegmentTypes = null;
        if (settings.getWaterwaySettings().isOsmWaterwayTypeActivated(osmWayValue)) {
            OsmWaterwaySettings waterwaySettings = settings.getWaterwaySettings();
            boolean isOverwrite = waterwaySettings.isDefaultCapacityOrMaxDensityOverwrittenByOsmWaterwayRouteType(osmWayValue);
            Set<PredefinedMode> activatedPlanitModes = this.getAvailableModesFromModeTypes(settings.getActivatedPlanitModeTypes(waterwaySettings.collectAllowedOsmWaterwayModes(osmWayValue)));
            if (!activatedPlanitModes.isEmpty()) {
                double maxSpeedKmH = waterwaySettings.getDefaultSpeedLimitByOsmWaterwayType(osmWayValue);
                if (isOverwrite) {
                    Pair<Double, Double> capacityDensityPair = waterwaySettings.getOverwrittenCapacityMaxDensityByOsmWaterwayRouteType(osmWayValue);
                    linkSegmentTypes = this.createOsmLinkSegmentType(osmWayValue, (Double)capacityDensityPair.first(), (Double)capacityDensityPair.second(), maxSpeedKmH, activatedPlanitModes);
                } else {
                    linkSegmentTypes = this.createOsmWaterWayLinkSegmentType(osmWayValue, maxSpeedKmH, activatedPlanitModes);
                }
                for (Map.Entry<NetworkLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypes.entrySet()) {
                    NetworkLayer layer = entry.getKey();
                    MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                    String csvModeString = String.join((CharSequence)",", linkSegmentType.getAllowedModes().stream().map(mode -> mode.getName()).collect(Collectors.joining(",")));
                    LOGGER.info(String.format("%s %s %s=%s - modes: %s speed: %s (km/h)", NetworkLayer.createLayerLogPrefix((NetworkLayer)layer), isOverwrite ? "[OVERWRITE] " : "[DEFAULT]", osmWayKey, osmWayValue, csvModeString, maxSpeedKmH));
                }
            } else {
                LOGGER.warning(String.format("IGNORE: %s=%s is supported but none of the default modes are mapped for the link segment type", osmWayKey, osmWayValue));
            }
        } else {
            LOGGER.info(String.format("Waterway (%s=%s) chosen to be included in network, but not available as supported type by reader, exclude from processing %s", osmWayKey, osmWayValue));
        }
        return linkSegmentTypes;
    }

    protected Set<PredefinedMode> getAvailableModesFromModeTypes(Collection<PredefinedModeType> predefinedModeTypes) {
        return predefinedModeTypes.stream().map(mt -> this.getModes().get(mt)).filter(m -> m != null).collect(Collectors.toUnmodifiableSet());
    }

    public PlanitOsmNetwork() {
        this(IdGroupingToken.collectGlobalToken());
    }

    public PlanitOsmNetwork(IdGroupingToken groupId) {
        super(groupId);
    }

    public Map<NetworkLayer, MacroscopicLinkSegmentType> getDefaultLinkSegmentTypeByOsmTag(String osmWayKey, String osmWayTypeTagValue) {
        Map<String, Map<NetworkLayer, MacroscopicLinkSegmentType>> availableTypes = this.defaultPlanitOsmLinkSegmentTypes.get(osmWayKey);
        if (availableTypes == null) {
            return null;
        }
        return availableTypes.get(osmWayTypeTagValue);
    }

    public void createAndRegisterOsmCompatibleLinkSegmentTypes(OsmNetworkReaderSettings settings) {
        Map<String, Set<String>> keyValueMap;
        Map<Object, Object> combinedWayLikeTypeMap = new HashMap();
        if (settings.isHighwayParserActive()) {
            combinedWayLikeTypeMap = settings.getHighwaySettings().getSetOfActivatedOsmWayLikeTypes();
        }
        if (settings.isRailwayParserActive()) {
            keyValueMap = settings.getRailwaySettings().getSetOfActivatedOsmWayLikeTypes();
            combinedWayLikeTypeMap.putAll(keyValueMap);
        }
        if (settings.isWaterwayParserActive()) {
            keyValueMap = settings.getWaterwaySettings().getSetOfActivatedOsmWayLikeTypes();
            combinedWayLikeTypeMap.putAll(keyValueMap);
        }
        for (Map.Entry<Object, Object> entry : combinedWayLikeTypeMap.entrySet()) {
            String osmWayLikeKey = (String)entry.getKey();
            this.defaultPlanitOsmLinkSegmentTypes.putIfAbsent(osmWayLikeKey, new HashMap());
            Map<String, Map<NetworkLayer, MacroscopicLinkSegmentType>> defaultTypesToPopulate = this.defaultPlanitOsmLinkSegmentTypes.get(osmWayLikeKey);
            for (String osmWayLikeValueToUse : (Set)entry.getValue()) {
                Map<NetworkLayer, MacroscopicLinkSegmentType> linkSegmentTypesByLayer = null;
                Set<PredefinedModeType> activatedPlanitModeTypes = this.collectMappedPlanitModeTypes(osmWayLikeKey, osmWayLikeValueToUse, settings);
                if (activatedPlanitModeTypes == null || activatedPlanitModeTypes.isEmpty()) continue;
                if (OsmHighwayTags.isHighwayKeyTag(osmWayLikeKey) && OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayLikeValueToUse)) {
                    linkSegmentTypesByLayer = this.createOsmCompatibleRoadLinkSegmentTypeByLayer(osmWayLikeValueToUse, settings);
                } else if (OsmRailwayTags.isRailwayKeyTag(osmWayLikeKey) && OsmRailwayTags.isRailBasedRailway(osmWayLikeValueToUse)) {
                    linkSegmentTypesByLayer = this.createOsmCompatibleRailLinkSegmentTypeByLayer(osmWayLikeValueToUse, settings);
                } else if (OsmWaterwayTags.isWaterBasedWay(osmWayLikeKey, osmWayLikeValueToUse)) {
                    linkSegmentTypesByLayer = this.createOsmCompatibleWaterLinkSegmentTypeByLayer(osmWayLikeValueToUse, settings);
                } else {
                    LOGGER.severe(String.format("DISCARD: OSM %s=%s combination not recognised as valid when creating OSM compatible link segment types", osmWayLikeKey, osmWayLikeValueToUse));
                }
                if (linkSegmentTypesByLayer == null || linkSegmentTypesByLayer.isEmpty()) {
                    LOGGER.warning(String.format("DISCARD: Unable to create osm compatible PLANit link segment type for %s=%s", osmWayLikeKey, osmWayLikeValueToUse));
                    continue;
                }
                defaultTypesToPopulate.put(osmWayLikeValueToUse, linkSegmentTypesByLayer);
            }
        }
    }

    public void createAndRegisterOsmCompatiblePlanitPredefinedModes(OsmNetworkReaderSettings settings) {
        if (!this.getModes().isEmpty()) {
            LOGGER.severe("Initialising modes on OSM network, but found pre-existing modes on this supposedly empty network, shouldn't happen");
        }
        SortedSet<PredefinedModeType> mappedPlanitModes = settings.getActivatedPlanitModeTypes();
        for (PredefinedModeType modeType : mappedPlanitModes) {
            PredefinedMode newMode = this.getModes().getFactory().registerNew(modeType);
            newMode.appendExternalId(settings.getMappedOsmModes(modeType).stream().distinct().collect(Collectors.joining(";")), Character.valueOf(';'));
        }
    }

    static {
        supportedOsmRoadLinkSegmentTypes.add("motorway");
        supportedOsmRoadLinkSegmentTypes.add("motorway_link");
        supportedOsmRoadLinkSegmentTypes.add("trunk");
        supportedOsmRoadLinkSegmentTypes.add("trunk_link");
        supportedOsmRoadLinkSegmentTypes.add("primary");
        supportedOsmRoadLinkSegmentTypes.add("primary_link");
        supportedOsmRoadLinkSegmentTypes.add("secondary");
        supportedOsmRoadLinkSegmentTypes.add("secondary_link");
        supportedOsmRoadLinkSegmentTypes.add("secondary_link");
        supportedOsmRoadLinkSegmentTypes.add("tertiary");
        supportedOsmRoadLinkSegmentTypes.add("tertiary_link");
        supportedOsmRoadLinkSegmentTypes.add("unclassified");
        supportedOsmRoadLinkSegmentTypes.add("residential");
        supportedOsmRoadLinkSegmentTypes.add("living_street");
        supportedOsmRoadLinkSegmentTypes.add("service");
        supportedOsmRoadLinkSegmentTypes.add("pedestrian");
        supportedOsmRoadLinkSegmentTypes.add("path");
        supportedOsmRoadLinkSegmentTypes.add("steps");
        supportedOsmRoadLinkSegmentTypes.add("footway");
        supportedOsmRoadLinkSegmentTypes.add("cycleway");
        supportedOsmRoadLinkSegmentTypes.add("track");
        supportedOsmRoadLinkSegmentTypes.add("road");
        supportedOsmRoadLinkSegmentTypes.add("bridleway");
        supportedOsmRailLinkSegmentTypes = new HashSet<String>();
        supportedOsmRailLinkSegmentTypes.add("funicular");
        supportedOsmRailLinkSegmentTypes.add("light_rail");
        supportedOsmRailLinkSegmentTypes.add("monorail");
        supportedOsmRailLinkSegmentTypes.add("narrow_gauge");
        supportedOsmRailLinkSegmentTypes.add("rail");
        supportedOsmRailLinkSegmentTypes.add("subway");
        supportedOsmRailLinkSegmentTypes.add("tram");
        supportedOsmWaterLinkSegmentTypes = new HashSet<String>();
        supportedOsmWaterLinkSegmentTypes.add("ferry");
        supportedOsmWaterLinkSegmentTypes.add("motorway");
        supportedOsmWaterLinkSegmentTypes.add("motorway_link");
        supportedOsmWaterLinkSegmentTypes.add("trunk");
        supportedOsmWaterLinkSegmentTypes.add("trunk_link");
        supportedOsmWaterLinkSegmentTypes.add("primary");
        supportedOsmWaterLinkSegmentTypes.add("primary_link");
        supportedOsmWaterLinkSegmentTypes.add("secondary");
        supportedOsmWaterLinkSegmentTypes.add("secondary_link");
        supportedOsmWaterLinkSegmentTypes.add("secondary_link");
        supportedOsmWaterLinkSegmentTypes.add("tertiary");
        supportedOsmWaterLinkSegmentTypes.add("tertiary_link");
        supportedOsmWaterLinkSegmentTypes.add("unclassified");
        supportedOsmWaterLinkSegmentTypes.add("residential");
        supportedOsmWaterLinkSegmentTypes.add("living_street");
        supportedOsmWaterLinkSegmentTypes.add("service");
        supportedOsmWaterLinkSegmentTypes.add("pedestrian");
        supportedOsmWaterLinkSegmentTypes.add("path");
        supportedOsmWaterLinkSegmentTypes.add("steps");
        supportedOsmWaterLinkSegmentTypes.add("footway");
        supportedOsmWaterLinkSegmentTypes.add("cycleway");
        supportedOsmWaterLinkSegmentTypes.add("track");
        supportedOsmWaterLinkSegmentTypes.add("road");
        supportedOsmWaterLinkSegmentTypes.add("bridleway");
    }
}

