/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.osm.defaults.OsmInfrastructureConfiguration;
import org.goplanit.osm.defaults.OsmInfrastructureConfigurationImpl;
import org.goplanit.osm.tags.OsmWaterwayTags;

public class OsmWaterwayTypeConfiguration
implements OsmInfrastructureConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OsmWaterwayTypeConfiguration.class.getCanonicalName());
    protected static OsmInfrastructureConfiguration DEFAULT_ROUTEFERRY_CONFIGURATION = null;
    protected static OsmInfrastructureConfiguration DEFAULT_FERRYHIGHWAY_CONFIGURATION = null;
    protected OsmInfrastructureConfiguration routeFerryConfiguration = null;
    protected OsmInfrastructureConfiguration ferryHighwayConfiguration = null;

    protected OsmWaterwayTypeConfiguration(OsmWaterwayTypeConfiguration toCopy) {
        this.routeFerryConfiguration = toCopy.routeFerryConfiguration.deepClone();
        this.ferryHighwayConfiguration = toCopy.ferryHighwayConfiguration.deepClone();
    }

    public OsmWaterwayTypeConfiguration() {
        this.routeFerryConfiguration = DEFAULT_ROUTEFERRY_CONFIGURATION.deepClone();
        this.ferryHighwayConfiguration = DEFAULT_FERRYHIGHWAY_CONFIGURATION.deepClone();
    }

    @Override
    public void logDeactivatedTypes() {
        this.routeFerryConfiguration.logDeactivatedTypes();
        this.ferryHighwayConfiguration.logDeactivatedTypes();
    }

    @Override
    public boolean isDeactivated(String osmValue) {
        return this.routeFerryConfiguration.isDeactivated(osmValue) || this.ferryHighwayConfiguration.isDeactivated(osmValue);
    }

    @Override
    public boolean isActivated(String osmValue) {
        return this.routeFerryConfiguration.isActivated(osmValue) || this.ferryHighwayConfiguration.isActivated(osmValue);
    }

    @Override
    public void deactivate(String osmValue) {
        if (this.routeFerryConfiguration.isActivated(osmValue)) {
            this.routeFerryConfiguration.deactivate(osmValue);
        }
        if (this.ferryHighwayConfiguration.isActivated(osmValue)) {
            this.ferryHighwayConfiguration.deactivate(osmValue);
        }
    }

    @Override
    public void activate(String ... osmWayTypeValues) {
        this.routeFerryConfiguration.activate(osmWayTypeValues);
        this.ferryHighwayConfiguration.activate(osmWayTypeValues);
    }

    @Override
    public void activate(List<String> osmWayTypeValues) {
        this.routeFerryConfiguration.activate(osmWayTypeValues);
        this.ferryHighwayConfiguration.activate(osmWayTypeValues);
    }

    @Override
    public Map<String, Set<String>> getActivatedTypes() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.putAll(this.routeFerryConfiguration.getActivatedTypes());
        result.putAll(this.ferryHighwayConfiguration.getActivatedTypes());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<String, Set<String>> getDeactivatedTypes() {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        result.putAll(this.routeFerryConfiguration.getDeactivatedTypes());
        result.putAll(this.ferryHighwayConfiguration.getDeactivatedTypes());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void deactivateAll() {
        this.routeFerryConfiguration.deactivateAll();
        this.ferryHighwayConfiguration.deactivateAll();
    }

    @Override
    public void activateAll() {
        this.routeFerryConfiguration.activateAll();
        this.ferryHighwayConfiguration.activateAll();
    }

    @Override
    public OsmInfrastructureConfiguration deepClone() {
        return new OsmWaterwayTypeConfiguration(this);
    }

    static {
        try {
            HashSet<String> defaults = new HashSet<String>();
            defaults.add("ferry");
            DEFAULT_ROUTEFERRY_CONFIGURATION = new OsmInfrastructureConfigurationImpl("route", defaults, new HashSet<String>());
            HashSet<String> defaultSupported = new HashSet<String>();
            OsmWaterwayTags.getAllSupportedHighwayTypesAsWaterWayTypes().forEach(highwayType -> defaultSupported.add((String)highwayType));
            HashSet<String> defaultUnSupported = new HashSet<String>();
            OsmWaterwayTags.getAllUnsupportedHighwayTypesAsWaterWayTypes().forEach(highwayType -> defaultUnSupported.add((String)highwayType));
            DEFAULT_FERRYHIGHWAY_CONFIGURATION = new OsmInfrastructureConfigurationImpl("ferry", defaultSupported, defaultUnSupported);
        }
        catch (Exception e) {
            LOGGER.severe("Unable to create default supported and/or unsupported OSM water way types for this network");
        }
    }
}

