/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OsmSpeedLimitDefaultsCategory {
    private static final Logger LOGGER = Logger.getLogger(OsmSpeedLimitDefaultsCategory.class.getCanonicalName());
    protected final Map<String, Map<String, Double>> speedLimitDefaults;
    protected final OsmSpeedLimitDefaultsCategory backupDefaults;
    protected final String countryName;

    protected OsmSpeedLimitDefaultsCategory(OsmSpeedLimitDefaultsCategory other, boolean deepClone) {
        this.backupDefaults = deepClone && other.backupDefaults != null ? other.backupDefaults.deepClone() : other.backupDefaults;
        this.countryName = other.countryName;
        this.speedLimitDefaults = new HashMap<String, Map<String, Double>>();
        other.speedLimitDefaults.entrySet().stream().forEach(e -> this.speedLimitDefaults.put((String)e.getKey(), new HashMap((Map)e.getValue())));
    }

    public OsmSpeedLimitDefaultsCategory(String countryName) {
        this.countryName = countryName;
        this.backupDefaults = null;
        this.speedLimitDefaults = new HashMap<String, Map<String, Double>>();
    }

    public OsmSpeedLimitDefaultsCategory(String countryName, OsmSpeedLimitDefaultsCategory backupDefaults) {
        this.countryName = countryName;
        this.backupDefaults = backupDefaults;
        this.speedLimitDefaults = new HashMap<String, Map<String, Double>>();
    }

    public void setSpeedLimitDefault(String key, String type, double speedLimitKmH) {
        this.speedLimitDefaults.putIfAbsent(key, new HashMap());
        this.speedLimitDefaults.get(key).put(type, speedLimitKmH);
    }

    public Double getSpeedLimit(String key, String type) {
        Map<String, Double> speedLimitsForKey = this.speedLimitDefaults.get(key);
        if (speedLimitsForKey == null) {
            return this.backupDefaults.getSpeedLimit(key, type);
        }
        Double speedLimit = speedLimitsForKey.get(type);
        if (speedLimit == null) {
            speedLimit = this.backupDefaults.getSpeedLimit(key, type);
        }
        return speedLimit;
    }

    public boolean containsSpeedLimit(String type) {
        return this.speedLimitDefaults.values().stream().anyMatch(e -> e.containsKey(type));
    }

    public String getCountry() {
        return this.countryName;
    }

    public OsmSpeedLimitDefaultsCategory shallowClone() {
        return new OsmSpeedLimitDefaultsCategory(this, false);
    }

    public OsmSpeedLimitDefaultsCategory deepClone() {
        return new OsmSpeedLimitDefaultsCategory(this, true);
    }
}

