/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;

public class OsmSpeedLimitDefaults {
    protected final OsmSpeedLimitDefaultsCategory urbanHighwayDefaults;
    protected final OsmSpeedLimitDefaultsCategory nonUrbanHighwayDefaults;
    protected String countryName;
    protected final OsmSpeedLimitDefaultsCategory railwayDefaults;
    protected final OsmSpeedLimitDefaultsCategory waterwayDefaults;
    public static final double GLOBAL_DEFAULT_HIGHWAY_SPEEDLIMIT_KMH = 50.0;
    public static final double GLOBAL_DEFAULT_RAILWAY_SPEEDLIMIT_KMH = 70.0;
    public static final double GLOBAL_DEFAULT_WATERWAY_SPEEDLIMIT_KMH = 20.0;

    protected void setCountry(String countryName) {
        this.countryName = countryName;
    }

    public OsmSpeedLimitDefaults(String countryName) {
        this.countryName = countryName;
        this.urbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
        this.nonUrbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
        this.railwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
        this.waterwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName);
    }

    public OsmSpeedLimitDefaults(String countryName, OsmSpeedLimitDefaults backup) {
        this.countryName = countryName;
        this.urbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getUrbanHighwayDefaults());
        this.nonUrbanHighwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getNonUrbanHighwayDefaults());
        this.railwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getRailwayDefaults());
        this.waterwayDefaults = new OsmSpeedLimitDefaultsCategory(countryName, backup.getWaterwayDefaults());
    }

    public OsmSpeedLimitDefaults(String countryName, OsmSpeedLimitDefaultsCategory urbanHighwayDefaults, OsmSpeedLimitDefaultsCategory nonUrbanHighwayDefaults, OsmSpeedLimitDefaultsCategory railwayDefaults, OsmSpeedLimitDefaultsCategory waterwayDefaults) {
        this.countryName = countryName;
        this.urbanHighwayDefaults = urbanHighwayDefaults;
        this.nonUrbanHighwayDefaults = nonUrbanHighwayDefaults;
        this.railwayDefaults = railwayDefaults;
        this.waterwayDefaults = waterwayDefaults;
    }

    public OsmSpeedLimitDefaults(OsmSpeedLimitDefaults other) {
        if (other != null) {
            this.countryName = other.countryName;
            this.urbanHighwayDefaults = other.urbanHighwayDefaults != null ? other.urbanHighwayDefaults.deepClone() : null;
            this.nonUrbanHighwayDefaults = other.nonUrbanHighwayDefaults != null ? other.nonUrbanHighwayDefaults.deepClone() : null;
            this.railwayDefaults = other.railwayDefaults != null ? other.railwayDefaults.deepClone() : null;
            this.waterwayDefaults = other.waterwayDefaults != null ? other.waterwayDefaults.deepClone() : null;
        } else {
            this.urbanHighwayDefaults = null;
            this.railwayDefaults = null;
            this.waterwayDefaults = null;
            this.nonUrbanHighwayDefaults = null;
            this.countryName = null;
        }
    }

    public OsmSpeedLimitDefaults shallowClone() {
        return new OsmSpeedLimitDefaults(this);
    }

    public OsmSpeedLimitDefaultsCategory getUrbanHighwayDefaults() {
        return this.urbanHighwayDefaults;
    }

    public OsmSpeedLimitDefaultsCategory getNonUrbanHighwayDefaults() {
        return this.nonUrbanHighwayDefaults;
    }

    public OsmSpeedLimitDefaultsCategory getRailwayDefaults() {
        return this.railwayDefaults;
    }

    public OsmSpeedLimitDefaultsCategory getWaterwayDefaults() {
        return this.waterwayDefaults;
    }

    public String getCountry() {
        return this.countryName;
    }
}

