/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmRoadModeCategoryTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.osm.tags.OsmWaterModeTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.utils.misc.Pair;

public class OsmModeAccessDefaultsCategory {
    private static final Logger LOGGER = Logger.getLogger(OsmModeAccessDefaultsCategory.class.getCanonicalName());
    private final Map<String, Map<String, Set<String>>> disallowedModesByKeyAndType;
    private final Map<String, Map<String, Set<String>>> allowedModesByKeyAndType;
    private final Map<String, Map<String, Set<String>>> allowedModeCategoriesByKeyAndType;
    private String countryName;

    private boolean isValidOsmModes(List<String> osmModes) {
        for (String osmModeValueTag : osmModes) {
            if (OsmRoadModeTags.isRoadModeTag(osmModeValueTag) || OsmRailModeTags.isRailModeTag(osmModeValueTag) || OsmWaterModeTags.isWaterModeTag(osmModeValueTag)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidOsmKeyValueCombination(Pair<String, String> keyValue) {
        return this.isValidOsmKeyValueCombination((String)keyValue.first(), (String)keyValue.second());
    }

    private boolean isValidOsmKeyValueCombination(String key, String type) {
        if (OsmHighwayTags.isHighwayKeyTag(key) && OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            return true;
        }
        if (OsmRailwayTags.isRailwayKeyTag(key) && OsmRailwayTags.isRailBasedRailway(type)) {
            return true;
        }
        return OsmWaterwayTags.isWaterBasedWay(key, type);
    }

    void addDefaultAllowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.addAllowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), false, Arrays.asList(osmModes));
    }

    protected void addAllowedModes(String key, String type, boolean logChanges, List<String> osmModes) {
        boolean isValidModes;
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, type);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported way %s=%s when adding modes %s to allowed modes access defaults", key, type, osmModes));
        }
        if (!(isValidModes = this.isValidOsmModes(osmModes))) {
            LOGGER.warning(String.format("IGNORE: Unsupported mode(s) provided in %s when adding default modes for %s=%s", osmModes, key, type));
            return;
        }
        this.allowedModesByKeyAndType.putIfAbsent(key, new HashMap());
        Map<String, Set<String>> allowedModesByType = this.allowedModesByKeyAndType.get(key);
        for (String osmModeValueTag : osmModes) {
            allowedModesByType.putIfAbsent(type, new HashSet());
            allowedModesByType.get(type).add(osmModeValueTag);
            if (!logChanges) continue;
            LOGGER.info(String.format("Added additional mode %s to %s=%s", osmModeValueTag, key, type));
        }
    }

    protected void setAllowedModes(String key, String type, boolean logChanges, List<String> osmModes) {
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, type);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported way %s=%s when setting default allowed modes", key, type, osmModes));
            return;
        }
        boolean isValidModes = this.isValidOsmModes(osmModes);
        if (!isValidModes) {
            LOGGER.warning(String.format("IGNORE: Unsupported mode(s) provided in [%s] when setting default modes for %s=%s", osmModes, key, type));
            return;
        }
        ((Map)this.allowedModeCategoriesByKeyAndType.getOrDefault(key, new HashMap())).remove(type);
        this.allowedModesByKeyAndType.putIfAbsent(key, new HashMap());
        this.allowedModesByKeyAndType.get(key).putIfAbsent(type, new HashSet());
        ((Set)((Map)this.allowedModesByKeyAndType.getOrDefault(key, new HashMap())).get(type)).clear();
        Map<String, Set<String>> allowedModesByType = this.allowedModesByKeyAndType.get(key);
        for (String osmModeValueTag : osmModes) {
            allowedModesByType.get(type).add(osmModeValueTag);
        }
        if (logChanges) {
            LOGGER.info(String.format("Setting allowed modes to [%s] for %s=%s", osmModes, key, type));
        }
    }

    void addDefaultAllowedModeCategories(Pair<String, String> osmKeyValueType, String ... osmModeCategories) {
        this.addAllowedModeCategories((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), false, osmModeCategories);
    }

    protected void addAllowedModeCategories(String key, String type, boolean logChanges, String ... osmModeCategories) {
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, type);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported way %s=%s when setting allowed mode categories", key, type, osmModeCategories));
            return;
        }
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            this.allowedModeCategoriesByKeyAndType.putIfAbsent(key, new HashMap());
            Map<String, Set<String>> allowedModeCategoriesByType = this.allowedModeCategoriesByKeyAndType.get(key);
            for (int index = 0; index < osmModeCategories.length; ++index) {
                allowedModeCategoriesByType.putIfAbsent(type, new HashSet());
                String osmModeCategoryValueTag = osmModeCategories[index];
                if (OsmRoadModeCategoryTags.isRoadModeCategoryTag(osmModeCategoryValueTag)) {
                    allowedModeCategoriesByType.get(type).add(osmModeCategoryValueTag);
                    if (!logChanges) continue;
                    LOGGER.info(String.format("Added additional allowed mode category %s to %s=%s", osmModeCategoryValueTag, key, type));
                    continue;
                }
                LOGGER.warning(String.format("Unknown mode category tag %s, ignored when adding mode categories to modes access defaults", osmModeCategories[index]));
            }
        } else {
            LOGGER.warning(String.format("IGNORE: Mode categories only suited for road mode tags at this point and %s is unknown", type));
        }
    }

    protected void removeAllowedModeCategories(String key, String type, boolean logChanges, String ... osmModeCategories) {
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, type);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported %s=%s when removing allowed mode categories", key, type, osmModeCategories));
            return;
        }
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(type)) {
            Map allowedModeCategoriesByType = this.allowedModeCategoriesByKeyAndType.getOrDefault(key, new HashMap());
            for (int index = 0; index < osmModeCategories.length; ++index) {
                if (allowedModeCategoriesByType.containsKey(type) && OsmRoadModeCategoryTags.isRoadModeCategoryTag(osmModeCategories[index])) {
                    boolean removed = ((Set)allowedModeCategoriesByType.get(type)).remove(osmModeCategories[index]);
                    if (!logChanges || !removed) continue;
                    LOGGER.info(String.format("Removed allowed road mode category %s from %s=%s", osmModeCategories[index], key, type));
                    continue;
                }
                LOGGER.warning(String.format("Unknown mode category tag %s, ignored when removing mode categories from allowed modes access defaults", osmModeCategories[index]));
            }
        } else {
            LOGGER.warning(String.format("IGNORE: Unknown road based tag %s=%s, ignored when removing mode categories from allowed modes access defaults", key, type));
        }
    }

    void removeDefaultAllowedModes(String key, String wayType, boolean logChanges, String ... osmModes) {
        this.removeAllowedModes(key, wayType, false, osmModes);
    }

    protected void removeAllowedModes(String key, String wayType, boolean logChanges, String ... osmModes) {
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, wayType);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported way %s=%s when removing allowed modes", key, wayType, osmModes));
            return;
        }
        boolean isValidModes = this.isValidOsmModes(Arrays.asList(osmModes));
        if (!isValidModes) {
            LOGGER.warning(String.format("IGNORE: Unsupported mode(s) provided in [%s] when setting default modes for %s=%s", osmModes, key, wayType));
            return;
        }
        Map allowedModesByType = this.allowedModesByKeyAndType.getOrDefault(key, new HashMap());
        for (int index = 0; index < osmModes.length; ++index) {
            String osmModeValueTag = osmModes[index];
            if (!allowedModesByType.containsKey(wayType)) continue;
            boolean removed = ((Set)allowedModesByType.get(wayType)).remove(osmModeValueTag);
            if (!logChanges || !removed) continue;
            LOGGER.info(String.format("Removed allowed mode %s for %s=%s", osmModeValueTag, key, wayType));
        }
    }

    void addDefaultDisallowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.addDisallowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), false, osmModes);
    }

    protected void addDisallowedModes(String key, String wayType, boolean logChanges, String ... osmModes) {
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, wayType);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported %s=%s when disallowing modes", key, wayType, osmModes));
            return;
        }
        boolean isValidModes = this.isValidOsmModes(Arrays.asList(osmModes));
        if (!isValidModes) {
            LOGGER.warning(String.format("IGNORE: Unsupported OSM mode(s) provided in [%s] when disallowing modes for %s=%s", osmModes, key, wayType));
            return;
        }
        this.disallowedModesByKeyAndType.putIfAbsent(key, new HashMap());
        Map<String, Set<String>> disallowedModesByType = this.disallowedModesByKeyAndType.get(key);
        for (int index = 0; index < osmModes.length; ++index) {
            disallowedModesByType.putIfAbsent(wayType, new HashSet());
            boolean added = disallowedModesByType.get(wayType).add(osmModes[index]);
            if (!logChanges || !added) continue;
            LOGGER.info(String.format("Disallowed OSM mode %s for %s=%s", osmModes[index], key, wayType));
        }
    }

    void removeDefaultDisallowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.removeDisallowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), false, osmModes);
    }

    protected void removeDisallowedModes(String key, String wayType, boolean logChanges, String ... osmModes) {
        boolean validKeyValueCombination = this.isValidOsmKeyValueCombination(key, wayType);
        if (!validKeyValueCombination) {
            LOGGER.warning(String.format("IGNORE: Unsupported %s=%s when removing disallowing modes", key, wayType, osmModes));
            return;
        }
        boolean isValidModes = this.isValidOsmModes(Arrays.asList(osmModes));
        if (!isValidModes) {
            LOGGER.warning(String.format("IGNORE: Unsupported OSM mode(s) provided in [%s] when removing disallowed modes for %s=%s", osmModes, key, wayType));
            return;
        }
        Map disallowedModesByType = this.disallowedModesByKeyAndType.getOrDefault(key, new HashMap());
        for (int index = 0; index < osmModes.length; ++index) {
            if (disallowedModesByType.containsKey(wayType)) {
                boolean success = ((Set)disallowedModesByType.get(wayType)).remove(osmModes[index]);
                if (!logChanges || !success) continue;
                LOGGER.info(String.format("Removed disallowed mode %s from %s=%s", osmModes[index], key, wayType));
                continue;
            }
            LOGGER.warning(String.format("IGNORE: Unknown mode tag %s when removing modes from disallowed modes access defaults", osmModes[index]));
        }
    }

    public OsmModeAccessDefaultsCategory() {
        this.countryName = "global";
        this.allowedModeCategoriesByKeyAndType = new TreeMap<String, Map<String, Set<String>>>();
        this.allowedModesByKeyAndType = new TreeMap<String, Map<String, Set<String>>>();
        this.disallowedModesByKeyAndType = new TreeMap<String, Map<String, Set<String>>>();
    }

    public OsmModeAccessDefaultsCategory(String countryName) {
        this.countryName = countryName;
        this.allowedModeCategoriesByKeyAndType = new TreeMap<String, Map<String, Set<String>>>();
        this.allowedModesByKeyAndType = new TreeMap<String, Map<String, Set<String>>>();
        this.disallowedModesByKeyAndType = new TreeMap<String, Map<String, Set<String>>>();
    }

    public OsmModeAccessDefaultsCategory(OsmModeAccessDefaultsCategory other) {
        this();
        this.countryName = other.getCountry();
        other.allowedModeCategoriesByKeyAndType.forEach((k, v) -> {
            this.allowedModeCategoriesByKeyAndType.put((String)k, new HashMap());
            Map<String, Set<String>> toFill = this.allowedModeCategoriesByKeyAndType.get(k);
            v.forEach((k2, v2) -> toFill.put((String)k2, new HashSet(v2)));
        });
        other.allowedModesByKeyAndType.forEach((k, v) -> {
            this.allowedModesByKeyAndType.put((String)k, new HashMap());
            Map<String, Set<String>> toFill = this.allowedModesByKeyAndType.get(k);
            v.forEach((k2, v2) -> toFill.put((String)k2, new HashSet(v2)));
        });
        other.disallowedModesByKeyAndType.forEach((k, v) -> {
            this.disallowedModesByKeyAndType.put((String)k, new HashMap());
            Map<String, Set<String>> toFill = this.disallowedModesByKeyAndType.get(k);
            v.forEach((k2, v2) -> toFill.put((String)k2, new HashSet(v2)));
        });
    }

    public String getCountry() {
        return this.countryName;
    }

    public void setCountry(String countryName) {
        this.countryName = countryName;
    }

    public OsmModeAccessDefaultsCategory shallowClone() {
        return new OsmModeAccessDefaultsCategory(this);
    }

    public void addAllowedModeCategories(Pair<String, String> osmKeyValueType, String ... osmModeCategories) {
        this.addAllowedModeCategories((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), true, osmModeCategories);
    }

    public void removeAllowedModeCategories(Pair<String, String> osmKeyValueType, String ... osmModeCategories) {
        this.removeAllowedModeCategories((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), true, osmModeCategories);
    }

    public void addAllowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.addAllowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), Arrays.asList(osmModes));
    }

    public void addAllowedModes(String key, String wayType, List<String> osmModes) {
        this.addAllowedModes(key, wayType, true, osmModes);
    }

    public void setAllowedModes(String key, String wayType, List<String> osmModes) {
        this.setAllowedModes(key, wayType, true, osmModes);
    }

    public void removeAllowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.removeAllowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), true, osmModes);
    }

    public void addDisallowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.addDisallowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), true, osmModes);
    }

    public void removeDisallowedModes(Pair<String, String> osmKeyValueType, String ... osmModes) {
        this.removeDisallowedModes((String)osmKeyValueType.first(), (String)osmKeyValueType.second(), true, osmModes);
    }

    public boolean isAllowed(String key, String osmWayValue, String osmMode) {
        Boolean isAllowed = Boolean.FALSE;
        Map allowedModesByType = this.allowedModesByKeyAndType.getOrDefault(key, new HashMap());
        if (allowedModesByType.containsKey(osmWayValue)) {
            isAllowed = ((Set)allowedModesByType.get(osmWayValue)).contains(osmMode);
        }
        if (!isAllowed.booleanValue()) {
            Set<String> roadModeCategoriesOfMode = OsmRoadModeCategoryTags.getRoadModeCategoriesByMode(osmMode);
            Map allowedModeCategoriesByType = this.allowedModeCategoriesByKeyAndType.getOrDefault(key, new HashMap());
            Set allowedModeCategoriesOfKeyValueType = (Set)allowedModeCategoriesByType.get(osmWayValue);
            if (roadModeCategoriesOfMode != null && allowedModeCategoriesOfKeyValueType != null) {
                isAllowed = !Collections.disjoint(OsmRoadModeCategoryTags.getRoadModeCategoriesByMode(osmMode), (Collection)allowedModeCategoriesByType.get(osmWayValue));
            }
        }
        if (isAllowed.booleanValue()) {
            Map disallowedModesByType = this.disallowedModesByKeyAndType.getOrDefault(key, new HashMap());
            isAllowed = !disallowedModesByType.containsKey(osmWayValue) || !((Set)disallowedModesByType.get(osmWayValue)).contains(osmMode);
        }
        return isAllowed;
    }
}

