/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVRecord;
import org.goplanit.osm.defaults.CountrySpecificDefaultUtils;
import org.goplanit.osm.defaults.OsmModeAccessDefaults;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.utils.locale.LocaleUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.StringUtils;

public class OsmModeAccessDefaultsByCountry {
    private static final Logger LOGGER = Logger.getLogger(OsmModeAccessDefaultsByCountry.class.getCanonicalName());
    private static final OsmModeAccessDefaults GLOBAL_MODE_ACCESS_DEFAULTS = new OsmModeAccessDefaults();
    private static final Map<String, OsmModeAccessDefaults> MODE_ACCESS_DEFAULTS_BY_COUNTRY = new HashMap<String, OsmModeAccessDefaults>();
    private static final String MODE_ACCESS_RESOURCE_DIR = "mode_access";
    protected static OsmModeAccessDefaults globalModeAccessDefaults;
    protected static Map<String, OsmModeAccessDefaults> modeAccessDefaultsByCountry;

    protected static void populateGlobalDefaultHighwayModeAccess() {
        Pair keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"motorway");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "motor_vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultDisallowedModes((Pair<String, String>)keyValue, "moped", "mofa", "atv", "golf_cart");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"motorway_link");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "motor_vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultDisallowedModes((Pair<String, String>)keyValue, "moped", "mofa", "atv", "golf_cart");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"trunk");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"trunk_link");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"primary");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"primary_link");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"secondary");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"secondary_link");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"tertiary");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"tertiary_link");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"unclassified");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"residential");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"living_street");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"road");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"service");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"track");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories((Pair<String, String>)keyValue, "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"pedestrian");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot", "dog");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"steps");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot", "dog");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"path");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot", "dog", "horse", "bicycle");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"bridleway");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "horse");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"cycleway");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "bicycle");
        keyValue = Pair.of((Object)OsmHighwayTags.getHighwayKeyTag(), (Object)"footway");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "foot");
    }

    protected static void populateGlobalDefaultRailwayModeAccess() {
        Pair keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"funicular");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("funicular"));
        keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"light_rail");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("light_rail"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("tram"));
        keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"monorail");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("monorail"));
        keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"narrow_gauge");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("narrow_gauge"));
        keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"rail");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("rail"));
        keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"subway");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("subway"));
        keyValue = Pair.of((Object)OsmRailwayTags.getRailwayKeyTag(), (Object)"tram");
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("tram"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, OsmRailModeTags.convertRailwayToMode("light_rail"));
    }

    protected static void populateGlobalDefaultWaterwayModeAccess() {
        Pair keyValue = Pair.of((Object)"route", (Object)"ferry");
        GLOBAL_MODE_ACCESS_DEFAULTS.getWaterwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "ferry");
        OsmWaterwayTags.getAllSupportedHighwayTypesAsWaterWayTypes().forEach(highwayAsWaterWayType -> {
            Pair keyValue = Pair.of((Object)OsmWaterwayTags.getKeyForValueType(highwayAsWaterWayType), (Object)highwayAsWaterWayType);
            GLOBAL_MODE_ACCESS_DEFAULTS.getWaterwayModeAccessDefaults().addDefaultAllowedModes((Pair<String, String>)keyValue, "ferry");
        });
    }

    protected static void populateCountrySpecificDefaultModeAccess() {
        CountrySpecificDefaultUtils.callForEachFileInResourceDir(MODE_ACCESS_RESOURCE_DIR, OsmModeAccessDefaultsByCountry::populateCountrySpecificDefaultModeAccess);
    }

    protected static void populateCountrySpecificDefaultModeAccess(InputStreamReader inputReader, String fullCountryName) {
        try {
            Iterable<CSVRecord> records = CountrySpecificDefaultUtils.collectCsvRecordIterable(inputReader);
            for (CSVRecord record : records) {
                String osmWayType = record.get(0).trim();
                boolean isOsmHighway = OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayType);
                boolean isOsmRailwayTag = false;
                boolean isOsmWaterwayTag = false;
                if (!isOsmHighway) {
                    isOsmRailwayTag = OsmRailwayTags.isRailBasedRailway(osmWayType);
                    boolean bl = isOsmWaterwayTag = OsmWaterwayTags.getKeyForValueType(osmWayType) != null;
                }
                if (!(isOsmHighway || isOsmRailwayTag || isOsmWaterwayTag)) {
                    LOGGER.warning(String.format("IGNORED: OSM way type (%s) in country specific mode access defaults is not a valid highway, railway, or waterway type", osmWayType));
                }
                ArrayList<String> allowedOsmModes = new ArrayList<String>(record.size() - 1);
                for (int columnIndex = 1; columnIndex < record.size(); ++columnIndex) {
                    String osmMode = record.get(columnIndex).trim();
                    if (StringUtils.isNullOrBlank((String)osmMode)) continue;
                    allowedOsmModes.add(osmMode);
                }
                if (allowedOsmModes.isEmpty()) continue;
                OsmModeAccessDefaults countryDefaults = GLOBAL_MODE_ACCESS_DEFAULTS.deepClone();
                countryDefaults.setCountry(fullCountryName);
                if (isOsmHighway) {
                    countryDefaults.getHighwayModeAccessDefaults().setAllowedModes(OsmHighwayTags.getHighwayKeyTag(), osmWayType, false, allowedOsmModes);
                } else if (isOsmRailwayTag) {
                    countryDefaults.getRailwayModeAccessDefaults().setAllowedModes(OsmRailwayTags.getRailwayKeyTag(), osmWayType, false, allowedOsmModes);
                } else if (isOsmWaterwayTag) {
                    String osmWayKey = OsmWaterwayTags.getKeyForValueType(osmWayType);
                    countryDefaults.getWaterwayModeAccessDefaults().setAllowedModes(osmWayKey, osmWayType, false, allowedOsmModes);
                }
                OsmModeAccessDefaultsByCountry.setDefaultsByCountry(countryDefaults);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Parsing of CSV input stream with mode access defaults failed for %s", fullCountryName));
        }
    }

    protected static void setDefaultsByCountry(OsmModeAccessDefaults modeAccessDefaults) {
        if (modeAccessDefaults.getCountry() != "global") {
            MODE_ACCESS_DEFAULTS_BY_COUNTRY.put(LocaleUtils.getIso2CountryCodeByName((String)modeAccessDefaults.getCountry()), modeAccessDefaults);
        } else {
            LOGGER.warning("setting OSM mode access defaults by country, then the defaults should have a country specified, this is not the case, defaults, ignored");
        }
    }

    public static OsmModeAccessDefaults create() {
        OsmModeAccessDefaults theDefaults = null;
        try {
            theDefaults = GLOBAL_MODE_ACCESS_DEFAULTS.deepClone();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to initialise global mode access defaults");
        }
        return theDefaults;
    }

    public static OsmModeAccessDefaults create(String countryName) {
        OsmModeAccessDefaults theDefaults = null;
        try {
            String iso2CountryCode = LocaleUtils.getIso2CountryCodeByName((String)countryName);
            if (iso2CountryCode != null && MODE_ACCESS_DEFAULTS_BY_COUNTRY.containsKey(iso2CountryCode)) {
                theDefaults = MODE_ACCESS_DEFAULTS_BY_COUNTRY.get(iso2CountryCode).deepClone();
            } else {
                LOGGER.info("Reverting to global mode access defaults, rather than country specific ones");
                theDefaults = GLOBAL_MODE_ACCESS_DEFAULTS.deepClone();
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to initialise global mode access defaults");
        }
        return theDefaults;
    }

    static {
        modeAccessDefaultsByCountry = new HashMap<String, OsmModeAccessDefaults>();
        OsmModeAccessDefaultsByCountry.populateGlobalDefaultHighwayModeAccess();
        OsmModeAccessDefaultsByCountry.populateGlobalDefaultRailwayModeAccess();
        OsmModeAccessDefaultsByCountry.populateGlobalDefaultWaterwayModeAccess();
        OsmModeAccessDefaultsByCountry.populateCountrySpecificDefaultModeAccess();
    }
}

