/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.logging.Logger;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;

public class OsmModeAccessDefaults {
    private static final Logger LOGGER = Logger.getLogger(OsmModeAccessDefaults.class.getCanonicalName());
    private final OsmModeAccessDefaultsCategory highwayModeAccessDefaults;
    private final OsmModeAccessDefaultsCategory railwayModeAccessDefaults;
    private final OsmModeAccessDefaultsCategory waterwayModeAccessDefaults;
    private String countryName;

    public OsmModeAccessDefaults() {
        this.countryName = "global";
        this.highwayModeAccessDefaults = new OsmModeAccessDefaultsCategory();
        this.railwayModeAccessDefaults = new OsmModeAccessDefaultsCategory();
        this.waterwayModeAccessDefaults = new OsmModeAccessDefaultsCategory();
    }

    public OsmModeAccessDefaults(String countryName) {
        this.countryName = countryName;
        this.highwayModeAccessDefaults = new OsmModeAccessDefaultsCategory(countryName);
        this.railwayModeAccessDefaults = new OsmModeAccessDefaultsCategory(countryName);
        this.waterwayModeAccessDefaults = new OsmModeAccessDefaultsCategory(countryName);
    }

    public OsmModeAccessDefaults(OsmModeAccessDefaults other) {
        this.countryName = other.countryName;
        this.highwayModeAccessDefaults = new OsmModeAccessDefaultsCategory(other.highwayModeAccessDefaults);
        this.railwayModeAccessDefaults = new OsmModeAccessDefaultsCategory(other.railwayModeAccessDefaults);
        this.waterwayModeAccessDefaults = new OsmModeAccessDefaultsCategory(other.waterwayModeAccessDefaults);
    }

    public String getCountry() {
        return this.countryName;
    }

    public void setCountry(String countryName) {
        this.countryName = countryName;
        this.highwayModeAccessDefaults.setCountry(countryName);
        this.railwayModeAccessDefaults.setCountry(countryName);
        this.waterwayModeAccessDefaults.setCountry(countryName);
    }

    public OsmModeAccessDefaults shallowClone() {
        return new OsmModeAccessDefaults(this);
    }

    public OsmModeAccessDefaults deepClone() {
        return this.shallowClone();
    }

    public OsmModeAccessDefaultsCategory getHighwayModeAccessDefaults() {
        return this.highwayModeAccessDefaults;
    }

    public OsmModeAccessDefaultsCategory getRailwayModeAccessDefaults() {
        return this.railwayModeAccessDefaults;
    }

    public OsmModeAccessDefaultsCategory getWaterwayModeAccessDefaults() {
        return this.waterwayModeAccessDefaults;
    }
}

