/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmWaterwayTags;

public class OsmLaneDefaults {
    private static final Logger LOGGER = Logger.getLogger(OsmLaneDefaults.class.getCanonicalName());
    protected static Map<String, Integer> defaultRoadLanesPerDirection = new HashMap<String, Integer>();
    protected Map<String, Integer> lanesPerDirection;
    protected int lanesPerDirectionIfUnspecified = 1;
    protected int tracksPerDirectionIfUnspecified = 1;
    protected int waterwayLanesPerDirectionIfUnspecified = 1;
    public static final int MINIMUM_LANES_PER_DIRECTION = 1;
    public static final int DEFAULT_LANES_PER_DIRECTION_IF_UNSPECIFIED = 1;
    public static final int DEFAULT_TRACKS_PER_DIRECTION_IF_UNSPECIFIED = 1;

    protected static void populateDefaultLanesPerDirection() {
        defaultRoadLanesPerDirection.put("motorway", 2);
        defaultRoadLanesPerDirection.put("motorway_link", 2);
        defaultRoadLanesPerDirection.put("trunk", 2);
        defaultRoadLanesPerDirection.put("trunk_link", 2);
        defaultRoadLanesPerDirection.put("residential", 1);
        defaultRoadLanesPerDirection.put("tertiary", 1);
        defaultRoadLanesPerDirection.put("tertiary_link", 1);
        defaultRoadLanesPerDirection.put("secondary", 1);
        defaultRoadLanesPerDirection.put("secondary_link", 1);
        defaultRoadLanesPerDirection.put("primary", 1);
        defaultRoadLanesPerDirection.put("primary_link", 1);
        defaultRoadLanesPerDirection.put("unclassified", 1);
        defaultRoadLanesPerDirection.put("pedestrian", 1);
        defaultRoadLanesPerDirection.put("footway", 1);
        defaultRoadLanesPerDirection.put("steps", 1);
        defaultRoadLanesPerDirection.put("cycleway", 1);
        defaultRoadLanesPerDirection.put("living_street", 1);
        defaultRoadLanesPerDirection.put("service", 1);
        defaultRoadLanesPerDirection.put("track", 1);
        defaultRoadLanesPerDirection.put("path", 1);
        defaultRoadLanesPerDirection.put("road", 1);
        defaultRoadLanesPerDirection.put("bridleway", 1);
    }

    public OsmLaneDefaults() {
        this.lanesPerDirection = new HashMap<String, Integer>(defaultRoadLanesPerDirection);
    }

    public OsmLaneDefaults(OsmLaneDefaults osmLaneDefaults) {
        this.lanesPerDirection = new HashMap<String, Integer>(osmLaneDefaults.lanesPerDirection);
        this.lanesPerDirectionIfUnspecified = osmLaneDefaults.lanesPerDirectionIfUnspecified;
        this.tracksPerDirectionIfUnspecified = osmLaneDefaults.tracksPerDirectionIfUnspecified;
    }

    public Integer setDefaultDirectionalLanesByHighwayType(String type, Integer defaultNumberOfLanesPerDirection) {
        return this.lanesPerDirection.put(type, defaultNumberOfLanesPerDirection);
    }

    public Integer getDefaultDirectionalLanesByHighwayType(String osmWayValue) {
        if (this.lanesPerDirection.containsKey(osmWayValue)) {
            return this.lanesPerDirection.get(osmWayValue);
        }
        LOGGER.warning(String.format("highway type %s has no number of default lanes associated with it, reverting to missing default: %d", osmWayValue, 1));
        return 1;
    }

    public void setDefaultDirectionalRailwayTracks(Integer defaultNumberOfTracksPerDirection) {
        this.tracksPerDirectionIfUnspecified = defaultNumberOfTracksPerDirection;
    }

    public Integer getDefaultDirectionalRailwayTracks() {
        return this.tracksPerDirectionIfUnspecified;
    }

    public Integer getDefaultDirectionalWaterwayLanes() {
        return this.tracksPerDirectionIfUnspecified;
    }

    public Integer getDefaultDirectionalLanesByWayType(String osmKey, String osmValue) {
        if (OsmHighwayTags.isHighwayKeyTag(osmKey)) {
            return this.getDefaultDirectionalLanesByHighwayType(osmValue);
        }
        if (OsmRailwayTags.isRailwayKeyTag(osmKey)) {
            return this.getDefaultDirectionalRailwayTracks();
        }
        if (OsmWaterwayTags.isWaterBasedWay(osmKey, osmValue)) {
            return this.getDefaultDirectionalWaterwayLanes();
        }
        LOGGER.warning(String.format("unrecognised OSM way key %s, cannot collect default directional lanes", osmKey));
        return null;
    }

    public Integer getDefaultTotalLanesByHighwayType(String type) {
        return this.lanesPerDirection.get(type) * 2;
    }

    public OsmLaneDefaults shallowClone() {
        return new OsmLaneDefaults(this);
    }

    static {
        OsmLaneDefaults.populateDefaultLanesPerDirection();
    }
}

