/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.defaults.OsmInfrastructureConfiguration;

public class OsmInfrastructureConfigurationImpl
implements OsmInfrastructureConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OsmInfrastructureConfiguration.class.getCanonicalName());
    protected final Set<String> activatedOsmTypes;
    protected final Set<String> deactivatedOsmTypes;
    protected final String osmKey;

    @Override
    public void logDeactivatedTypes() {
        this.deactivatedOsmTypes.forEach(osmTag -> LOGGER.info(String.format("[DEACTIVATED] %s=%s", this.osmKey, osmTag)));
    }

    protected OsmInfrastructureConfigurationImpl(String osmWayKey) {
        this.osmKey = osmWayKey;
        this.activatedOsmTypes = new HashSet<String>();
        this.deactivatedOsmTypes = new HashSet<String>();
    }

    public OsmInfrastructureConfigurationImpl(String osmKey, Set<String> activatedOsmTypes, Set<String> deactivatedOsmTypes) {
        this.osmKey = osmKey;
        this.activatedOsmTypes = new HashSet<String>(activatedOsmTypes);
        this.deactivatedOsmTypes = new HashSet<String>(deactivatedOsmTypes);
    }

    protected OsmInfrastructureConfigurationImpl(OsmInfrastructureConfigurationImpl toCopy) {
        this.osmKey = toCopy.osmKey;
        this.activatedOsmTypes = new HashSet<String>(toCopy.activatedOsmTypes);
        this.deactivatedOsmTypes = new HashSet<String>(toCopy.deactivatedOsmTypes);
    }

    @Override
    public boolean isDeactivated(String osmValue) {
        return this.deactivatedOsmTypes.contains(osmValue);
    }

    @Override
    public boolean isActivated(String osmValue) {
        return this.activatedOsmTypes.contains(osmValue);
    }

    @Override
    public void deactivate(String osmValue) {
        boolean removedFromActive = this.activatedOsmTypes.remove(osmValue);
        if (!removedFromActive) {
            return;
        }
        this.deactivatedOsmTypes.add(osmValue);
        LOGGER.fine(String.format("Deactivating OSM type %s=%s", this.osmKey, osmValue));
    }

    @Override
    public void activate(String ... osmWayTypeValues) {
        this.activate(Arrays.asList(osmWayTypeValues));
    }

    @Override
    public void activate(List<String> osmWayTypeValues) {
        for (String osmWayTypeValue : osmWayTypeValues) {
            this.deactivatedOsmTypes.remove(osmWayTypeValue);
            boolean added = this.activatedOsmTypes.add(osmWayTypeValue);
            if (!added) continue;
            LOGGER.fine(String.format("Activating OSM type %s=%s", this.osmKey, osmWayTypeValue));
        }
    }

    @Override
    public Map<String, Set<String>> getActivatedTypes() {
        TreeMap<String, Set<String>> map = new TreeMap<String, Set<String>>();
        map.put(this.osmKey, new TreeSet<String>(this.activatedOsmTypes));
        return map;
    }

    @Override
    public Map<String, Set<String>> getDeactivatedTypes() {
        TreeMap<String, Set<String>> map = new TreeMap<String, Set<String>>();
        map.put(this.osmKey, new TreeSet<String>(this.deactivatedOsmTypes));
        return map;
    }

    @Override
    public void deactivateAll() {
        this.getActivatedTypes().values().stream().flatMap(e -> e.stream()).forEach(activatedType -> this.deactivate((String)activatedType));
    }

    @Override
    public void activateAll() {
        this.getDeactivatedTypes().values().stream().flatMap(e -> e.stream()).forEach(deactivatedType -> this.activate((String)deactivatedType));
    }

    @Override
    public OsmInfrastructureConfigurationImpl deepClone() {
        return new OsmInfrastructureConfigurationImpl(this);
    }
}

