/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.defaults.OsmInfrastructureConfigurationImpl;

public class OsmHighwayTypeConfiguration
extends OsmInfrastructureConfigurationImpl {
    private static final Logger LOGGER = Logger.getLogger(OsmHighwayTypeConfiguration.class.getCanonicalName());
    public static final Set<String> DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES = new HashSet<String>();
    public static final Set<String> DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES = new HashSet<String>();

    protected static void initialiseDefaultActivatedOsmHighwayTypes() {
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("motorway");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("motorway_link");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("trunk");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("trunk_link");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("primary");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("primary_link");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("secondary");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("secondary_link");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("tertiary");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("tertiary_link");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("unclassified");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("residential");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("living_street");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("service");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("pedestrian");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("track");
        DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES.add("road");
    }

    protected static void initialiseDefaultDeactivatedOsmHighwayTypes() {
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("footway");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("bridleway");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("steps");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("corridor");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("cycleway");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("path");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("elevator");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("proposed");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("construction");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("turning_circle");
        DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES.add("raceway");
    }

    public OsmHighwayTypeConfiguration() {
        super("highway", DEFAULT_ACTIVATED_OSM_HIGHWAY_TYPES, DEFAULT_DEACTIVATED_OSM_HIGHWAY_TYPES);
    }

    static {
        OsmHighwayTypeConfiguration.initialiseDefaultActivatedOsmHighwayTypes();
        OsmHighwayTypeConfiguration.initialiseDefaultDeactivatedOsmHighwayTypes();
    }
}

