/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.zoning.ZoningConverterUtils;
import org.goplanit.osm.converter.OsmNodeData;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmZoningReaderPlanitData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.OsmConnectoidHelper;
import org.goplanit.osm.converter.zoning.handler.helper.OsmPublicTransportModeConversion;
import org.goplanit.osm.converter.zoning.handler.helper.OsmZoningHelperBase;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmPtVersionSchemeUtils;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.osm.util.PlanitOsmUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.CollectionUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class TransferZoneHelper
extends OsmZoningHelperBase {
    private static final Logger LOGGER = Logger.getLogger(TransferZoneHelper.class.getCanonicalName());
    private final Zoning zoning;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmZoningHandlerProfiler profiler;
    private final OsmPublicTransportModeConversion publicTransportModeParser;
    private final OsmConnectoidHelper connectoidParser;
    private final PlanitJtsCrsUtils geoUtils;

    private Collection<MacroscopicLink> getLinksWithAccessToLocationForMode(Point location, Mode accessMode) {
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getReferenceNetwork().getLayerByMode(accessMode);
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer);
        OsmNode osmNode = layerData.getOsmNodeByLocation(location);
        List<MacroscopicLink> planitLinksToCheck = null;
        Node planitNode = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).getPlanitNodeByLocation(location);
        if (planitNode != null) {
            planitLinksToCheck = planitNode.getLinks();
        } else {
            planitLinksToCheck = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).findPlanitLinksWithInternalLocation(location);
            if (planitLinksToCheck != null && planitLinksToCheck.size() > 1) {
                throw new PlanItRunTimeException("Location is internal to multiple planit links, should not happen %s", new Object[]{osmNode != null ? "osm node " + osmNode.getId() : ""});
            }
        }
        return planitLinksToCheck;
    }

    private boolean supportsMultipleStopPositions(TransferZone transferZone) {
        EntityType osmEntityType = PlanitTransferZoneUtils.transferZoneGeometryToOsmEntityType(transferZone.getGeometry());
        return !osmEntityType.equals((Object)EntityType.Node) || !this.hasNetworkLayersWithActiveOsmNode(Long.valueOf(transferZone.getExternalId()));
    }

    private TransferZone createEmptyTransferZone(TransferZoneType transferZoneType) {
        TransferZone transferZone = this.zoning.getTransferZones().getFactory().createNew(transferZoneType, true);
        this.profiler.logTransferZoneStatus(this.zoning.getTransferZones().size());
        return transferZone;
    }

    private TransferZone createAndPopulateTransferZone(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, PlanitJtsCrsUtils geoUtils) {
        Geometry theGeometry;
        OsmNode referenceNode;
        Integer availableOsmNodeIndex;
        TransferZone transferZone = null;
        OsmNodeData osmNodeData = this.zoningReaderData.getOsmData().getOsmNodeData();
        Level geometryExtractionLogLevel = LOGGER.getLevel();
        boolean isOsmWay = Osm4JUtils.getEntityType(osmEntity).equals((Object)EntityType.Way);
        if (isOsmWay && !OsmWayUtils.isAllOsmWayNodesAvailable((OsmWay)osmEntity, osmNodeData.getRegisteredOsmNodes()) && (availableOsmNodeIndex = OsmWayUtils.findFirstAvailableOsmNodeIndexAfter(0, (OsmWay)osmEntity, osmNodeData.getRegisteredOsmNodes())) != null && OsmBoundingAreaUtils.isNearNetworkBoundingBox((Geometry)OsmNodeUtils.createPoint(referenceNode = osmNodeData.getRegisteredOsmNodes().get(((OsmWay)osmEntity).getNodeId(availableOsmNodeIndex.intValue()))), this.getNetworkToZoningData().getNetworkBoundingBox(), geoUtils)) {
            LOGGER.info(String.format("OSM waiting area way (%d) geometry incomplete, network bounding box cut-off, truncated to available nodes", osmEntity.getId()));
            geometryExtractionLogLevel = Level.OFF;
        }
        if ((theGeometry = PlanitOsmUtils.extractGeometry(osmEntity, osmNodeData.getRegisteredOsmNodes(), geometryExtractionLogLevel)) != null && !theGeometry.isEmpty()) {
            List<String> refValues;
            transferZone = this.createEmptyTransferZone(transferZoneType);
            transferZone.setGeometry(theGeometry);
            if (theGeometry instanceof Point) {
                transferZone.getCentroid().setPosition((Point)theGeometry);
            }
            transferZone.setXmlId(String.valueOf(transferZone.getId()));
            transferZone.setExternalId(Long.toString(osmEntity.getId()));
            if (tags.containsKey("name")) {
                transferZone.setName(tags.get("name"));
            }
            if ((refValues = OsmTagUtils.getValuesForSupportedRefKeys(tags)) != null) {
                transferZone.addTransferZonePlatformNames(refValues);
            }
        } else {
            LOGGER.warning(String.format("Transfer zone not created, geometry incomplete (polygon, line string) for OSM way %s, possibly nodes outside bounding box, or invalid OSM entity", osmEntity.getId()));
        }
        return transferZone;
    }

    private TransferZone createAndRegisterTransferZoneWithoutConnectoids(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, PlanitJtsCrsUtils geoUtils) {
        TransferZone transferZone = this.createAndPopulateTransferZone(osmEntity, tags, transferZoneType, geoUtils);
        if (transferZone != null) {
            this.zoning.getTransferZones().register((Object)transferZone);
            this.zoningReaderData.getPlanitData().registerTransferZoneVerticalLayerIndex(transferZone, osmEntity, tags);
            this.zoningReaderData.getPlanitData().addTransferZoneByOsmId(Osm4JUtils.getEntityType(osmEntity), osmEntity.getId(), transferZone);
        }
        return transferZone;
    }

    private Collection<TransferZone> removeTransferZonesOnWrongSideOfRoadOfStopLocation(OsmNode osmNode, Collection<TransferZone> transferZones, Collection<String> osmModes, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        HashSet<TransferZone> matchedTransferZones = new HashSet<TransferZone>(transferZones);
        boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive((String)this.zoningReaderData.getCountryName());
        osmModes = OsmModeUtils.extractPublicTransportModesFrom(osmModes);
        for (String osmMode : osmModes) {
            Mode accessMode = this.publicTransportModeParser.getActivatedPlanitMode(osmMode);
            if (accessMode == null) continue;
            for (TransferZone transferZone : transferZones) {
                if (!this.isTransferZoneOnWrongSideOfRoadOfStopLocation(OsmNodeUtils.createPoint(osmNode), transferZone, isLeftHandDrive, accessMode, geoUtils)) continue;
                if (!suppressLogging) {
                    LOGGER.fine(String.format("DISCARD: Platform/pole %s matched on name to stop_position %d, but discarded based on placement on the wrong side of the road", transferZone.getExternalId(), osmNode.getId()));
                }
                matchedTransferZones.remove(transferZone);
            }
        }
        return matchedTransferZones;
    }

    private boolean isTransferZoneOnWrongSideOfRoadOfStopLocation(Point location, TransferZone transferZone, boolean isLeftHandDrive, Mode accessMode, PlanitJtsCrsUtils geoUtils) {
        Collection accessibleLinks;
        Collection<MacroscopicLink> planitLinksToCheck = this.getLinksWithAccessToLocationForMode(location, accessMode);
        return planitLinksToCheck != null && ((accessibleLinks = ZoningConverterUtils.excludeLinksOnWrongSideOf((Geometry)transferZone.getGeometry(), planitLinksToCheck, (boolean)isLeftHandDrive, Collections.singleton(accessMode), (PlanitJtsCrsUtils)geoUtils)) == null || accessibleLinks.isEmpty());
    }

    private boolean isTransferZoneModeCompatible(TransferZone transferZone, Collection<String> referenceOsmModes, boolean allowPseudoMatches, boolean allowModelessTransferZoneMatches) {
        SortedSet<String> transferZoneSupportedModes = PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(transferZone);
        if (transferZoneSupportedModes == null) {
            return allowModelessTransferZoneMatches;
        }
        return this.publicTransportModeParser.isModeCompatible(transferZoneSupportedModes, referenceOsmModes, allowPseudoMatches);
    }

    private Collection<TransferZone> findClosestTransferZonesByTagReference(OsmNode osmNode, Map<String, String> tags, Collection<TransferZone> availableTransferZones, Collection<String> referenceOsmModes, boolean onlySelectClosestMatch, boolean suppressLogging) {
        HashMap<String, TreeSet<TransferZone>> foundTransferZones = null;
        List<String> refValues = OsmTagUtils.getValuesForSupportedRefKeys(tags);
        for (String osmNodeRefValue : refValues) {
            boolean multipleMatchesForSameRef = false;
            for (TransferZone transferZone : availableTransferZones) {
                if (!transferZone.hasPlatformNames()) continue;
                List tzRefValues = transferZone.getTransferZonePlatformNames();
                for (String tzRefValue : tzRefValues) {
                    TreeSet<TransferZone> foundTransferZonesForRef;
                    if (!osmNodeRefValue.equals(tzRefValue)) continue;
                    if (foundTransferZones == null) {
                        foundTransferZones = new HashMap<String, TreeSet<TransferZone>>();
                    }
                    if (PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(transferZone) == null) {
                        if (!suppressLogging) {
                            LOGGER.info(String.format("SALVAGED: Platform/pole (%s) referenced by stop_position (%s), matched although platform has no known mode support, verify correctness", transferZone.getExternalId(), osmNode.getId()));
                        }
                    } else if (!this.isTransferZoneModeCompatible(transferZone, referenceOsmModes, false, false)) continue;
                    if ((foundTransferZonesForRef = (TreeSet<TransferZone>)foundTransferZones.get(osmNodeRefValue)) == null) {
                        foundTransferZonesForRef = new TreeSet<TransferZone>();
                        foundTransferZones.put(osmNodeRefValue, foundTransferZonesForRef);
                    }
                    foundTransferZonesForRef.add(transferZone);
                    if (foundTransferZonesForRef.size() <= 1) continue;
                    multipleMatchesForSameRef = true;
                    if (!onlySelectClosestMatch) continue;
                    TransferZone closestZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, foundTransferZonesForRef, suppressLogging, this.geoUtils);
                    foundTransferZonesForRef.removeIf(z -> !z.equals(closestZone));
                }
            }
            if (suppressLogging || !multipleMatchesForSameRef || !onlySelectClosestMatch) continue;
            LOGGER.fine(String.format("Non-unique reference (%s) on stop_position %d, selected spatially closest platform/pole %s", osmNodeRefValue, osmNode.getId(), ((TransferZone)((Set)foundTransferZones.get(osmNodeRefValue)).stream().findFirst().get()).getExternalId()));
        }
        return foundTransferZones != null ? (Collection)foundTransferZones.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toCollection(TreeSet::new)) : null;
    }

    private Collection<TransferZone> findTransferZoneMatchByName(long osmId, String nameToMatch, Collection<TransferZone> availableTransferZones, Collection<String> referenceOsmModes, boolean suppressLogging) {
        Set<TransferZone> nameAndModecompatibleZones;
        boolean allowPseudoModeCompatibility = true;
        Set<TransferZone> foundTransferZones = null;
        for (TransferZone transferZone : availableTransferZones) {
            String transferZoneName = transferZone.getName();
            if (transferZoneName == null || !transferZoneName.equals(nameToMatch)) continue;
            if (foundTransferZones == null) {
                foundTransferZones = new HashSet<TransferZone>();
            }
            foundTransferZones.add(transferZone);
        }
        if (foundTransferZones != null && ((nameAndModecompatibleZones = this.filterModeCompatibleTransferZones(referenceOsmModes, foundTransferZones, allowPseudoModeCompatibility, false)) == null || nameAndModecompatibleZones.isEmpty())) {
            if (!suppressLogging) {
                LOGGER.fine(String.format("Platform/pole(s) (%s) matched by name to stop_position (%s), but none are even pseudo mode compatible with stop", foundTransferZones.stream().map(z -> z.getExternalId()).collect(Collectors.toList()).toString(), osmId));
            }
            foundTransferZones = this.filterModeCompatibleTransferZones(referenceOsmModes, foundTransferZones, false, true);
            if (!suppressLogging && foundTransferZones != null && foundTransferZones.size() > 1) {
                LOGGER.info(String.format("SALVAGED: Platform/pole(s) (%s) matched by name to stop_position (%s), although platform has no known mode support, verify correctness", foundTransferZones.stream().map(tz -> tz.getExternalId()).collect(Collectors.joining(",")), osmId));
            }
        }
        if (!suppressLogging && foundTransferZones != null && foundTransferZones.size() > 1) {
            LOGGER.fine(String.format("Multiple platform/pole matches found for name %s and access point OSM id %d", nameToMatch, osmId));
        }
        return foundTransferZones;
    }

    private Collection<TransferZone> findAccessibleTransferZonesByReferenceOrName(OsmNode osmNode, Map<String, String> tags, Collection<TransferZone> stopAreaTransferZones, Collection<String> referenceOsmModes, boolean onlySelectClosestMatch, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        Collection<TransferZone> matchedTransferZones = this.findClosestTransferZonesByTagReference(osmNode, tags, stopAreaTransferZones, referenceOsmModes, onlySelectClosestMatch, suppressLogging);
        if (matchedTransferZones != null && !matchedTransferZones.isEmpty()) {
            return matchedTransferZones;
        }
        if (tags.containsKey("name") && (matchedTransferZones = this.findTransferZoneMatchByName(osmNode.getId(), tags.get("name"), stopAreaTransferZones, referenceOsmModes, suppressLogging)) != null && !matchedTransferZones.isEmpty()) {
            Collection<TransferZone> potentialTransferZones = this.zoningReaderData.getPlanitData().getTransferZonesSpatially(OsmBoundingAreaUtils.createBoundingBox(osmNode, this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), geoUtils));
            matchedTransferZones.retainAll(potentialTransferZones);
            matchedTransferZones = this.removeTransferZonesOnWrongSideOfRoadOfStopLocation(osmNode, matchedTransferZones, referenceOsmModes, suppressLogging, geoUtils);
        }
        if (matchedTransferZones != null && matchedTransferZones.size() > 1 && onlySelectClosestMatch) {
            TransferZone foundTransferZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, matchedTransferZones, suppressLogging, geoUtils);
            matchedTransferZones = Collections.singleton(foundTransferZone);
        }
        return matchedTransferZones;
    }

    private Collection<TransferZone> findTransferZonesForStopPositionCompatibleSpatiallyModeVerticalLayer(OsmNode osmNode, Map<String, String> tags, Collection<String> referenceOsmModes, boolean onlySelectClosestMatch, boolean suppressLogging) {
        TransferZone foundZone = null;
        double searchRadiusMeters = this.getSettings().getStopToWaitingAreaSearchRadiusMeters();
        Envelope searchArea = OsmBoundingAreaUtils.createBoundingBox(osmNode, searchRadiusMeters, this.geoUtils);
        Collection<TransferZone> potentialTransferZones = this.zoningReaderData.getPlanitData().getTransferZonesSpatially(searchArea);
        if (potentialTransferZones == null || potentialTransferZones.isEmpty()) {
            if (!suppressLogging) {
                LOGGER.fine(String.format("Unable to locate nearby transfer zone (search radius of %.2f (m)) when mapping stop position for osm node %d", searchRadiusMeters, osmNode.getId()));
            }
            return null;
        }
        potentialTransferZones.removeIf(tz -> this.zoningReaderData.getPlanitData().hasConnectoids((TransferZone)tz) && !this.supportsMultipleStopPositions((TransferZone)tz));
        boolean allowModelessTransferZoneMatches = false;
        Collection<TransferZone> matchedTransferZones = this.filterModeCompatibleTransferZones(referenceOsmModes, potentialTransferZones, true, allowModelessTransferZoneMatches);
        if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
            allowModelessTransferZoneMatches = true;
            matchedTransferZones = this.filterModeCompatibleTransferZones(referenceOsmModes, potentialTransferZones, true, allowModelessTransferZoneMatches);
        }
        boolean layerMismatch = false;
        Collection<TransferZone> layerMatchedTransferZones = this.filterVerticalLayerIndexCompatibleTransferZones(osmNode, tags, matchedTransferZones, suppressLogging);
        if (CollectionUtils.nullOrEmpty(layerMatchedTransferZones) && !CollectionUtils.nullOrEmpty(matchedTransferZones)) {
            layerMismatch = true;
        } else {
            matchedTransferZones = layerMatchedTransferZones;
        }
        if (onlySelectClosestMatch && (foundZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, matchedTransferZones, suppressLogging, this.geoUtils)) != null) {
            matchedTransferZones = Collections.singleton(foundZone);
        }
        if (matchedTransferZones != null && !matchedTransferZones.isEmpty() && !suppressLogging) {
            if (allowModelessTransferZoneMatches) {
                LOGGER.info(String.format("SALVAGED: Platform(s)/pole(s) (%s) spatially matched to stop_position (%s) despite platform's absence of explicit mode support, verify correctness", matchedTransferZones.stream().map(tz -> tz.getExternalId()).collect(Collectors.joining(",")), osmNode.getId()));
            }
            if (layerMismatch) {
                LOGGER.warning(String.format("SALVAGED: Layer mismatch between stop position %d (or its OSM way), and all potential waiting areas (%s), possible tagging error, ignoring layer information", osmNode.getId(), matchedTransferZones.stream().map(tz -> tz.getExternalId()).collect(Collectors.joining(","))));
            }
        }
        return matchedTransferZones;
    }

    public TransferZoneHelper(PlanitOsmNetwork referenceNetwork, Zoning zoning, OsmZoningReaderData zoningReaderData, OsmNetworkToZoningReaderData network2ZoningData, OsmPublicTransportReaderSettings transferSettings, OsmZoningHandlerProfiler profiler) {
        super(referenceNetwork, network2ZoningData, transferSettings);
        this.zoningReaderData = zoningReaderData;
        this.zoning = zoning;
        this.profiler = profiler;
        this.geoUtils = new PlanitJtsCrsUtils(referenceNetwork.getCoordinateReferenceSystem());
        this.publicTransportModeParser = new OsmPublicTransportModeConversion(this.getNetworkToZoningData().getNetworkSettings(), transferSettings, (Iterable<Mode>)referenceNetwork.getModes());
        this.connectoidParser = new OsmConnectoidHelper(referenceNetwork, zoning, zoningReaderData, this.getNetworkToZoningData(), transferSettings, profiler);
    }

    public Set<TransferZone> filterModeCompatibleTransferZones(Collection<String> eligibleOsmModes, Collection<TransferZone> potentialTransferZones, boolean allowPseudoModeMatches, boolean allowModelessTransferZoneMatches) {
        return potentialTransferZones.stream().filter(tz -> this.isTransferZoneModeCompatible((TransferZone)tz, eligibleOsmModes, allowPseudoModeMatches, allowModelessTransferZoneMatches)).collect(Collectors.toSet());
    }

    private Collection<TransferZone> filterVerticalLayerIndexCompatibleTransferZones(OsmNode stopPositionOsmNode, Map<String, String> osmNodeTags, Collection<TransferZone> potentialTransferZones, boolean suppressLogging) {
        Integer osmVerticalLayerIndex = null;
        if (!osmNodeTags.containsKey("layer")) {
            List<? extends NetworkLayer> eligibleNetworkLayers = PlanitNetworkLayerUtils.getNetworkLayersWithActiveOsmNode(stopPositionOsmNode.getId(), this.getReferenceNetwork(), this.getNetworkToZoningData());
            Point stopPositionLocation = OsmNodeUtils.createPoint(stopPositionOsmNode);
            for (NetworkLayer networkLayer : eligibleNetworkLayers) {
                Pair<Integer, Boolean> planitLayerOsmVerticalLayerIndexPair = this.findOsmVerticalLayerIndexByStopPositionPlanitLinks(stopPositionLocation, networkLayer);
                if (planitLayerOsmVerticalLayerIndexPair == null || !((Boolean)planitLayerOsmVerticalLayerIndexPair.second()).booleanValue()) continue;
                if (osmVerticalLayerIndex != null && !osmVerticalLayerIndex.equals(planitLayerOsmVerticalLayerIndexPair.first())) {
                    if (suppressLogging) continue;
                    LOGGER.warning(String.format("Links connected to OSM stop position %d are not all on the expected vertical layer plane (layer=%d), verify correctness", stopPositionOsmNode.getId(), osmVerticalLayerIndex));
                    continue;
                }
                osmVerticalLayerIndex = (Integer)planitLayerOsmVerticalLayerIndexPair.first();
            }
        } else {
            osmVerticalLayerIndex = OsmTagUtils.getValueAsInt(osmNodeTags, "layer");
        }
        if (osmVerticalLayerIndex == null) {
            return potentialTransferZones;
        }
        boolean isDefaultVerticalLayer = osmVerticalLayerIndex == 0;
        Integer finalVerticalLayerIndex = osmVerticalLayerIndex;
        OsmZoningReaderPlanitData planitData = this.zoningReaderData.getPlanitData();
        return potentialTransferZones.stream().filter(tz -> isDefaultVerticalLayer && planitData.getTransferZoneVerticalLayerIndex((TransferZone)tz) == null || planitData.getTransferZoneVerticalLayerIndex((TransferZone)tz) == finalVerticalLayerIndex).collect(Collectors.toSet());
    }

    public TransferZone createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, String defaultOsmMode, PlanitJtsCrsUtils geoUtils) {
        TransferZone transferZone = null;
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.publicTransportModeParser.collectPublicTransportModesFromPtEntity(osmEntity, tags, defaultOsmMode);
        if (!OsmModeUtils.hasEligibleOsmMode(modeResult)) {
            LOGGER.fine(String.format("SALVAGED: Creating tentative transfer zone %s for OSM entity %d without tagged OSM modes", transferZoneType.name(), osmEntity.getId()));
            transferZone = this.createAndRegisterTransferZoneWithoutConnectoids(osmEntity, tags, transferZoneType, geoUtils);
        } else if (OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            transferZone = this.createAndRegisterTransferZoneWithoutConnectoids(osmEntity, tags, transferZoneType, geoUtils);
            PlanitTransferZoneUtils.registerOsmModesOnTransferZone(transferZone, (SortedSet)modeResult.first());
        } else {
            this.zoningReaderData.getOsmData().addWaitingAreaWithoutMappedPlanitMode(Osm4JUtils.getEntityType(osmEntity), osmEntity.getId());
        }
        return transferZone;
    }

    public TransferZone createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(OsmEntity osmEntity, Map<String, String> tags, TransferZoneType transferZoneType, SortedSet<String> eligibleOsmModes, PlanitJtsCrsUtils geoUtils) {
        TransferZone transferZone = this.createAndRegisterTransferZoneWithoutConnectoids(osmEntity, tags, TransferZoneType.PLATFORM, geoUtils);
        if (transferZone != null) {
            PlanitTransferZoneUtils.registerOsmModesOnTransferZone(transferZone, eligibleOsmModes);
        }
        return transferZone;
    }

    public TransferZone createAndRegisterTransferZoneWithConnectoidsAtOsmNode(OsmNode osmNode, Map<String, String> tags, String defaultOsmMode, TransferZoneType defaultTransferZoneType, PlanitJtsCrsUtils geoUtils) {
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.publicTransportModeParser.collectPublicTransportModesFromPtEntity((OsmEntity)osmNode, tags, defaultOsmMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            throw new PlanItRunTimeException("Should not attempt to parse OSM node %d when no PLANit modes are activated for it", new Object[]{osmNode.getId()});
        }
        TransferZone transferZone = this.zoningReaderData.getPlanitData().getTransferZoneByOsmId(EntityType.Node, osmNode.getId());
        if (transferZone == null && (transferZone = this.createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes((OsmEntity)osmNode, tags, defaultTransferZoneType, defaultOsmMode, geoUtils)) == null) {
            throw new PlanItRunTimeException("Unable to create transfer zone for osm node %d", new Object[]{osmNode.getId()});
        }
        for (PredefinedModeType modeType : (SortedSet)modeResult.second()) {
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getReferenceNetwork().getLayerByPredefinedModeType(modeType);
            this.connectoidParser.createAndRegisterDirectedConnectoidsOnTopOfTransferZone(transferZone, networkLayer, modeType, geoUtils);
        }
        return transferZone;
    }

    public Collection<TransferZone> findTransferZonesForStopPosition(OsmNode osmNode, Map<String, String> tags, SortedSet<String> eligibleOsmModes, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        Collection<TransferZone> matchedTransferZones = null;
        if (this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmNode.getId())) {
            Pair<EntityType, Long> result = this.getSettings().getOverwrittenWaitingAreaOfStopLocation(osmNode.getId());
            TransferZone foundZone = this.zoningReaderData.getPlanitData().getTransferZoneByOsmId((EntityType)result.first(), (Long)result.second());
            if (foundZone == null) {
                if (!suppressLogging) {
                    LOGGER.severe(String.format("User overwritten waiting area (platform, pole %d) for OSM node %d, not available", result.second(), osmNode.getId()));
                }
            } else {
                if (!suppressLogging) {
                    LOGGER.fine(String.format("Mapped stop_position %d to overwritten waiting area %d", osmNode.getId(), result.second()));
                }
                return Collections.singleton(foundZone);
            }
        }
        if (eligibleOsmModes != null && !eligibleOsmModes.isEmpty()) {
            Collection<TransferZone> potentialTransferZonesIrrespectiveOfGroup;
            boolean onlySelectClosestMatch = false;
            if (transferZoneGroup != null) {
                matchedTransferZones = this.findAccessibleTransferZonesByReferenceOrName(osmNode, tags, transferZoneGroup.getTransferZones(), eligibleOsmModes, onlySelectClosestMatch, suppressLogging, this.geoUtils);
            }
            if (!CollectionUtils.nullOrEmpty(potentialTransferZonesIrrespectiveOfGroup = this.findTransferZonesForStopPositionCompatibleSpatiallyModeVerticalLayer(osmNode, tags, eligibleOsmModes, onlySelectClosestMatch, suppressLogging)) && !CollectionUtils.nullOrEmpty(matchedTransferZones) && matchedTransferZones.size() > 1) {
                matchedTransferZones.removeIf(e -> !potentialTransferZonesIrrespectiveOfGroup.contains(e));
                if (matchedTransferZones.isEmpty()) {
                    onlySelectClosestMatch = true;
                    matchedTransferZones = this.findAccessibleTransferZonesByReferenceOrName(osmNode, tags, transferZoneGroup.getTransferZones(), eligibleOsmModes, onlySelectClosestMatch, suppressLogging, this.geoUtils);
                    LOGGER.warning(String.format("Mismatch between spatially/mode/layer eligible waiting area(s) identified (%s) and name/ref compatible waiting area(s) for stop location %d, choosing closest name/ref based waiting area: %s, verify correctness", potentialTransferZonesIrrespectiveOfGroup.stream().map(tz -> tz.getExternalId()).collect(Collectors.joining(",")), osmNode.getId(), matchedTransferZones.stream().findFirst().get().getExternalId()));
                } else {
                    matchedTransferZones = potentialTransferZonesIrrespectiveOfGroup;
                }
            } else {
                matchedTransferZones = potentialTransferZonesIrrespectiveOfGroup;
            }
            if ((matchedTransferZones == null || matchedTransferZones.isEmpty()) && OsmPtVersionSchemeUtils.isPtv2StopPositionPtv1Stop(osmNode, tags) && this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                TransferZone transferZone = this.createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes((OsmEntity)osmNode, tags, TransferZoneType.PLATFORM, eligibleOsmModes, this.geoUtils);
                if (transferZone == null) {
                    if (!suppressLogging) {
                        LOGGER.fine(String.format("Unable to convert stop_location %d residing on road infrastucture into a transfer zone for modes %s", osmNode.getId(), eligibleOsmModes.toString()));
                    }
                } else {
                    if (OsmPtv1Tags.isBusStop(tags) && !suppressLogging) {
                        LOGGER.fine(String.format("SALVAGED: process Ptv2 stop_position %d as Ptv1 tag representing both stop and waiting area in one for modes %s", osmNode.getId(), eligibleOsmModes.toString()));
                    }
                    matchedTransferZones = Collections.singleton(transferZone);
                }
            }
        } else if (transferZoneGroup.hasTransferZones()) {
            matchedTransferZones = this.filterVerticalLayerIndexCompatibleTransferZones(osmNode, tags, transferZoneGroup.getTransferZones(), suppressLogging);
        }
        if (!CollectionUtils.nullOrEmpty(matchedTransferZones) && matchedTransferZones.size() > 1) {
            TransferZone foundZone = (TransferZone)OsmNodeUtils.findZoneClosest(osmNode, matchedTransferZones, this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), suppressLogging, this.geoUtils);
            matchedTransferZones = foundZone != null ? Collections.singleton(foundZone) : null;
        }
        return matchedTransferZones;
    }

    public Collection<TransferZone> findTransferZonesForStopPosition(OsmNode osmNode, Map<String, String> tags, SortedSet<String> eligibleOsmModes, boolean suppressLogging) {
        return this.findTransferZonesForStopPosition(osmNode, tags, eligibleOsmModes, null, suppressLogging);
    }

    public Collection<MacroscopicLink> filterVerticalLayerCompatibleLinks(TransferZone transferZone, Collection<MacroscopicLink> linksToFilter, boolean assumeDefaultLayerForZoneIfAbsent) {
        Integer transferZoneLayerIndex = this.zoningReaderData.getPlanitData().getTransferZoneVerticalLayerIndex(transferZone);
        linksToFilter.removeIf(link -> transferZoneLayerIndex != null && OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)link) != transferZoneLayerIndex || transferZoneLayerIndex == null && assumeDefaultLayerForZoneIfAbsent && OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)link) != 0);
        return linksToFilter;
    }
}

