/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.OsmPublicTransportModeConversion;
import org.goplanit.osm.converter.zoning.handler.helper.OsmZoningHelperBase;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneHelper;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.zoning.Zoning;

public class TransferZoneGroupHelper
extends OsmZoningHelperBase {
    private static final Logger LOGGER = Logger.getLogger(TransferZoneGroupHelper.class.getCanonicalName());
    private final Zoning zoning;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmZoningHandlerProfiler profiler;
    private final TransferZoneHelper transferZoneParser;
    private final OsmPublicTransportModeConversion ptModeParser;

    private boolean registerTransferZoneOnGroup(long osmId, EntityType type, Map<String, String> tags, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        TransferZone transferZone = this.zoningReaderData.getPlanitData().getTransferZoneByOsmId(type, osmId);
        if (transferZone == null) {
            boolean logDiscardWarning = false;
            if (!this.getSettings().hasBoundingPolygon()) {
                if (tags != null) {
                    Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.ptModeParser.collectPublicTransportModesFromPtEntity(osmId, type, tags, OsmModeUtils.identifyPtv1DefaultMode(osmId, tags));
                    if (OsmModeUtils.hasEligibleOsmMode(modeResult) && !this.getSettings().hasBoundingPolygon()) {
                        logDiscardWarning = true;
                    }
                } else if (!this.zoningReaderData.getOsmData().isWaitingAreaWithoutMappedPlanitMode(type, osmId)) {
                    logDiscardWarning = true;
                }
                if (logDiscardWarning && !suppressLogging) {
                    LOGGER.warning(String.format("DISCARD: Waiting area OSM entity %d (type %s) not available, referenced by stop_area %s, problem unless ineligible or geometry outside parsed area", osmId, type.toString(), transferZoneGroup.getExternalId()));
                }
            }
            return false;
        }
        transferZoneGroup.addTransferZone(transferZone);
        return true;
    }

    public static void updateTransferZoneGroupName(TransferZoneGroup transferZoneGroup, OsmEntity osmEntityStation, Map<String, String> tags) {
        String stationName;
        if (!transferZoneGroup.hasName() && (stationName = tags.get("name")) != null) {
            transferZoneGroup.setName(stationName);
        }
    }

    public TransferZoneGroupHelper(PlanitOsmNetwork referenceNetwork, Zoning zoning, OsmZoningReaderData zoningReaderData, OsmNetworkToZoningReaderData network2ZoningData, OsmPublicTransportReaderSettings transferSettings, OsmZoningHandlerProfiler profiler) {
        super(referenceNetwork, network2ZoningData, transferSettings);
        this.zoning = zoning;
        this.profiler = profiler;
        this.zoningReaderData = zoningReaderData;
        this.transferZoneParser = new TransferZoneHelper(referenceNetwork, zoning, zoningReaderData, network2ZoningData, transferSettings, profiler);
        this.ptModeParser = new OsmPublicTransportModeConversion(this.getNetworkToZoningData().getNetworkSettings(), transferSettings, (Iterable<Mode>)referenceNetwork.getModes());
    }

    public TransferZoneGroup createAndPopulateTransferZoneGroup(OsmRelation osmRelation, Map<String, String> tags) {
        TransferZoneGroup transferZoneGroup = this.zoning.getTransferZoneGroups().getFactory().createNew();
        transferZoneGroup.setXmlId(String.valueOf(transferZoneGroup.getId()));
        transferZoneGroup.setExternalId(String.valueOf(osmRelation.getId()));
        if (tags.containsKey("name")) {
            transferZoneGroup.setName(tags.get("name"));
        }
        return transferZoneGroup;
    }

    public TransferZoneGroup createPopulateAndRegisterTransferZoneGroup(OsmRelation osmRelation, Map<String, String> tags) {
        TransferZoneGroup transferZoneGroup = this.createAndPopulateTransferZoneGroup(osmRelation, tags);
        this.zoning.getTransferZoneGroups().register((Object)transferZoneGroup);
        this.zoningReaderData.getPlanitData().addTransferZoneGroupByOsmId(osmRelation.getId(), transferZoneGroup);
        this.profiler.logTransferZoneGroupStatus(this.zoning.getTransferZoneGroups().size());
        return transferZoneGroup;
    }

    public Set<TransferZoneGroup> findModeCompatibleTransferZoneGroups(Collection<String> referenceOsmModes, Collection<TransferZone> potentialTransferZones, boolean allowPseudoModeMatches) {
        HashSet<TransferZoneGroup> potentialTransferZoneGroups = new HashSet<TransferZoneGroup>();
        Set<TransferZone> filteredTransferZones = this.transferZoneParser.filterModeCompatibleTransferZones(referenceOsmModes, potentialTransferZones, allowPseudoModeMatches, false);
        if (filteredTransferZones != null && !filteredTransferZones.isEmpty()) {
            for (TransferZone transferZone : filteredTransferZones) {
                Set transferZoneGroups = transferZone.getTransferZoneGroups();
                if (transferZoneGroups == null || transferZoneGroups.isEmpty()) continue;
                potentialTransferZoneGroups.addAll(transferZoneGroups);
            }
        }
        return potentialTransferZoneGroups;
    }

    public boolean registerTransferZoneOnGroup(long osmId, EntityType type, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        return this.registerTransferZoneOnGroup(osmId, type, null, transferZoneGroup, suppressLogging);
    }

    public boolean registerTransferZoneOnGroup(OsmEntity osmEntity, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        return this.registerTransferZoneOnGroup(osmEntity.getId(), Osm4JUtils.getEntityType(osmEntity), OsmModelUtil.getTagsAsMap((OsmEntity)osmEntity), transferZoneGroup, suppressLogging);
    }

    public boolean registerTransferZoneOnGroup(OsmNode osmNode, Map<String, String> tags, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        return this.registerTransferZoneOnGroup(osmNode.getId(), EntityType.Node, tags, transferZoneGroup, suppressLogging);
    }
}

