/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.Point;

class OsmZoningHelperBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningHelperBase.class.getCanonicalName());
    private final OsmPublicTransportReaderSettings transferSettings;
    private final OsmNetworkToZoningReaderData network2ZoningData;
    private final PlanitOsmNetwork referenceNetwork;

    protected OsmPublicTransportReaderSettings getSettings() {
        return this.transferSettings;
    }

    protected PlanitOsmNetwork getReferenceNetwork() {
        return this.referenceNetwork;
    }

    protected OsmNetworkToZoningReaderData getNetworkToZoningData() {
        return this.network2ZoningData;
    }

    protected boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId) {
        return PlanitNetworkLayerUtils.hasNetworkLayersWithActiveOsmNode(osmNodeId, this.referenceNetwork, this.network2ZoningData);
    }

    protected Pair<Integer, Boolean> findOsmVerticalLayerIndexByStopPositionPlanitLinks(Point stopPositionLocation, NetworkLayer layer) {
        Node planitNode;
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData(layer);
        Collection<Object> planitLinks = layerData.findPlanitLinksWithInternalLocation(stopPositionLocation);
        if ((planitLinks == null || planitLinks.isEmpty()) && (planitNode = layerData.getPlanitNodeByLocation(stopPositionLocation)) != null && planitNode.hasLinks()) {
            planitLinks = planitNode.getLinks();
        }
        if (planitLinks != null && !planitLinks.isEmpty()) {
            Integer verticalLayerIndex = OsmNetworkHandlerHelper.getMostFrequentVerticalLayerIndex(planitLinks);
            boolean consistent = planitLinks.stream().allMatch(l -> OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)l) == verticalLayerIndex);
            return Pair.of((Object)verticalLayerIndex, (Object)consistent);
        }
        return null;
    }

    protected OsmZoningHelperBase(PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData, OsmPublicTransportReaderSettings transferSettings) {
        this.transferSettings = transferSettings;
        this.network2ZoningData = network2ZoningData;
        this.referenceNetwork = referenceNetwork;
    }
}

