/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import org.goplanit.osm.converter.OsmModeConversionBase;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmPublicTransportModeConversion
extends OsmModeConversionBase {
    private final OsmPublicTransportReaderSettings ptSettings;

    public OsmPublicTransportModeConversion(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings ptSettings, Iterable<Mode> layerModes) {
        super(networkSettings, layerModes);
        this.ptSettings = ptSettings;
    }

    public Pair<SortedSet<String>, SortedSet<PredefinedModeType>> collectPublicTransportModesFromPtEntity(long osmPtEntityId, EntityType osmEntityType, Map<String, String> tags, String defaultMode) {
        SortedSet<String> eligibleOsmModes = this.ptSettings.isOverwriteWaitingAreaModeAccess(osmPtEntityId, osmEntityType) ? this.ptSettings.getOverwrittenWaitingAreaModeAccess(osmPtEntityId, osmEntityType) : OsmModeUtils.collectEligibleOsmPublicTransportModesOnPtOsmEntity(osmPtEntityId, tags, defaultMode);
        if (eligibleOsmModes == null || eligibleOsmModes.isEmpty()) {
            return null;
        }
        SortedSet<PredefinedModeType> eligiblePlanitModes = this.getSettings().getActivatedPlanitModeTypes(eligibleOsmModes);
        return Pair.of(eligibleOsmModes, eligiblePlanitModes);
    }

    public Pair<SortedSet<String>, SortedSet<PredefinedModeType>> collectPublicTransportModesFromPtEntity(OsmEntity osmEntity, Map<String, String> tags, String defaultMode) {
        return this.collectPublicTransportModesFromPtEntity(osmEntity.getId(), Osm4JUtils.getEntityType(osmEntity), tags, defaultMode);
    }

    public Pair<Collection<String>, Collection<PredefinedModeType>> collectModesFromPtEntity(long osmPtEntityId, Map<String, String> tags, String defaultMode) {
        Collection<String> eligibleOsmModes = OsmModeUtils.collectEligibleOsmModesOnPtOsmEntity(osmPtEntityId, tags, defaultMode);
        if (eligibleOsmModes == null || eligibleOsmModes.isEmpty()) {
            return null;
        }
        SortedSet<PredefinedModeType> eligiblePlanitModes = this.getSettings().getActivatedPlanitModeTypes(eligibleOsmModes);
        return Pair.of(eligibleOsmModes, eligiblePlanitModes);
    }
}

