/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.zoning.ZoningConverterUtils;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmZoningReaderPlanitData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.OsmZoningHelperBase;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.PlanitLinkOsmUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.misc.IterableUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.ConnectoidUtils;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.modifier.event.handler.UpdateDirectedConnectoidsOnBreakLinkSegmentHandler;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;

public class OsmConnectoidHelper
extends OsmZoningHelperBase {
    private static final Logger LOGGER = Logger.getLogger(OsmConnectoidHelper.class.getCanonicalName());
    private final Function<Node, String> getOverwrittenWaitingAreaSourceIdForNode;
    private final PlanitOsmNetwork referenceNetwork;
    private final Zoning zoning;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmZoningHandlerProfiler profiler;
    private final PlanitJtsCrsUtils geoUtils;

    private static boolean isWaitingAreaForPtModeRestrictedToDrivingDirectionLocation(Mode accessMode, TransferZone transferZone, Long osmStopLocationNodeId, OsmPublicTransportReaderSettings settings) {
        boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessMode((Mode)accessMode);
        if (osmStopLocationNodeId != null && settings.isOverwriteWaitingAreaOfStopLocation(osmStopLocationNodeId)) {
            mustAvoidCrossingTraffic = !Long.valueOf(transferZone.getExternalId()).equals(settings.getOverwrittenWaitingAreaOfStopLocation(osmStopLocationNodeId).second());
        }
        return mustAvoidCrossingTraffic;
    }

    private void logWarningIfNotNearBoundingBox(String message, Geometry geometry) {
        OsmBoundingAreaUtils.logWarningIfNotNearBoundingBox(message, geometry, this.getNetworkToZoningData().getNetworkBoundingBox(), this.geoUtils);
    }

    private Collection<LinkSegment> findAccessLinkSegmentsForStandAloneTransferZone(TransferZone transferZone, MacroscopicLink accessLink, Node node, Mode accessMode, boolean mustAvoidCrossingTraffic, boolean ignoreOsmVerticalLayerCompatibility, PlanitJtsCrsUtils geoUtils) {
        OsmZoningReaderPlanitData planitData;
        Integer osmVerticalLayerIndex;
        if (!ignoreOsmVerticalLayerCompatibility && (osmVerticalLayerIndex = (planitData = this.zoningReaderData.getPlanitData()).getTransferZoneVerticalLayerIndex(transferZone)) != null && osmVerticalLayerIndex != OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)accessLink)) {
            return null;
        }
        Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId = tzOsmId -> {
            EntityType osmWaitingAreaEntityType = PlanitTransferZoneUtils.transferZoneGeometryToOsmEntityType(transferZone.getGeometry(true));
            Long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(Long.valueOf(tzOsmId), osmWaitingAreaEntityType);
            return osmWayId != null ? String.valueOf(osmWayId) : null;
        };
        return ZoningConverterUtils.findAccessEntryLinkSegmentsForWaitingArea((String)transferZone.getExternalId(), (Geometry)transferZone.getGeometry(true), (MacroscopicLink)accessLink, (String)accessLink.getExternalId(), (Node)node, (Mode)accessMode, (String)this.getSettings().getCountryName(), (boolean)mustAvoidCrossingTraffic, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, this.getOverwrittenWaitingAreaSourceIdForNode, (PlanitJtsCrsUtils)geoUtils);
    }

    private void updateDirectedConnectoid(DirectedConnectoid connectoidToUpdate, TransferZone accessZone, Set<Mode> allowedModes) {
        Set realAllowedModes = ((MacroscopicLinkSegment)connectoidToUpdate.getAccessLinkSegment()).getAllowedModesFrom(allowedModes);
        if (realAllowedModes != null && !realAllowedModes.isEmpty()) {
            if (!connectoidToUpdate.hasAccessZone((Zone)accessZone)) {
                connectoidToUpdate.addAccessZone((Zone)accessZone);
            }
            connectoidToUpdate.addAllowedModes((Zone)accessZone, (Collection)realAllowedModes);
        }
    }

    private void breakLinksAtPlanitNode(Node planitNode, MacroscopicNetworkLayer networkLayer, List<MacroscopicLink> linksToBreak) {
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer);
        Map connectoidsAccessNodeLocationBeforeBreakLink = ConnectoidUtils.findDirectedConnectoidsReferencingLinks(linksToBreak, this.zoningReaderData.getPlanitData().getDirectedConnectoidsByLocation(networkLayer));
        UpdateDirectedConnectoidsOnBreakLinkSegmentHandler listener = new UpdateDirectedConnectoidsOnBreakLinkSegmentHandler(connectoidsAccessNodeLocationBeforeBreakLink);
        networkLayer.getLayerModifier().addListener((GraphModifierListener)listener);
        this.zoningReaderData.getPlanitData().removeLinksFromSpatialLinkIndex(linksToBreak);
        Map newlyBrokenLinks = networkLayer.getLayerModifier().breakAt(linksToBreak, (DirectedVertex)planitNode, this.referenceNetwork.getCoordinateReferenceSystem(), l -> Long.parseLong(l.getExternalId()));
        newlyBrokenLinks.forEach((id, links) -> this.zoningReaderData.getPlanitData().addLinksToSpatialLinkIndex((Collection<MacroscopicLink>)links));
        layerData.updateOsmWaysWithMultiplePlanitLinks(newlyBrokenLinks);
        networkLayer.getLayerModifier().removeListener((GraphModifierListener)listener);
    }

    private Collection<DirectedConnectoid> createAndRegisterDirectedConnectoids(TransferZone transferZone, MacroscopicNetworkLayer networkLayer, Node accessNode, Iterable<? extends EdgeSegment> linkSegments, Set<Mode> allowedModes, boolean verifyOsmVerticalLayerCompatibility) {
        Integer osmVerticalLayerIndex;
        if (!verifyOsmVerticalLayerCompatibility && (osmVerticalLayerIndex = this.zoningReaderData.getPlanitData().getTransferZoneVerticalLayerIndex(transferZone)) != null && !IterableUtils.asStream(linkSegments).allMatch(ls -> OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)ls.getParent()) == this.zoningReaderData.getPlanitData().getTransferZoneVerticalLayerIndex(transferZone))) {
            LOGGER.warning(String.format("OSM vertical layer index (layer=%d) of PLANit transfer zone (%s) not compatible with selected access link segments [%s] for its connectoids, this shouldn't happen, verify correctness", osmVerticalLayerIndex, transferZone.getIdsAsString(), IterableUtils.asStream(linkSegments).map(ls -> ls.getIdsAsString()).collect(Collectors.joining(","))));
        }
        Collection createdConnectoids = ZoningConverterUtils.createAndRegisterDirectedConnectoids((Zoning)this.zoning, (TransferZone)transferZone, (Node)accessNode, linkSegments, allowedModes);
        for (DirectedConnectoid newConnectoid : createdConnectoids) {
            this.zoningReaderData.getPlanitData().addDirectedConnectoidByLocation(networkLayer, newConnectoid.getAccessLinkSegment().getDownstreamVertex().getPosition(), newConnectoid);
            this.zoningReaderData.getPlanitData().addConnectoidByTransferZone(transferZone, newConnectoid);
        }
        return createdConnectoids;
    }

    private boolean extractDirectedConnectoidsForModeLinkSegments(TransferZone transferZone, Mode planitMode, Node accessNode, Collection<LinkSegment> eligibleLinkSegments, boolean ignoreOsmVerticalLayerCompatibilityCheck, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.referenceNetwork.getLayerByMode(planitMode);
        for (EdgeSegment edgeSegment : eligibleLinkSegments) {
            Point proposedConnectoidLocation = accessNode.getPosition();
            boolean createConnectoidsForLinkSegment = true;
            if (this.zoningReaderData.getPlanitData().hasDirectedConnectoidForLocation((NetworkLayer)networkLayer, proposedConnectoidLocation)) {
                List<DirectedConnectoid> connectoidsForNode = this.zoningReaderData.getPlanitData().getDirectedConnectoidsByLocation(proposedConnectoidLocation, networkLayer);
                for (DirectedConnectoid connectoid : connectoidsForNode) {
                    if (!edgeSegment.idEquals((Object)connectoid.getAccessLinkSegment())) continue;
                    this.updateDirectedConnectoid(connectoid, transferZone, Collections.singleton(planitMode));
                    createConnectoidsForLinkSegment = false;
                    break;
                }
            }
            if (!createConnectoidsForLinkSegment) continue;
            Collection<DirectedConnectoid> newConnectoids = this.createAndRegisterDirectedConnectoids(transferZone, networkLayer, accessNode, Collections.singleton(edgeSegment), Collections.singleton(planitMode), ignoreOsmVerticalLayerCompatibilityCheck || suppressLogging);
            if (suppressLogging || newConnectoids != null && !newConnectoids.isEmpty()) continue;
            LOGGER.warning(String.format("Found eligible mode %s for stop_location of transfer zone %s, but no access link segment supports this mode", planitMode.getExternalId(), transferZone.getExternalId()));
            return false;
        }
        return true;
    }

    private Node extractConnectoidAccessNodeByLocation(Point osmNodeLocation, boolean locationIsKnownOsmStopPosition, MacroscopicNetworkLayer networkLayer, Integer osmWaitingAreaVerticalLayerIndex, String osmWaitingAreaId, boolean suppressLogging) {
        List<MacroscopicLink> linksToBreak;
        OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer);
        Node planitNode = layerData.getPlanitNodeByLocation(osmNodeLocation);
        if (planitNode == null && (linksToBreak = layerData.findPlanitLinksWithInternalLocation(osmNodeLocation)) != null) {
            OsmNode osmNode = layerData.getOsmNodeByLocation(osmNodeLocation);
            if (!suppressLogging && !linksToBreak.stream().allMatch(l -> osmWaitingAreaVerticalLayerIndex != null && OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)l) == osmWaitingAreaVerticalLayerIndex || osmWaitingAreaVerticalLayerIndex == null && OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)l) == 0)) {
                String osmNodeRef;
                String osmLayerIndices = linksToBreak.stream().map(l -> l.getIdsAsString() + " layer=" + OsmNetworkHandlerHelper.getLinkVerticalLayerIndex((Link)l)).collect(Collectors.joining(","));
                Level logLevel = locationIsKnownOsmStopPosition ? Level.INFO : Level.WARNING;
                String stopPositionContext = locationIsKnownOsmStopPosition ? "Explicit" : "Deduced";
                String followUpAdvice = locationIsKnownOsmStopPosition ? "possible tagging error" : "verify correctness";
                String string = osmNodeRef = osmNode != null ? String.valueOf(osmNode.getId()) : "-";
                if (osmWaitingAreaVerticalLayerIndex == null) {
                    LOGGER.log(logLevel, String.format("%s stop_position (%s) on location (%s) part of links [%s] differs from waiting area (%s) that has no OSM vertical layer defined, %s", stopPositionContext, osmNodeRef, osmNodeLocation, osmLayerIndices, osmWaitingAreaId, followUpAdvice));
                } else {
                    LOGGER.log(logLevel, String.format("%s stop_position (%s) on location (%s) part of links [%s] differs from OSM waiting area's (%s) explicit OSM layer (layer=%d), %s", stopPositionContext, osmNodeRef, osmNodeLocation, osmLayerIndices, osmWaitingAreaId, osmWaitingAreaVerticalLayerIndex, followUpAdvice));
                }
            }
            planitNode = osmNode != null ? PlanitNetworkLayerUtils.createPopulateAndRegisterNode(osmNode, networkLayer, layerData) : PlanitNetworkLayerUtils.createPopulateAndRegisterNode(osmNodeLocation, networkLayer, layerData);
            this.profiler.logConnectoidStatus(this.zoning.getTransferConnectoids().size());
            this.breakLinksAtPlanitNode(planitNode, networkLayer, linksToBreak);
        }
        return planitNode;
    }

    private Node extractConnectoidAccessNodeByOsmNode(OsmNode osmNode, boolean locationIsKnownOsmStopPosition, MacroscopicNetworkLayer networkLayer, Integer osmVerticalLayerIndex, String osmWaitingAreaId, boolean suppressLogging) {
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        return this.extractConnectoidAccessNodeByLocation(osmNodeLocation, locationIsKnownOsmStopPosition, networkLayer, osmVerticalLayerIndex, osmWaitingAreaId, suppressLogging);
    }

    private Point extractConnectoidLocationForstandAloneTransferZoneOnLink(TransferZone transferZone, MacroscopicLink accessLink, PredefinedModeType planitAccessModeType, double maxAllowedStopToTransferZoneDistanceMeters, MacroscopicNetworkLayer networkLayer) {
        Coordinate closestExistingCoordinate;
        Point connectoidLocation = this.findConnectoidLocationForStandAloneTransferZoneOnLink(transferZone, accessLink, planitAccessModeType, maxAllowedStopToTransferZoneDistanceMeters);
        if (connectoidLocation != null && !(closestExistingCoordinate = this.geoUtils.getClosestExistingLineStringCoordinateToGeometry(transferZone.getGeometry(), accessLink.getGeometry())).equals2D(connectoidLocation.getCoordinate())) {
            LinearLocation projectedLinearLocationOnLink = PlanitEntityGeoUtils.extractClosestProjectedLinearLocationToGeometryFromEdge((Geometry)transferZone.getGeometry(true), (Edge)accessLink, (PlanitJtsCrsUtils)this.geoUtils);
            accessLink.updateGeometryInjectCoordinateAtProjectedLocation(projectedLinearLocationOnLink);
            this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).registerLocationAsInternalToPlanitLink(connectoidLocation, accessLink);
        }
        return connectoidLocation;
    }

    public OsmConnectoidHelper(PlanitOsmNetwork referenceNetwork, Zoning zoning, OsmZoningReaderData zoningReaderData, OsmNetworkToZoningReaderData network2ZoningData, OsmPublicTransportReaderSettings transferSettings, OsmZoningHandlerProfiler profiler) {
        super(referenceNetwork, network2ZoningData, transferSettings);
        this.referenceNetwork = referenceNetwork;
        this.zoning = zoning;
        this.zoningReaderData = zoningReaderData;
        this.profiler = profiler;
        this.getOverwrittenWaitingAreaSourceIdForNode = n -> {
            Pair<EntityType, Long> result = transferSettings.getOverwrittenWaitingAreaOfStopLocation(n.getExternalId() != null ? Long.valueOf(n.getExternalId()) : null);
            return result != null ? String.valueOf(result.second()) : null;
        };
        this.geoUtils = new PlanitJtsCrsUtils(referenceNetwork.getCoordinateReferenceSystem());
    }

    public Point findConnectoidLocationForStandAloneTransferZoneOnLink(TransferZone transferZone, MacroscopicLink accessLink, PredefinedModeType planitModeType, double maxAllowedDistanceMeters) {
        PredefinedMode planitMode = this.referenceNetwork.getModes().get(planitModeType);
        Function<Point, String> getOverwrittenWaitingAreaSourceIdForPoint = arg_0 -> this.lambda$findConnectoidLocationForStandAloneTransferZoneOnLink$8((Mode)planitMode, arg_0);
        Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId = tzOsmId -> {
            EntityType osmWaitingAreaEntityType = PlanitTransferZoneUtils.transferZoneGeometryToOsmEntityType(transferZone.getGeometry());
            Long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(Long.valueOf(tzOsmId), osmWaitingAreaEntityType);
            return osmWayId != null ? String.valueOf(osmWayId) : null;
        };
        return ZoningConverterUtils.findConnectoidLocationForWaitingAreaOnLink((String)transferZone.getExternalId(), (Geometry)transferZone.getGeometry(true), (MacroscopicLink)accessLink, (String)accessLink.getExternalId(), (Mode)planitMode, (double)maxAllowedDistanceMeters, this.getOverwrittenWaitingAreaSourceIdForNode, getOverwrittenWaitingAreaSourceIdForPoint, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, (String)this.getSettings().getCountryName(), (PlanitJtsCrsUtils)this.geoUtils);
    }

    public Collection<DirectedConnectoid> createAndRegisterDirectedConnectoidsOnTopOfTransferZone(TransferZone transferZone, MacroscopicNetworkLayer networkLayer, PredefinedModeType planitModeType, PlanitJtsCrsUtils geoUtils) {
        OsmNode osmNode = this.getNetworkToZoningData().getNetworkOsmNodes().get(Long.valueOf(transferZone.getExternalId()));
        boolean suppressLogging = false;
        Node accessNode = null;
        Iterable nominatedLinkSegments = null;
        if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmNode.getId(), EntityType.Node)) {
            double nodeBDistance;
            long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmNode.getId(), EntityType.Node);
            MacroscopicLink nominatedLink = PlanitLinkOsmUtils.getClosestLinkWithOsmWayIdToGeometry(osmWayId, (Geometry)OsmNodeUtils.createPoint(osmNode), networkLayer, geoUtils);
            if (nominatedLink == null) {
                LOGGER.severe(String.format("IGNORE: User nominated OSM way not available for waiting area on road infrastructure %d", osmWayId));
                return null;
            }
            nominatedLinkSegments = nominatedLink.getEdgeSegments();
            suppressLogging = true;
            double nodeADistance = geoUtils.getDistanceInMetres(nominatedLink.getVertexA().getPosition().getCoordinate(), OsmNodeUtils.createCoordinate(osmNode));
            accessNode = nodeADistance < (nodeBDistance = geoUtils.getDistanceInMetres(nominatedLink.getVertexB().getPosition().getCoordinate(), OsmNodeUtils.createCoordinate(osmNode))) ? nominatedLink.getNodeA() : nominatedLink.getNodeB();
        } else {
            boolean locationIsKnownOsmStopPosition = true;
            Integer waitingAreaOsmVerticalLayerIndex = this.zoningReaderData.getPlanitData().getTransferZoneVerticalLayerIndex(transferZone);
            accessNode = this.extractConnectoidAccessNodeByOsmNode(osmNode, locationIsKnownOsmStopPosition, networkLayer, waitingAreaOsmVerticalLayerIndex, transferZone.getExternalId(), suppressLogging);
            if (accessNode == null) {
                LOGGER.warning(String.format("DISCARD: OSM node (%d) could not be converted to access node for transfer zone OSM entity %s at same location", osmNode.getId(), transferZone.getExternalId()));
                return null;
            }
            nominatedLinkSegments = accessNode.getEntryEdgeSegments();
        }
        boolean ignoreOsmVerticalLayerCompatibility = suppressLogging;
        return this.createAndRegisterDirectedConnectoids(transferZone, networkLayer, accessNode, nominatedLinkSegments, Collections.singleton(this.referenceNetwork.getModes().get(planitModeType)), ignoreOsmVerticalLayerCompatibility);
    }

    public boolean extractDirectedConnectoidsForMode(Point location, boolean locationIsKnownOsmStopPosition, TransferZone transferZone, PredefinedModeType planitModeType, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        boolean mustAvoidCrossingTraffic;
        Node planitAccessNode;
        Pair<Integer, Boolean> linkBasedResult;
        if (location == null || transferZone == null || planitModeType == null || geoUtils == null) {
            return false;
        }
        PredefinedMode planitMode = this.referenceNetwork.getModes().get(planitModeType);
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.referenceNetwork.getLayerByMode((Mode)planitMode);
        OsmNode osmNode = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).getOsmNodeByLocation(location);
        Integer waitingAreaOsmVerticalLayerIndex = this.zoningReaderData.getPlanitData().getTransferZoneVerticalLayerIndex(transferZone);
        if (waitingAreaOsmVerticalLayerIndex == null && !locationIsKnownOsmStopPosition && (linkBasedResult = this.findOsmVerticalLayerIndexByStopPositionPlanitLinks(location, (NetworkLayer)networkLayer)) != null && ((Boolean)linkBasedResult.second()).booleanValue()) {
            waitingAreaOsmVerticalLayerIndex = (Integer)linkBasedResult.first();
        }
        if ((planitAccessNode = this.extractConnectoidAccessNodeByLocation(location, locationIsKnownOsmStopPosition, networkLayer, waitingAreaOsmVerticalLayerIndex, transferZone.getExternalId(), suppressLogging)) == null) {
            if (osmNode != null) {
                if (!suppressLogging) {
                    LOGGER.warning(String.format("DISCARD: OSM node %d could not be converted to access node for transfer zone representation of OSM entity %s", osmNode.getId(), transferZone.getExternalId()));
                }
            } else if (!suppressLogging) {
                LOGGER.warning(String.format("DISCARD: Location (%s) could not be converted to access node for transfer zone representation of OSM entity %s", location, transferZone.getExternalId()));
            }
            return false;
        }
        boolean bl = mustAvoidCrossingTraffic = !planitAccessNode.getPosition().equalsTopo(transferZone.getGeometry());
        if (mustAvoidCrossingTraffic) {
            mustAvoidCrossingTraffic = OsmConnectoidHelper.isWaitingAreaForPtModeRestrictedToDrivingDirectionLocation((Mode)planitMode, transferZone, osmNode != null ? Long.valueOf(osmNode.getId()) : null, this.getSettings());
        }
        Collection<LinkSegment> accessLinkSegments = null;
        boolean ignoreOsmVerticalLayerCompatibility = locationIsKnownOsmStopPosition;
        for (MacroscopicLink link : planitAccessNode.getLinks()) {
            Collection<LinkSegment> linkAccessLinkSegments = this.findAccessLinkSegmentsForStandAloneTransferZone(transferZone, link, planitAccessNode, (Mode)planitMode, mustAvoidCrossingTraffic, ignoreOsmVerticalLayerCompatibility, geoUtils);
            if (linkAccessLinkSegments == null || linkAccessLinkSegments.isEmpty()) continue;
            if (accessLinkSegments == null) {
                accessLinkSegments = linkAccessLinkSegments;
                continue;
            }
            accessLinkSegments.addAll(linkAccessLinkSegments);
        }
        if (accessLinkSegments == null || accessLinkSegments.isEmpty()) {
            if (!suppressLogging) {
                LOGGER.warning(String.format("DISCARD platform/pole/station %s its stop_location %s deemed invalid, no access link segment found due to mode inaccessibility/exclusion, or on wrong side of road/rail, verify correctness", transferZone.getExternalId(), location));
            }
            return false;
        }
        return this.extractDirectedConnectoidsForModeLinkSegments(transferZone, (Mode)planitMode, planitAccessNode, accessLinkSegments, ignoreOsmVerticalLayerCompatibility, suppressLogging, geoUtils);
    }

    public boolean extractDirectedConnectoidsForMode(OsmNode osmNode, boolean locationIsKnownOsmStopPosition, TransferZone transferZone, PredefinedModeType planitModeType, boolean suppressLogging, PlanitJtsCrsUtils geoUtils) {
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        return this.extractDirectedConnectoidsForMode(osmNodeLocation, locationIsKnownOsmStopPosition, transferZone, planitModeType, suppressLogging, geoUtils);
    }

    public boolean extractDirectedConnectoids(OsmNode osmNode, boolean locationIsKnownOsmStopPosition, Collection<TransferZone> transferZones, Collection<PredefinedModeType> planitModeTypes, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        boolean success = false;
        for (PredefinedModeType modeType : planitModeTypes) {
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.referenceNetwork.getLayerByPredefinedModeType(modeType);
            if (!this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).isOsmNodePresentInLayer(osmNode) && !suppressLogging) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: stop_position %d not present in network layer for %s (residing road type deactivated or node dangling)", osmNode.getId(), modeType), (Geometry)OsmNodeUtils.createPoint(osmNode));
                continue;
            }
            for (TransferZone transferZone : transferZones) {
                success = this.extractDirectedConnectoidsForMode(osmNode, locationIsKnownOsmStopPosition, transferZone, modeType, suppressLogging, this.geoUtils) || success;
                if (!success || transferZoneGroup == null || transferZone.isInTransferZoneGroup(transferZoneGroup)) continue;
                if (!suppressLogging && !transferZone.getExternalId().equals(String.valueOf(osmNode.getId()))) {
                    LOGGER.info(String.format("Platform/pole %s identified for stop_position %d, platform/pole not in stop_area %s of stop_position, added it", transferZone.getExternalId(), osmNode.getId(), transferZoneGroup.getExternalId()));
                }
                transferZoneGroup.addTransferZone(transferZone);
            }
        }
        return success;
    }

    public void extractDirectedConnectoidsForStandAloneTransferZoneByPlanitLink(long osmWaitingAreaId, Geometry waitingAreaGeometry, MacroscopicLink accessLink, TransferZone transferZone, PredefinedModeType planitAccessModeType, double maxAllowedStopToTransferZoneDistanceMeters, MacroscopicNetworkLayer networkLayer, boolean suppressLogging) {
        OsmNode osmStopLocationNode;
        if (osmWaitingAreaId == 459973944L) {
            int n = 4;
        }
        Point connectoidLocation = this.extractConnectoidLocationForstandAloneTransferZoneOnLink(transferZone, accessLink, planitAccessModeType, maxAllowedStopToTransferZoneDistanceMeters, networkLayer);
        if (!suppressLogging && connectoidLocation == null) {
            this.logWarningIfNotNearBoundingBox(String.format("DISCARD: Unable to create stop_location on identified access link %s, identified location is likely too far from waiting area %s", accessLink.getExternalId(), transferZone.getExternalId()), transferZone.getGeometry());
        }
        if ((osmStopLocationNode = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).getOsmNodeByLocation(connectoidLocation)) != null && this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmStopLocationNode.getId())) {
            Pair<EntityType, Long> overwriteResult = this.getSettings().getOverwrittenWaitingAreaOfStopLocation(osmStopLocationNode.getId());
            if (!(waitingAreaGeometry instanceof Point) || Long.valueOf(transferZone.getExternalId()) != overwriteResult.second()) {
                return;
            }
            if (Long.valueOf(transferZone.getExternalId()) != overwriteResult.second()) {
                return;
            }
            suppressLogging = true;
        }
        boolean locationIsKnownOsmStopPosition = false;
        this.extractDirectedConnectoidsForMode(connectoidLocation, locationIsKnownOsmStopPosition, transferZone, planitAccessModeType, suppressLogging, this.geoUtils);
    }

    private /* synthetic */ String lambda$findConnectoidLocationForStandAloneTransferZoneOnLink$8(Mode planitMode, Point p) {
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.referenceNetwork.getLayerByMode(planitMode);
        OsmNode osmNode = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).getOsmNodeByLocation(p);
        if (osmNode == null) {
            return null;
        }
        Pair<EntityType, Long> result = this.getSettings().getOverwrittenWaitingAreaOfStopLocation(osmNode.getId());
        return result != null ? String.valueOf(result.second()) : null;
    }
}

