/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.utils.functionalinterface.TriConsumer;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.zoning.Zoning;

public class OsmZoningPreProcessingHandler
extends OsmZoningHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningPreProcessingHandler.class.getCanonicalName());
    private final Stage stage;

    private void identifyPlatformAsRelation(OsmRelation osmRelation, Map<String, String> tags) {
        boolean preserveOuterRole = false;
        if (tags.get("type").equals("multipolygon") && tags.get("public_transport").equals("platform")) {
            this.getProfiler().incrementMultiPolygonPlatformCounter();
            preserveOuterRole = true;
        } else if (tags.get("type").equals("public_transport") && tags.get("public_transport").equals("platform")) {
            this.getProfiler().incrementPlatformRelationCounter();
            preserveOuterRole = true;
        }
        if (preserveOuterRole) {
            int numberOfMembers = osmRelation.getNumberOfMembers();
            for (int index = 0; index < numberOfMembers; ++index) {
                OsmRelationMember member = osmRelation.getMember(index);
                if (this.skipOsmPtEntity(member) || member.getType() != EntityType.Way || !member.getRole().equals("outer")) continue;
                this.getZoningReaderData().getOsmData().markOsmRelationOuterRoleOsmWayToKeep(member.getId());
            }
        }
    }

    private void preRegisterPtNodes(OsmWay osmWay) {
        for (int index = 0; index < osmWay.getNumberOfNodes(); ++index) {
            this.getZoningReaderData().getOsmData().getOsmNodeData().preRegisterEligibleOsmNode(osmWay.getNodeId(index));
        }
    }

    private void identifyPlatformOuterRoleNodes(OsmWay osmWay) {
        if (this.getZoningReaderData().getOsmData().shouldOsmRelationOuterRoleOsmWayBeKept(osmWay)) {
            this.preRegisterPtNodes(osmWay);
        }
    }

    private void preRegisterEligiblePtNodesOfWay(OsmWay osmWay, OsmPtVersionScheme osmPtVersionScheme, Map<String, String> tags) {
        this.preRegisterPtNodes(osmWay);
    }

    private void preRegisterEligiblePtNodesOfRelation(OsmRelation osmRelation, Map<String, String> stringStringMap) {
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember member = osmRelation.getMember(index);
            if (this.skipOsmPtEntity(member)) continue;
            if (member.getType().equals((Object)EntityType.Node) && StringUtils.isNullOrBlank((String)member.getRole())) {
                this.getZoningReaderData().getOsmData().getOsmNodeData().preRegisterEligibleOsmNode(member.getId());
            }
            if (!member.getRole().equals("platform")) continue;
        }
    }

    public OsmZoningPreProcessingHandler(PlanitOsmNetwork referenceNetwork, Zoning zoningToPopulate, OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData zoningReaderData, OsmNetworkToZoningReaderData network2ZoningData, Stage stage, OsmZoningHandlerProfiler profiler) {
        super(transferSettings, zoningReaderData, network2ZoningData, referenceNetwork, zoningToPopulate, profiler);
        this.stage = stage;
    }

    @Override
    public void initialiseBeforeParsing() {
        this.reset();
    }

    public void handle(OsmWay osmWay) {
        if (osmWay.getId() == 20959049L) {
            int n = 4;
        }
        if (this.stage != Stage.IDENTIFY_PT_NODES) {
            return;
        }
        this.identifyPlatformOuterRoleNodes(osmWay);
        this.wrapHandlePtOsmWay(osmWay, (TriConsumer<OsmWay, OsmPtVersionScheme, Map<String, String>>)((TriConsumer)this::preRegisterEligiblePtNodesOfWay));
    }

    public void handle(OsmRelation osmRelation) throws IOException {
        if (this.stage != Stage.IDENTIFY_PLATFORM_AS_RELATIONS) {
            return;
        }
        this.wrapHandlePtOsmRelation(osmRelation, this::identifyPlatformAsRelation);
        this.wrapHandlePtOsmRelation(osmRelation, this::preRegisterEligiblePtNodesOfRelation);
    }

    public void complete() throws IOException {
        LOGGER.fine(" OSM zone pre-parsing...DONE");
    }

    @Override
    public void reset() {
    }

    public static enum Stage {
        IDENTIFY_PLATFORM_AS_RELATIONS,
        IDENTIFY_PT_NODES;

    }
}

