/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.converter.zoning.ZoningConverterUtils;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmZoningReaderOsmData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneGroupHelper;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.osm.tags.OsmWaterModeTags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.osm.util.OsmPtVersionSchemeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitLinkOsmUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.linearref.LinearLocation;

public class OsmZoningPostProcessingHandler
extends OsmZoningHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningPostProcessingHandler.class.getCanonicalName());
    private Map<MacroscopicNetworkLayer, Quadtree> spatiallyIndexedOsmNodesInternalToPlanitLinks = null;

    private static Pair<Double, Integer> determineSearchDistanceAndMaxStopLocationMatchesForStandAloneStation(long osmStationId, String osmStationMode, OsmPublicTransportReaderSettings settings) {
        Double searchDistance = null;
        Integer maxMatches = null;
        if (OsmRailModeTags.isRailModeTag(osmStationMode)) {
            searchDistance = settings.getStationToWaitingAreaSearchRadiusMeters();
            maxMatches = 2;
        } else if (OsmRoadModeTags.isRoadModeTag(osmStationMode)) {
            searchDistance = settings.getStopToWaitingAreaSearchRadiusMeters();
            maxMatches = 1;
        } else if (OsmWaterModeTags.isWaterModeTag(osmStationMode)) {
            LOGGER.warning(String.format("DISCARD: water based stand-alone station detected %d, not supported yet, skip", osmStationId));
            return null;
        }
        return Pair.of((Object)searchDistance, (Object)maxMatches);
    }

    private void initialiseSpatiallyIndexedOsmNodesInternalToPlanitLinks() {
        double envelopeMinExtentAbsolute = Double.POSITIVE_INFINITY;
        for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)this.getReferenceNetwork().getTransportLayers()) {
            OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)layer);
            this.spatiallyIndexedOsmNodesInternalToPlanitLinks.put(layer, new Quadtree());
            Quadtree spatialcontainer = this.spatiallyIndexedOsmNodesInternalToPlanitLinks.get(layer);
            Set<Point> registeredInternalLinkLocations = layerData.getRegisteredLocationsInternalToAnyPlanitLink();
            for (Point location : registeredInternalLinkLocations) {
                OsmNode osmNodeAtLocation = layerData.getOsmNodeInternalToLinkByLocation(location);
                Envelope pointEnvelope = new Envelope(location.getCoordinate());
                this.getGeoUtils().createBoundingBox(pointEnvelope, 5.0);
                spatialcontainer.insert(Quadtree.ensureExtent((Envelope)pointEnvelope, (double)envelopeMinExtentAbsolute), (Object)osmNodeAtLocation);
            }
        }
    }

    private Pair<MacroscopicLink, Set<LinkSegment>> findMostAppropriateStopLocationLinkForWaitingArea(TransferZone transferZone, String osmAccessMode, Collection<MacroscopicLink> eligibleLinks) {
        Function<MacroscopicLink, String> linkToSourceId = l -> l.getExternalId();
        PredefinedModeType accessModeType = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitModeType(osmAccessMode);
        PredefinedMode accessMode = this.getReferenceNetwork().getModes().get(accessModeType);
        HashSet<LinkSegment> accessLinkSegments = new HashSet<LinkSegment>(2);
        for (MacroscopicLink currAccessLink : eligibleLinks) {
            boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessMode((Mode)accessMode);
            Collection currAccessLinkSegments = ZoningConverterUtils.findAccessLinkSegmentsForWaitingArea((String)transferZone.getExternalId(), (Geometry)transferZone.getGeometry(), (MacroscopicLink)currAccessLink, (String)linkToSourceId.apply(currAccessLink), (Mode)accessMode, (String)this.getZoningReaderData().getCountryName(), (boolean)mustAvoidCrossingTraffic, null, null, (PlanitJtsCrsUtils)this.getGeoUtils());
            if (currAccessLinkSegments == null || currAccessLinkSegments.isEmpty()) continue;
            accessLinkSegments.addAll(currAccessLinkSegments);
        }
        Set candidatesToFilter = accessLinkSegments.stream().flatMap(ls -> Stream.of((MacroscopicLink)ls.getParent())).collect(Collectors.toSet());
        HashSet<MacroscopicLink> candidatesWithValidConnectoidLocation = new HashSet<MacroscopicLink>();
        for (MacroscopicLink candidate : candidatesToFilter) {
            if (null == ZoningConverterUtils.findConnectoidLocationForWaitingAreaOnLink((String)transferZone.getExternalId(), (Geometry)transferZone.getGeometry(), (MacroscopicLink)candidate, (String)linkToSourceId.apply(candidate), (Mode)accessMode, (double)this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), null, null, null, (String)this.getZoningReaderData().getCountryName(), (PlanitJtsCrsUtils)this.getGeoUtils())) continue;
            candidatesWithValidConnectoidLocation.add(candidate);
        }
        if (candidatesWithValidConnectoidLocation.isEmpty()) {
            return null;
        }
        if (candidatesWithValidConnectoidLocation.size() == 1) {
            MacroscopicLink selectedAccessLink = (MacroscopicLink)candidatesWithValidConnectoidLocation.iterator().next();
            accessLinkSegments.removeIf(ls -> !ls.getParent().equals(selectedAccessLink));
            return Pair.of((Object)selectedAccessLink, accessLinkSegments);
        }
        Set filteredCandidates = PlanitGraphGeoUtils.findEdgesWithinClosestDistanceDeltaToGeometry((Geometry)transferZone.getGeometry(), candidatesWithValidConnectoidLocation, (double)OsmPublicTransportReaderSettings.DEFAULT_CLOSEST_EDGE_SEARCH_BUFFER_DISTANCE_M, (PlanitJtsCrsUtils)this.getGeoUtils()).keySet();
        accessLinkSegments.removeIf(ls -> !filteredCandidates.contains((MacroscopicLink)ls.getParent()));
        if (filteredCandidates.size() == 1) {
            MacroscopicLink selectedAccessLink = (MacroscopicLink)filteredCandidates.iterator().next();
            accessLinkSegments.removeIf(ls -> !ls.getParent().equals(selectedAccessLink));
            return Pair.of((Object)selectedAccessLink, accessLinkSegments);
        }
        if (accessMode.getPhysicalFeatures().getTrackType() != TrackModeType.RAIL && filteredCandidates.size() > 1 && filteredCandidates.stream().flatMap(l -> l.getLinkSegments().stream()).filter(ls -> accessLinkSegments.contains(ls)).map(ls -> ls.getCapacityOrDefaultPcuHLane()).distinct().count() > 1L) {
            Optional<Double> maxCapacity = accessLinkSegments.stream().map(ls -> ((MacroscopicLinkSegment)ls).getCapacityOrDefaultPcuHLane()).max(Comparator.naturalOrder());
            Set lowerCapacitySegments = filteredCandidates.stream().flatMap(l -> l.getLinkSegments().stream()).filter(ls -> Precision.smaller((double)ls.getCapacityOrDefaultPcuHLane(), (double)((Double)maxCapacity.get()), (double)1.0E-6)).collect(Collectors.toUnmodifiableSet());
            accessLinkSegments.removeAll(lowerCapacitySegments);
            filteredCandidates.removeAll(lowerCapacitySegments.stream().map(ls -> ls.getParentLink()).collect(Collectors.toUnmodifiableSet()));
        }
        MacroscopicLink finalSelectedAccessLink = (MacroscopicLink)filteredCandidates.iterator().next();
        if (filteredCandidates.size() > 1) {
            finalSelectedAccessLink = (MacroscopicLink)PlanitGraphGeoUtils.findEdgeClosest((Geometry)transferZone.getGeometry(), filteredCandidates, (PlanitJtsCrsUtils)this.getGeoUtils());
        }
        MacroscopicLink dummy = finalSelectedAccessLink;
        accessLinkSegments.removeIf(ls -> !ls.getParent().equals(dummy));
        return Pair.of((Object)finalSelectedAccessLink, accessLinkSegments);
    }

    private Collection<MacroscopicLink> findModeBBoxVerticalLayerIdxCompatibleLinksForTransferZone(TransferZone transferZone, Long osmEntityId, String eligibleOsmMode, Envelope searchBoundingBox) {
        Set<String> eligibleOsmModes = Collections.singleton(eligibleOsmMode);
        Collection<MacroscopicLink> spatiallyMatchedLinks = this.getZoningReaderData().getPlanitData().findLinksSpatially(searchBoundingBox);
        if (spatiallyMatchedLinks == null || spatiallyMatchedLinks.isEmpty()) {
            return null;
        }
        Collection<MacroscopicLink> modeAndSpatiallyCompatibleLinks = this.getPtModeHelper().filterModeCompatibleLinks(eligibleOsmModes, spatiallyMatchedLinks, false);
        if (modeAndSpatiallyCompatibleLinks == null || modeAndSpatiallyCompatibleLinks.isEmpty()) {
            return null;
        }
        Collection<MacroscopicLink> modeSpatiallyAndVerticalPlaneCompatibleLinks = this.getTransferZoneHelper().filterVerticalLayerCompatibleLinks(transferZone, modeAndSpatiallyCompatibleLinks, true);
        if (modeSpatiallyAndVerticalPlaneCompatibleLinks == null || modeSpatiallyAndVerticalPlaneCompatibleLinks.isEmpty()) {
            return null;
        }
        return modeSpatiallyAndVerticalPlaneCompatibleLinks;
    }

    private TreeSet<MacroscopicLink> findStopLocationLinksForStation(OsmEntity stationEntity, TransferZone transferZone, String referenceOsmMode, Envelope searchBoundingBox, Integer maxMatches) {
        MacroscopicLink idealAccessLink;
        Collection<MacroscopicLink> directionModeSpatiallyCompatibleLinks = this.findModeBBoxVerticalLayerIdxCompatibleLinksForTransferZone(transferZone, stationEntity.getId(), referenceOsmMode, searchBoundingBox);
        if (directionModeSpatiallyCompatibleLinks == null || directionModeSpatiallyCompatibleLinks.isEmpty()) {
            return null;
        }
        TreeSet<MacroscopicLink> chosenLinksForStopLocations = null;
        Pair<MacroscopicLink, Set<LinkSegment>> idealAccessResult = this.findMostAppropriateStopLocationLinkForWaitingArea(transferZone, referenceOsmMode, directionModeSpatiallyCompatibleLinks);
        MacroscopicLink macroscopicLink = idealAccessLink = idealAccessResult == null ? null : (MacroscopicLink)idealAccessResult.first();
        if (idealAccessLink == null) {
            throw new PlanItRunTimeException("No appropriate link could be found from selection of eligible closeby links when finding stop locations for station %s, this should not happen", new Object[]{transferZone.getExternalId()});
        }
        if (maxMatches == 1) {
            chosenLinksForStopLocations = new TreeSet<MacroscopicLink>();
            chosenLinksForStopLocations.add(idealAccessLink);
        } else if (maxMatches > 1) {
            chosenLinksForStopLocations = new TreeSet();
            LineSegment stationToClosestPointOnClosestLinkSegment = null;
            if (Osm4JUtils.getEntityType(stationEntity) == EntityType.Node) {
                Coordinate closestCoordinate = OsmNodeUtils.findClosestProjectedCoordinateTo((OsmNode)stationEntity, idealAccessLink.getGeometry(), this.getGeoUtils());
                Point osmStationLocation = PlanitJtsUtils.createPoint((Coordinate)OsmNodeUtils.createCoordinate((OsmNode)stationEntity));
                stationToClosestPointOnClosestLinkSegment = PlanitJtsUtils.createLineSegment((Coordinate)osmStationLocation.getCoordinate(), (Coordinate)closestCoordinate);
            } else if (Osm4JUtils.getEntityType(stationEntity) == EntityType.Way) {
                stationToClosestPointOnClosestLinkSegment = OsmWayUtils.findMinimumLineSegmentBetween((OsmWay)stationEntity, idealAccessLink.getGeometry(), this.getZoningReaderData().getOsmData().getOsmNodeData().getRegisteredOsmNodes(), this.getGeoUtils());
            } else {
                throw new PlanItRunTimeException("Unknown entity type %s for osm station encountered, this should not happen", new Object[]{Osm4JUtils.getEntityType(stationEntity).toString()});
            }
            LineSegment interSectionLineSegment = this.getGeoUtils().createExtendedLineSegment(stationToClosestPointOnClosestLinkSegment, this.getSettings().getStationToParallelTracksSearchRadiusMeters(), true, true);
            LineString virtualInterSectionGeometryForParallelTracks = PlanitJtsUtils.createLineString((Coordinate[])new Coordinate[]{interSectionLineSegment.getCoordinate(0), interSectionLineSegment.getCoordinate(1)});
            for (MacroscopicLink link : directionModeSpatiallyCompatibleLinks) {
                if (!link.getGeometry().intersects((Geometry)virtualInterSectionGeometryForParallelTracks)) continue;
                LinearLocation closestLinkLinearLocation = this.getGeoUtils().getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(transferZone.getGeometry(), link.getGeometry());
                Coordinate closestLinkLocation = closestLinkLinearLocation.getCoordinate((Geometry)link.getGeometry());
                double distanceStationToPotentialAccessLink = this.getGeoUtils().getClosestDistanceInMeters(closestLinkLocation, transferZone.getGeometry());
                if (!(distanceStationToPotentialAccessLink < this.getSettings().getStationToWaitingAreaSearchRadiusMeters())) continue;
                chosenLinksForStopLocations.add(link);
            }
        } else if (maxMatches < 1) {
            LOGGER.severe(String.format("Invalid number of maximum matches %d provided when finding stop location links for station %d", maxMatches, stationEntity.getId()));
            return null;
        }
        if (chosenLinksForStopLocations == null || chosenLinksForStopLocations.isEmpty()) {
            throw new PlanItRunTimeException("No links could be identified from virtual line connecting station to closest by point on closest link for osm station %d, this should not happen", new Object[]{stationEntity.getId()});
        }
        return chosenLinksForStopLocations;
    }

    private void processLandBasedStationNotPartOfStopArea(OsmEntity osmStation, Collection<String> eligibleOsmModes, Envelope eligibleSearchBoundingBox) {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmStation);
        OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
        HashSet<TransferZone> matchedTransferZones = new HashSet<TransferZone>();
        Collection<TransferZone> potentialTransferZones = this.getZoningReaderData().getPlanitData().getTransferZonesSpatially(eligibleSearchBoundingBox);
        if (potentialTransferZones != null && !potentialTransferZones.isEmpty()) {
            Set<TransferZoneGroup> potentialTransferZoneGroups = this.getTransferZoneGroupHelper().findModeCompatibleTransferZoneGroups(eligibleOsmModes, potentialTransferZones, false);
            if (potentialTransferZoneGroups != null && !potentialTransferZoneGroups.isEmpty()) {
                if (!potentialTransferZoneGroups.isEmpty()) {
                    TransferZone closestZone = PlanitTransferZoneUtils.findTransferZoneClosestByTransferGroup(osmStation, potentialTransferZoneGroups, this.getZoningReaderData().getOsmData().getOsmNodeData().getRegisteredOsmNodes(), false, this.getGeoUtils());
                    Set groups = closestZone.getTransferZoneGroups();
                    groups.stream().sorted(Comparator.comparing(IdAble::getId)).forEach(group -> {
                        TransferZoneGroupHelper.updateTransferZoneGroupName(group, osmStation, tags);
                        for (TransferZone zone : group.getTransferZones()) {
                            PlanitTransferZoneUtils.updateTransferZoneStationName(zone, tags);
                            matchedTransferZones.add(zone);
                        }
                    });
                }
            } else {
                Set<TransferZone> modeCompatibleTransferZones = this.getTransferZoneHelper().filterModeCompatibleTransferZones(eligibleOsmModes, potentialTransferZones, true, false);
                if (modeCompatibleTransferZones != null && !modeCompatibleTransferZones.isEmpty()) {
                    for (TransferZone zone : modeCompatibleTransferZones) {
                        PlanitTransferZoneUtils.updateTransferZoneStationName(zone, tags);
                        matchedTransferZones.add(zone);
                    }
                }
            }
        }
        if (matchedTransferZones.isEmpty()) {
            if (!eligibleOsmModes.isEmpty()) {
                this.extractStandAloneStation(osmStation, tags, this.getGeoUtils());
            }
        } else if (LOGGER.getLevel() == Level.FINE) {
            String transferZonesExternalId = matchedTransferZones.stream().map(z -> z.getExternalId()).collect(Collectors.toSet()).toString();
            LOGGER.fine(String.format("Station %d mapped to platform/pole(s) %s", osmStation.getId(), transferZonesExternalId));
        }
    }

    private void processStationsNotPartOfStopArea(Set<OsmEntity> unprocessedStations, EntityType type, OsmPtVersionScheme ptVersion) {
        if (unprocessedStations != null) {
            unprocessedStations.stream().sorted(Comparator.comparing(OsmEntity::getId)).forEach(osmStation -> {
                Collection eligibleOsmModes;
                OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
                Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmStation);
                Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmStation, tags, OsmModeUtils.identifyPtv1DefaultMode(osmStation.getId(), (Map<String, String>)tags, true));
                if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
                    return;
                }
                Collection collection = eligibleOsmModes = modeResult != null ? (Collection)modeResult.first() : null;
                if (networkSettings.isWaterwayParserActive() && OsmPtv1Tags.isFerryTerminal(tags) && OsmWaterModeTags.containsAnyMode(eligibleOsmModes)) {
                    if (type != EntityType.Node) {
                        LOGGER.warning(String.format("DISCARD: Found Ptv2 stand alone station (%d) that is tagged as ferry terminal, but that is not an OSM node, verify correctness (tags: %s)", osmStation.getId(), tags));
                    } else {
                        this.processStandAloneFerryStop((OsmNode)osmStation, TransferZoneType.PLATFORM);
                    }
                } else {
                    Envelope boundingBox = OsmBoundingAreaUtils.createBoundingBoxForOsmWay(osmStation, this.getSettings().getStationToWaitingAreaSearchRadiusMeters(), this.getZoningReaderData().getOsmData().getOsmNodeData().getRegisteredOsmNodes(), this.getGeoUtils());
                    if (boundingBox != null) {
                        this.processLandBasedStationNotPartOfStopArea((OsmEntity)osmStation, eligibleOsmModes, boundingBox);
                    }
                }
                this.getZoningReaderData().getOsmData().removeUnproccessedStation(ptVersion, (OsmEntity)osmStation);
                switch (ptVersion) {
                    case VERSION_1: {
                        this.getProfiler().incrementOsmPtv1TagCounter("station");
                        break;
                    }
                    case VERSION_2: {
                        this.getProfiler().incrementOsmPtv2TagCounter("station");
                        break;
                    }
                    default: {
                        LOGGER.severe(String.format("Unknown Pt version found %s when processing station %s not part of a stop_area", osmStation.getId(), ptVersion.toString()));
                    }
                }
            });
        }
    }

    private void processStationsNotPartOfStopArea() {
        HashSet<OsmEntity> unprocessedStations;
        OsmZoningReaderOsmData osmData = this.getZoningReaderData().getOsmData();
        if (!osmData.getUnprocessedPtv1Stations(EntityType.Node).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv1Stations(EntityType.Node).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Node, OsmPtVersionScheme.VERSION_1);
        }
        if (!osmData.getUnprocessedPtv1Stations(EntityType.Way).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv1Stations(EntityType.Way).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Way, OsmPtVersionScheme.VERSION_1);
        }
        if (!osmData.getUnprocessedPtv2Stations(EntityType.Node).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv2Stations(EntityType.Node).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Node, OsmPtVersionScheme.VERSION_2);
        }
        if (!osmData.getUnprocessedPtv2Stations(EntityType.Way).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv2Stations(EntityType.Way).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Way, OsmPtVersionScheme.VERSION_2);
        }
    }

    private boolean processStandAloneFerryStop(OsmNode osmFerryStop, TransferZoneType transferZoneType) {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmFerryStop);
        boolean terminalOnNetworkNode = this.hasNetworkLayersWithActiveOsmNode(osmFerryStop.getId());
        if (terminalOnNetworkNode && this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmFerryStop.getId())) {
            Pair<EntityType, Long> result = this.getSettings().getOverwrittenWaitingAreaOfStopLocation(osmFerryStop.getId());
            TransferZone ferryTerminalTransferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId((EntityType)result.first(), (Long)result.second());
            LOGGER.fine(String.format("Mapped ferry stop %d to overwritten waiting area %d", osmFerryStop.getId(), result.second()));
            PlanitTransferZoneUtils.updateTransferZoneStationName(ferryTerminalTransferZone, tags);
            return true;
        }
        String defaultMode = "ferry";
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmFerryStop, tags, "ferry");
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return false;
        }
        if (!terminalOnNetworkNode && this.getSettings().isConnectDanglingFerryStopToNearbyFerryRoute()) {
            this.connectDanglingFerryStopToNearbyFerryRoute(osmFerryStop, defaultMode, false);
            terminalOnNetworkNode = this.hasNetworkLayersWithActiveOsmNode(osmFerryStop.getId());
        }
        if (terminalOnNetworkNode) {
            TransferZone createdTransferZone = this.getTransferZoneHelper().createAndRegisterTransferZoneWithConnectoidsAtOsmNode(osmFerryStop, tags, defaultMode, transferZoneType, this.getGeoUtils());
            return createdTransferZone != null;
        }
        LOGGER.severe(String.format("DISCARD: Ferry stop OSM node (%d) is stop location, but not connected to ferry network, if to be kept consider activating connecting dangling ferry stops option", osmFerryStop.getId()));
        return false;
    }

    private void connectDanglingFerryStopToNearbyFerryRoute(OsmNode osmFerryStop, String osmMode, boolean suppressLogging) {
        Point ferryStopLocation = OsmNodeUtils.createPoint(osmFerryStop);
        PredefinedMode planitWaterMode = this.getReferenceNetwork().getModes().get(this.getNetworkToZoningData().getNetworkSettings().getWaterwaySettings().getMappedPlanitWaterMode(osmMode));
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getReferenceNetwork().getLayerByMode((Mode)planitWaterMode);
        Envelope boundingBox = this.getGeoUtils().createBoundingBox(ferryStopLocation.getEnvelopeInternal(), this.getSettings().getFerryStopToFerryRouteSearchRadiusMeters());
        Collection<MacroscopicLink> spatiallyMatchedLinks = this.getZoningReaderData().getPlanitData().findLinksSpatially(boundingBox);
        spatiallyMatchedLinks.removeIf(l -> !l.isModeAllowedOnAnySegment((Mode)planitWaterMode));
        if (spatiallyMatchedLinks.isEmpty()) {
            LOGGER.warning(String.format("DISCARD: Dangling ferry stop %d, no mode compatible OSM ways within %.2fm found (tags: %s)", osmFerryStop.getId(), this.getSettings().getFerryStopToFerryRouteSearchRadiusMeters(), OsmModelUtil.getTagsAsMap((OsmEntity)osmFerryStop)));
            return;
        }
        Pair closestLinkWithDistance = PlanitEntityGeoUtils.findPlanitEntityClosest((Coordinate)OsmNodeUtils.createCoordinate(osmFerryStop), spatiallyMatchedLinks, (double)this.getSettings().getFerryStopToFerryRouteSearchRadiusMeters(), (boolean)suppressLogging, (PlanitJtsCrsUtils)this.getGeoUtils());
        Node ferryStopNode = PlanitNetworkLayerUtils.createPopulateAndRegisterNode(osmFerryStop, networkLayer, this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer));
        Pair closestNodeWithDistance = PlanitEntityGeoUtils.findPlanitEntityClosest((Coordinate)ferryStopLocation.getCoordinate(), Set.of(((MacroscopicLink)closestLinkWithDistance.first()).getNodeA(), ((MacroscopicLink)closestLinkWithDistance.first()).getNodeB()), (double)Double.MAX_VALUE, (boolean)suppressLogging, (PlanitJtsCrsUtils)this.getGeoUtils());
        LineString lineString = PlanitJtsUtils.createLineString((Coordinate[])new Coordinate[]{ferryStopLocation.getCoordinate(), ((Node)closestNodeWithDistance.first()).getPosition().getCoordinate()});
        MacroscopicLink ferryLink = PlanitNetworkLayerUtils.createPopulateAndRegisterLink(ferryStopNode, (Node)closestNodeWithDistance.first(), lineString, networkLayer, null, "dummy-ferry-link", this.getGeoUtils());
        String waterWayKey = "route";
        String waterWayValue = "ferry";
        MacroscopicLinkSegmentType linkSegmentType = this.getReferenceNetwork().getDefaultLinkSegmentTypeByOsmTag(waterWayKey, waterWayValue).get(networkLayer);
        Double speedLimit = this.getNetworkToZoningData().getNetworkSettings().getWaterwaySettings().getDefaultSpeedLimitByOsmWaterwayType(waterWayValue);
        Integer lanes = this.getNetworkToZoningData().getNetworkSettings().getDefaultDirectionalLanesByWayType(waterWayKey, waterWayValue);
        PlanitNetworkLayerUtils.createPopulateAndRegisterLinkSegment(ferryLink, true, linkSegmentType, speedLimit, lanes, networkLayer);
        PlanitNetworkLayerUtils.createPopulateAndRegisterLinkSegment(ferryLink, false, linkSegmentType, speedLimit, lanes, networkLayer);
        this.getNetworkToZoningData().registerNetworkOsmNode(osmFerryStop);
    }

    private void processPtv1FerryTerminalsNotPartOfStopArea() {
        OsmZoningReaderOsmData osmData = this.getZoningReaderData().getOsmData();
        if (!this.getNetworkToZoningData().getNetworkSettings().isWaterwayParserActive()) {
            return;
        }
        osmData.getUnprocessedPtv1FerryTerminals().entrySet().stream().map(e -> (OsmNode)e.getValue()).forEach(unprocessedFerryTerminal -> {
            TransferZoneType ptv1TransferZoneType = PlanitTransferZoneUtils.extractTransferZoneTypeFromPtv1Tags(unprocessedFerryTerminal, OsmModelUtil.getTagsAsMap((OsmEntity)unprocessedFerryTerminal));
            this.processStandAloneFerryStop((OsmNode)unprocessedFerryTerminal, ptv1TransferZoneType);
            this.getProfiler().incrementOsmPtv1TagCounter("ferry_terminal");
        });
        osmData.removeAllUnprocessedPtv1FerryTerminals();
    }

    private void processStopPositionNotPartOfStopArea(OsmNode osmNode, Map<String, String> tags) {
        this.getZoningReaderData().getOsmData().removeUnprocessedStopPosition(osmNode.getId());
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(osmNode.getId(), tags, true);
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmNode, tags, defaultOsmMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return;
        }
        Collection eligibleOsmModes = (Collection)modeResult.first();
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        for (String osmMode : eligibleOsmModes) {
            PredefinedModeType accessModeType = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitModeType(osmMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getReferenceNetwork().getLayerByPredefinedModeType(accessModeType);
            if (this.getNetworkToZoningData().getNetworkSettings().isWaterwayParserActive() && OsmWaterModeTags.isWaterModeTag(osmMode)) {
                this.processStandAloneFerryStop(osmNode, TransferZoneType.PLATFORM);
                continue;
            }
            if (!this.getNetworkToZoningData().getNetworkLayerData((NetworkLayer)networkLayer).isLocationPresentInLayer(osmNodeLocation)) {
                LOGGER.fine(String.format("DISCARD: stop_location %d is not part of any parsed link in the network, likely incorrectly tagged", osmNode.getId()));
                continue;
            }
            TreeSet<String> singletonSet = new TreeSet<String>();
            singletonSet.add(osmMode);
            Collection<TransferZone> matchedTransferZones = this.getTransferZoneHelper().findTransferZonesForStopPosition(osmNode, tags, singletonSet, false);
            boolean suppressLogging = this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmNode.getId());
            if (!suppressLogging && (matchedTransferZones == null || matchedTransferZones.isEmpty())) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: stop_position %d has no valid pole, platform, station reference, nor close-by infrastructure that qualifies as such for mode %s (tags %s)", osmNode.getId(), osmMode, tags), (Geometry)osmNodeLocation);
                return;
            }
            boolean locationIsKnownOsmStopPosition = true;
            for (TransferZone transferZone : matchedTransferZones) {
                this.getConnectoidHelper().extractDirectedConnectoidsForMode(osmNode, locationIsKnownOsmStopPosition, transferZone, accessModeType, suppressLogging, this.getGeoUtils());
            }
        }
    }

    private void processStopPositionsNotPartOfStopArea() {
        TreeMap<Long, OsmNode> unprocessedStopPositions = new TreeMap<Long, OsmNode>(this.getZoningReaderData().getOsmData().getUnprocessedStopPositions());
        if (unprocessedStopPositions.isEmpty()) {
            return;
        }
        unprocessedStopPositions.entrySet().stream().map(e -> (OsmNode)e.getValue()).forEach(osmNode -> {
            if (osmNode == null) {
                LOGGER.severe(String.format("OSM node %d representing stop position not available in memory, unable to extract stop position", osmNode.getId()));
                return;
            }
            this.processStopPositionNotPartOfStopArea((OsmNode)osmNode, OsmModelUtil.getTagsAsMap((OsmEntity)osmNode));
        });
    }

    private void processIncompleteTransferZone(TransferZone transferZone) {
        boolean transferZoneOnInfrastructure;
        if (transferZone.getExternalId().equals("2819919872")) {
            int n = 4;
        }
        EntityType osmEntityType = PlanitTransferZoneUtils.transferZoneGeometryToOsmEntityType(transferZone.getGeometry());
        long osmEntityId = Long.valueOf(transferZone.getExternalId());
        TreeSet<String> accessOsmModes = OsmModeUtils.extractPublicTransportModesFrom(PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(transferZone));
        if (!this.getNetworkToZoningData().getNetworkSettings().hasAnyMappedPlanitModeType(accessOsmModes)) {
            LOGGER.warning(String.format("DISCARD: Waiting area (OSM id %d) has no supported public transport planit modes present", osmEntityId));
            return;
        }
        boolean bl = transferZoneOnInfrastructure = osmEntityType.equals((Object)EntityType.Node) && this.hasNetworkLayersWithActiveOsmNode(osmEntityId);
        if (transferZoneOnInfrastructure) {
            LOGGER.severe(String.format("DISCARD: Waiting area (OSM id %d) on top of road/rail/waterway infrastructure did not yet receive connectoids (stop location), this shouldn't happen, verify correctness", osmEntityId));
            return;
        }
        for (String osmAccessMode : accessOsmModes) {
            PredefinedModeType accessModeType = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitModeType(osmAccessMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getReferenceNetwork().getLayerByPredefinedModeType(accessModeType);
            MacroscopicLink selectedAccessLink = null;
            if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmEntityId, osmEntityType)) {
                long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmEntityId, osmEntityType);
                selectedAccessLink = PlanitLinkOsmUtils.getClosestLinkWithOsmWayIdToGeometry(osmWayId, transferZone.getGeometry(), networkLayer, this.getGeoUtils());
                if (selectedAccessLink == null) {
                    LOGGER.warning(String.format("DISCARD: User nominated OSM way %d not available for waiting area %s", osmWayId, transferZone.getExternalId()));
                    return;
                }
            } else {
                if (OsmWaterModeTags.isWaterModeTag(osmAccessMode)) {
                    LOGGER.warning(String.format("DISCARD: Ptv2 platform (%d) for water mode %s without stop_position/ferry_terminal and disconnected from waterway network, ignore", osmEntityId, osmAccessMode));
                    continue;
                }
                Envelope searchBoundingBox = this.getGeoUtils().createBoundingBox(transferZone.getEnvelope(), this.getSettings().getStopToWaitingAreaSearchRadiusMeters());
                Collection<MacroscopicLink> modeSpatiallyCompatibleLinks = this.findModeBBoxVerticalLayerIdxCompatibleLinksForTransferZone(transferZone, osmEntityId, osmAccessMode, searchBoundingBox);
                if (modeSpatiallyCompatibleLinks == null || modeSpatiallyCompatibleLinks.isEmpty()) {
                    this.logWarningIfNotNearBoundingBox(String.format("DISCARD: No accessible links (max distance %.2fm) for waiting area %s (mode: %s), tagging error or consider activating more road types)", this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), transferZone.getExternalId(), osmAccessMode), transferZone.getGeometry());
                    continue;
                }
                Pair<MacroscopicLink, Set<LinkSegment>> accessResult = this.findMostAppropriateStopLocationLinkForWaitingArea(transferZone, osmAccessMode, modeSpatiallyCompatibleLinks);
                MacroscopicLink macroscopicLink = selectedAccessLink = accessResult == null ? null : (MacroscopicLink)accessResult.first();
            }
            if (selectedAccessLink == null) continue;
            this.getConnectoidHelper().extractDirectedConnectoidsForStandAloneTransferZoneByPlanitLink(Long.parseLong(transferZone.getExternalId()), transferZone.getGeometry(), selectedAccessLink, transferZone, accessModeType, this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), networkLayer, false);
        }
    }

    private void processIncompleteTransferZones(SortedSet<TransferZone> transferZones) {
        TreeSet<TransferZone> unprocessedTransferZones = new TreeSet<TransferZone>(transferZones);
        for (TransferZone transferZone : unprocessedTransferZones) {
            if (this.getZoningReaderData().getPlanitData().hasConnectoids(transferZone)) continue;
            this.processIncompleteTransferZone(transferZone);
        }
    }

    private void processIncompleteTransferZones() {
        this.processIncompleteTransferZones(this.getZoningReaderData().getPlanitData().getTransferZonesByOsmId(EntityType.Node));
        this.processIncompleteTransferZones(this.getZoningReaderData().getPlanitData().getTransferZonesByOsmId(EntityType.Way));
    }

    private void extractStandAloneStationConnectoids(OsmEntity osmStation, Map<String, String> tags, TransferZone stationTransferZone, SortedSet<String> osmAccessModes, PlanitJtsCrsUtils geoUtils) {
        EntityType osmStationEntityType = Osm4JUtils.getEntityType(osmStation);
        for (String osmAccessMode : osmAccessModes) {
            PredefinedModeType accessModeType = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitModeType(osmAccessMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getReferenceNetwork().getLayerByPredefinedModeType(accessModeType);
            Pair<Double, Integer> result = OsmZoningPostProcessingHandler.determineSearchDistanceAndMaxStopLocationMatchesForStandAloneStation(osmStation.getId(), osmAccessMode, this.getSettings());
            if (result == null) {
                LOGGER.warning(String.format("DISCARD: unable to process stand-alone station %d supported mode %s, skip", osmStation.getId(), osmAccessMode));
                continue;
            }
            double maxSearchDistance = (Double)result.first();
            int maxStopLocations = (Integer)result.second();
            TreeSet<Object> accessLinks = null;
            if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmStation.getId(), osmStationEntityType)) {
                long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmStation.getId(), osmStationEntityType);
                MacroscopicLink nominatedLink = PlanitLinkOsmUtils.getClosestLinkWithOsmWayIdToGeometry(osmWayId, stationTransferZone.getGeometry(), networkLayer, geoUtils);
                if (nominatedLink != null) {
                    accessLinks = new TreeSet();
                    accessLinks.add(nominatedLink);
                } else {
                    LOGGER.severe(String.format("User nominated OSM way not available for station %d", osmWayId));
                }
            } else {
                Envelope searchBoundingBox = OsmBoundingAreaUtils.createBoundingBoxForOsmWay(osmStation, maxSearchDistance, this.getZoningReaderData().getOsmData().getOsmNodeData().getRegisteredOsmNodes(), geoUtils);
                accessLinks = this.findStopLocationLinksForStation(osmStation, stationTransferZone, osmAccessMode, searchBoundingBox, maxStopLocations);
            }
            if (accessLinks == null) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: Station %d without eligible access links for pt vehicles as stop locations (tags %s)", osmStation.getId(), tags), stationTransferZone.getGeometry());
                return;
            }
            for (MacroscopicLink macroscopicLink : accessLinks) {
                this.getConnectoidHelper().extractDirectedConnectoidsForStandAloneTransferZoneByPlanitLink(osmStation.getId(), stationTransferZone.getGeometry(), macroscopicLink, stationTransferZone, accessModeType, this.getSettings().getStationToWaitingAreaSearchRadiusMeters(), networkLayer, false);
            }
        }
    }

    private void extractStandAloneStation(OsmEntity osmStation, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        boolean stationOnTrack;
        String defaultMode = OsmModeUtils.identifyPtv1DefaultMode(osmStation.getId(), tags, "train");
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmStation, tags, defaultMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return;
        }
        SortedSet osmAccessModes = (SortedSet)modeResult.first();
        TransferZone stationTransferZone = null;
        EntityType osmStationEntityType = Osm4JUtils.getEntityType(osmStation);
        boolean bl = stationOnTrack = EntityType.Node.equals((Object)osmStationEntityType) && this.hasNetworkLayersWithActiveOsmNode(osmStation.getId());
        if (stationOnTrack && !this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmStation.getId())) {
            OsmNode osmStationNode = this.getNetworkToZoningData().getNetworkOsmNodes().get(osmStation.getId());
            if (osmStationNode == null) {
                LOGGER.severe(String.format("DISCARD: Station node (%d) expected to be also a stop location, yet OSM node not present on underlying network", osmStation.getId()));
            }
            TransferZoneType ptv1TransferZoneType = PlanitTransferZoneUtils.extractTransferZoneTypeFromPtv1Tags(osmStationNode, tags);
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithConnectoidsAtOsmNode(osmStationNode, tags, defaultMode, ptv1TransferZoneType, geoUtils);
        } else {
            if (this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmStation.getId())) {
                Pair<EntityType, Long> result = this.getSettings().getOverwrittenWaitingAreaOfStopLocation(osmStation.getId());
                stationTransferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId((EntityType)result.first(), (Long)result.second());
                LOGGER.fine(String.format("Mapped station stop_position %d to overwritten waiting area %d", osmStation.getId(), result.second()));
            } else {
                stationTransferZone = this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmStation, tags, TransferZoneType.SMALL_STATION, defaultMode, geoUtils);
            }
            if (stationTransferZone == null) {
                LOGGER.warning(String.format("DISCARD: Unable to create transfer zone for osm station %d", osmStation.getId()));
                return;
            }
            PlanitTransferZoneUtils.updateTransferZoneStationName(stationTransferZone, tags);
            if (this.getSettings().isWaitingAreaOfStopLocationOverwritten(osmStationEntityType, osmStation.getId())) {
                return;
            }
            this.extractStandAloneStationConnectoids(osmStation, tags, stationTransferZone, osmAccessModes, geoUtils);
        }
    }

    private void extractRemainingOsmEntitiesNotPartOfStopArea() throws PlanItException {
        this.processStationsNotPartOfStopArea();
        this.processPtv1FerryTerminalsNotPartOfStopArea();
        this.processStopPositionsNotPartOfStopArea();
        this.processIncompleteTransferZones();
    }

    private void extractKnownPtv2StopAreaStopPosition(OsmNode osmNode, Map<String, String> tags, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmNode, tags, null);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return;
        }
        Collection<TransferZone> matchedTransferZones = this.getTransferZoneHelper().findTransferZonesForStopPosition(osmNode, tags, (SortedSet)modeResult.first(), transferZoneGroup, suppressLogging);
        boolean bl = suppressLogging = suppressLogging || this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmNode.getId());
        if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
            if (!suppressLogging) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: Stop position %d in stop_area %s has no valid pole, platform, station reference, wharf, nor close-by infrastructure that qualifies (tags: %s)", osmNode.getId(), transferZoneGroup.getExternalId(), tags.toString()), (Geometry)OsmNodeUtils.createPoint(osmNode));
            }
            return;
        }
        boolean locationIsKnownOsmStopPosition = true;
        this.getConnectoidHelper().extractDirectedConnectoids(osmNode, locationIsKnownOsmStopPosition, matchedTransferZones, (Collection)modeResult.second(), transferZoneGroup, suppressLogging);
    }

    private void extractUnknownPtv2StopAreaStopPosition(OsmNode osmNode, Map<String, String> tags, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> eligibleModes;
        if (osmNode.getId() == 1281064369L) {
            int n = 4;
        }
        SortedSet eligibleOsmModes = (eligibleModes = this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmNode, tags, null)) != null ? (SortedSet)eligibleModes.first() : null;
        Collection<TransferZone> matchedTransferZones = this.getTransferZoneHelper().findTransferZonesForStopPosition(osmNode, tags, eligibleOsmModes, transferZoneGroup, suppressLogging);
        boolean bl = suppressLogging = suppressLogging || this.getSettings().isOverwriteWaitingAreaOfStopLocation(osmNode.getId());
        if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
            if (!suppressLogging && OsmModeUtils.hasMappedPlanitMode(this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmNode, tags, OsmModeUtils.identifyPtv1DefaultMode(osmNode.getId(), tags, true)))) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: Stop_position %d without proper tagging on OSM network could not be mapped to close-by transfer zone in stop_area (tags: %s)", osmNode.getId(), tags.toString()), (Geometry)OsmNodeUtils.createPoint(osmNode));
            }
            return;
        }
        if (!suppressLogging && matchedTransferZones.size() > 1) {
            LOGGER.severe(String.format("Identified multiple Spatially closest transfer zones (%s) for stop_position %d that was not tagged as such in stop_area %s, this should not happen", matchedTransferZones.stream().map(tz -> tz.getIdsAsString()).collect(Collectors.joining(",")), osmNode.getId(), transferZoneGroup.getExternalId()));
        }
        TransferZone foundZone = matchedTransferZones.iterator().next();
        SortedSet<PredefinedModeType> accessModeTypes = this.getNetworkToZoningData().getNetworkSettings().getActivatedPlanitModeTypes(PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(foundZone));
        if (accessModeTypes == null) {
            if (!suppressLogging) {
                LOGGER.warning(String.format("DISCARD: Stop_position %d without proper tagging on OSM network, unable to identify access modes from closest transfer zone in stop_area (tags: %s)", osmNode.getId(), tags.toString()));
            }
            return;
        }
        boolean locationIsKnownOsmStopPosition = false;
        boolean success = this.getConnectoidHelper().extractDirectedConnectoids(osmNode, locationIsKnownOsmStopPosition, Collections.singleton(foundZone), accessModeTypes, transferZoneGroup, suppressLogging);
        if (!suppressLogging && success) {
            LOGGER.info(String.format("SALVAGED: Stop_position %d in stop_area not marked as such on OSM node, mapped to most likely transfer zone (%s) in stop_area instead, verify correctness (tags %s)", osmNode.getId(), foundZone.getIdsAsString(), tags.toString()));
        }
    }

    private void extractPtv2StopAreaStopPosition(OsmRelationMember member, TransferZoneGroup transferZoneGroup, boolean suppressLogging) {
        PlanItRunTimeException.throwIfNull((Object)member, (String)"Stop_area stop role member null");
        OsmZoningReaderOsmData osmData = this.getZoningReaderData().getOsmData();
        if (osmData.isIgnoreStopAreaStopPosition(member.getType(), member.getId())) {
            return;
        }
        this.getProfiler().incrementOsmPtv2TagCounter("stop_position");
        if (member.getType() != EntityType.Node) {
            if (!suppressLogging) {
                LOGGER.severe(String.format("DISCARD: Stop_position %d encountered that it not an OSM node, this is not permitted", member.getId()));
            }
            return;
        }
        OsmNode stopPositionNode = this.getNetworkToZoningData().getNetworkOsmNodes().get(member.getId());
        if (stopPositionNode == null) {
            if (!this.getSettings().hasBoundingPolygon() && !suppressLogging) {
                LOGGER.warning(String.format("DISCARD: Unable to extract ptv2 stop position %d in OSM relation (stop area) %s, OSM node missing", member.getId(), transferZoneGroup.getExternalId()));
            }
            return;
        }
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)stopPositionNode);
        if (osmData.hasUnprocessedStopPosition(member.getId())) {
            this.extractKnownPtv2StopAreaStopPosition(stopPositionNode, tags, transferZoneGroup, suppressLogging);
            osmData.removeUnprocessedStopPosition(stopPositionNode.getId());
            return;
        }
        if (osmData.hasUnprocessedPtv1FerryTerminal(stopPositionNode.getId())) {
            this.extractKnownPtv2StopAreaStopPosition(stopPositionNode, tags, transferZoneGroup, suppressLogging);
            osmData.removeUnprocessedPtv1FerryTerminal(stopPositionNode.getId());
        } else {
            boolean isPtv2NodeOnly = !OsmPtVersionSchemeUtils.isPtv2StopPositionPtv1Stop(stopPositionNode, tags);
            boolean alreadyProcessed = this.getZoningReaderData().getPlanitData().hasAnyDirectedConnectoidsForLocation(OsmNodeUtils.createPoint(stopPositionNode));
            if (isPtv2NodeOnly && alreadyProcessed && !suppressLogging) {
                LOGGER.fine(String.format("Stop_position %d present in multiple stop_areas, discouraged tagging behaviour, consider re-tagging", member.getId()));
            }
            if (alreadyProcessed) {
                return;
            }
            if (!suppressLogging) {
                LOGGER.fine(String.format("Stop_position %d in stop_area not marked as such on OSM node, inferring transfer zone and access modes by geographically closest transfer zone in stop_area instead ", member.getId()));
            }
            this.extractUnknownPtv2StopAreaStopPosition(stopPositionNode, tags, transferZoneGroup, suppressLogging);
        }
    }

    private void extractPtv2StopAreaPostProcessingEntities(OsmRelation osmRelation) throws PlanItException {
        TransferZoneGroup transferZoneGroup = this.getZoningReaderData().getPlanitData().getTransferZoneGroupByOsmId(osmRelation.getId());
        if (transferZoneGroup == null) {
            LOGGER.severe(String.format("Found stop_area %d in post-processing for which no PLANit transfer zone group has been created, this should not happen", osmRelation.getId()));
        }
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember member = osmRelation.getMember(index);
            if (this.skipOsmPtEntity(member) || !member.getRole().equals("stop")) continue;
            boolean suppressLogging = this.getSettings().isSuppressOsmRelationStopAreaLogging(osmRelation.getId()) || this.getZoningReaderData().getOsmData().isWaitingAreaWithoutMappedPlanitMode(member.getType(), member.getId()) || this.getZoningReaderData().getOsmData().isIgnoreStopAreaStopPosition(member.getType(), member.getId());
            this.extractPtv2StopAreaStopPosition(member, transferZoneGroup, suppressLogging);
        }
    }

    public OsmZoningPostProcessingHandler(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData handlerData, OsmNetworkToZoningReaderData network2ZoningData, PlanitOsmNetwork referenceNetwork, Zoning zoningToPopulate, OsmZoningHandlerProfiler profiler) {
        super(transferSettings, handlerData, network2ZoningData, referenceNetwork, zoningToPopulate, profiler);
    }

    @Override
    public void initialiseBeforeParsing() {
        this.reset();
        PlanItRunTimeException.throwIf((this.getReferenceNetwork().getTransportLayers() == null || ((MacroscopicNetworkLayers)this.getReferenceNetwork().getTransportLayers()).size() <= 0 ? 1 : 0) != 0, (String)"Network is expected to be populated at start of parsing OSM zoning", (Object[])new Object[0]);
        this.initialiseSpatiallyIndexedOsmNodesInternalToPlanitLinks();
    }

    public void handle(OsmRelation osmRelation) throws IOException {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmRelation);
        try {
            if (this.getSettings().isParserActive() && tags.containsKey("type") && ((String)tags.get("type")).equals("public_transport")) {
                if (OsmPtv2Tags.hasPublicTransportKeyTag(tags) && ((String)tags.get("public_transport")).equals("stop_area")) {
                    this.extractPtv2StopAreaPostProcessingEntities(osmRelation);
                } else {
                    LOGGER.fine(String.format("DISCARD: Unsupported public_transport relation %s referenced by relation %d", tags.get("public_transport"), osmRelation.getId()));
                }
            }
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM relation (id:%d) for transfer infrastructure", osmRelation.getId()));
        }
    }

    public void complete() throws IOException {
        try {
            this.extractRemainingOsmEntitiesNotPartOfStopArea();
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("error while parsing remaining osm entities not part of a stop_area");
        }
        LOGGER.fine(" OSM (transfer) zone post-processing ...DONE");
    }

    @Override
    public void reset() {
        this.spatiallyIndexedOsmNodesInternalToPlanitLinks = new HashMap<MacroscopicNetworkLayer, Quadtree>();
    }
}

